/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionFindTableRowOrColumn
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<NamedTable> _selectNamedBean = new LogixNG_SelectNamedBean<NamedTable>(this, NamedTable.class, InstanceManager.getDefault(NamedTableManager.class), this);
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnName = "";
    private boolean _includeCellsWithoutHeader = false;
    private String _localVariableNamedBean;
    private String _localVariableRow;
    private static final Logger log = LoggerFactory.getLogger(ActionFindTableRowOrColumn.class);

    public ActionFindTableRowOrColumn(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._selectNamedBean.setOnlyDirectAddressingAllowed();
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionFindTableRowOrColumn copy = new ActionFindTableRowOrColumn(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setTableRowOrColumn(this._tableRowOrColumn);
        copy.setRowOrColumnName(this._rowOrColumnName);
        copy.setIncludeCellsWithoutHeader(this._includeCellsWithoutHeader);
        copy.setLocalVariableNamedBean(this._localVariableNamedBean);
        copy.setLocalVariableRow(this._localVariableRow);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<NamedTable> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public TableRowOrColumn getTableRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setTableRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public String getRowOrColumnName() {
        return this._rowOrColumnName;
    }

    public void setRowOrColumnName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new IllegalArgumentException("Row/column name is null");
        }
        this._rowOrColumnName = rowOrColumnName;
    }

    public boolean getIncludeCellsWithoutHeader() {
        return this._includeCellsWithoutHeader;
    }

    public void setIncludeCellsWithoutHeader(boolean includeCellsWithoutHeader) {
        this._includeCellsWithoutHeader = includeCellsWithoutHeader;
    }

    public void setLocalVariableNamedBean(String localVariableNamedBean) {
        this._localVariableNamedBean = localVariableNamedBean != null && !localVariableNamedBean.isEmpty() ? localVariableNamedBean : null;
    }

    public String getLocalVariableNamedBean() {
        return this._localVariableNamedBean;
    }

    public void setLocalVariableRow(String localVariableNewValue) {
        this._localVariableRow = localVariableNewValue != null && !localVariableNewValue.isEmpty() ? localVariableNewValue : null;
    }

    public String getLocalVariableRow() {
        return this._localVariableRow;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private Map<String, Object> getRow(Object value) throws JmriException {
        if (this._selectNamedBean.getNamedBean() == null) {
            log.error("No table name is given");
            return null;
        }
        if (this._rowOrColumnName.isEmpty()) {
            log.error("rowOrColumnName is empty string");
            return null;
        }
        NamedTable table = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int row = table.getRowNumber(this._rowOrColumnName);
            for (int column = 1; column <= table.numColumns(); ++column) {
                Object cell;
                Object header = table.getCell(0, column);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty()) || (cell = table.getCell(row, column)) == null || !cell.equals(value)) continue;
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (int rowIndex = 1; rowIndex <= table.numRows(); ++rowIndex) {
                    Object subHeader = table.getCell(rowIndex, 0);
                    if (subHeader == null || subHeader.toString().isEmpty()) continue;
                    rowData.put(subHeader.toString(), table.getCell(rowIndex, column));
                }
                return rowData;
            }
        } else {
            int column = table.getColumnNumber(this._rowOrColumnName);
            for (int row = 1; row <= table.numRows(); ++row) {
                Object cell;
                Object header = table.getCell(row, 0);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty()) || (cell = table.getCell(row, column)) == null || !cell.equals(value)) continue;
                HashMap<String, Object> columnData = new HashMap<String, Object>();
                for (int colIndex = 1; colIndex <= table.numColumns(); ++colIndex) {
                    Object subHeader = table.getCell(0, colIndex);
                    if (subHeader == null || subHeader.toString().isEmpty()) continue;
                    columnData.put(subHeader.toString(), table.getCell(row, colIndex));
                }
                return columnData;
            }
        }
        return null;
    }

    @Override
    public void execute() throws JmriException {
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        if (this._localVariableNamedBean != null && this._localVariableRow != null) {
            Object value = symbolTable.getValue(this._localVariableNamedBean);
            symbolTable.setValue(this._localVariableRow, this.getRow(value));
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionFindTableRowOrColumn_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String tableName = this._selectNamedBean.getDescription(locale);
        return Bundle.getMessage(locale, "ActionFindTableRowOrColumn_Long", this._tableRowOrColumn.getOpposite().toStringLowerCase(), tableName, this._tableRowOrColumn.toStringLowerCase(), this._rowOrColumnName, this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._localVariableNamedBean);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        this._selectNamedBean.registerListeners();
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }
}

