/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.VariableLight;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;

public class ActionLight
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Light> _selectNamedBean = new LogixNG_SelectNamedBean<Light>(this, Light.class, InstanceManager.getDefault(LightManager.class), this);
    private final LogixNG_SelectEnum<LightState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])LightState.values(), (Enum)LightState.On, (PropertyChangeListener)this);
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private int _lightValue = 0;
    private static final int TOGGLE_ID = -1;
    private static final int INTENSITY_ID = -2;
    private static final int INTERVAL_ID = -3;

    public ActionLight(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLight copy = new ActionLight(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setLightValue(this._lightValue);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Light> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<LightState> getSelectEnum() {
        return this._selectEnum;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setLightValue(int value) {
        this._lightValue = value;
    }

    public int getLightValue() {
        return this._lightValue;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private int getNewData(SymbolTable symbolTable) throws JmriException {
        String newValue = "";
        switch (this._dataAddressing) {
            case Direct: {
                return this._lightValue;
            }
            case Reference: {
                newValue = ReferenceUtil.getReference(symbolTable, this._dataReference);
                break;
            }
            case LocalVariable: {
                newValue = TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
                break;
            }
            case Formula: {
                newValue = this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(symbolTable), false) : "";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + this._dataAddressing.name());
            }
        }
        try {
            int newInt = Integer.parseInt(newValue);
            if (newInt < 0) {
                newInt = 0;
            }
            if (newInt > 100) {
                newInt = 100;
            }
            return newInt;
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @Override
    public void execute() throws JmriException {
        Light light = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (light == null) {
            return;
        }
        LightState state = this._selectEnum.evaluateEnum(this.getConditionalNG());
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (state == LightState.Toggle) {
                if (light.getKnownState() == 2) {
                    light.setCommandedState(4);
                } else {
                    light.setCommandedState(2);
                }
            } else if (state == LightState.Intensity) {
                if (light instanceof VariableLight) {
                    ((VariableLight)light).setTargetIntensity((double)this.getNewData(symbolTable) / 100.0);
                } else {
                    light.setCommandedState(this.getNewData(symbolTable) > 50 ? 2 : 4);
                }
            } else if (state == LightState.Interval) {
                if (light instanceof VariableLight) {
                    ((VariableLight)light).setTransitionTime(this.getNewData(symbolTable));
                }
            } else {
                light.setCommandedState(state.getID());
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Light_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        if (this._selectEnum.getAddressing() == NamedBeanAddressing.Direct && (this._selectEnum.getEnum() == LightState.Intensity || this._selectEnum.getEnum() == LightState.Interval)) {
            String bundleKey = "Light_Long_Value";
            switch (this._dataAddressing) {
                case Direct: {
                    String type = this._selectEnum.getEnum() == LightState.Intensity ? Bundle.getMessage("Light_Intensity_Value") : Bundle.getMessage("Light_Interval_Value");
                    return Bundle.getMessage(locale, bundleKey, namedBean, type, this._lightValue);
                }
                case Reference: {
                    return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByReference", this._dataReference));
                }
                case LocalVariable: {
                    return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
                }
                case Formula: {
                    return Bundle.getMessage(locale, bundleKey, namedBean, "", Bundle.getMessage("AddressByFormula", this._dataFormula));
                }
            }
            throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
        }
        return Bundle.getMessage(locale, "Light_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum LightState {
        Off(4, Bundle.getMessage("StateOff")),
        On(2, Bundle.getMessage("StateOn")),
        Toggle(-1, Bundle.getMessage("LightToggleStatus")),
        Intensity(-2, Bundle.getMessage("LightIntensity")),
        Interval(-3, Bundle.getMessage("LightInterval")),
        Unknown(1, Bundle.getMessage("BeanStateUnknown")),
        Inconsistent(8, Bundle.getMessage("BeanStateInconsistent"));

        private final int _id;
        private final String _text;

        private LightState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static LightState get(int id) {
            switch (id) {
                case 1: {
                    return Unknown;
                }
                case 8: {
                    return Inconsistent;
                }
                case 4: {
                    return Off;
                }
                case 2: {
                    return On;
                }
                case -1: {
                    return Toggle;
                }
            }
            throw new IllegalArgumentException("invalid light state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

