/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.VariableLight;
import jmri.VariableLightManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionLightIntensity
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener {
    public static final int INTENSITY_SOCKET = 0;
    private final LogixNG_SelectNamedBean<VariableLight> _selectNamedBean = new LogixNG_SelectNamedBean<VariableLight>(this, VariableLight.class, InstanceManager.getDefault(VariableLightManager.class), this);
    private String _intensitySocketSystemName;
    private final FemaleAnalogExpressionSocket _intensitySocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionLightIntensity_SocketName"));
    private static final Logger log = LoggerFactory.getLogger(ActionLightIntensity.class);

    public ActionLightIntensity(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionLightIntensity copy = new ActionLightIntensity(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<VariableLight> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        VariableLight light = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (light == null) {
            return;
        }
        double intensity = 0.0;
        if (this._intensitySocket.isConnected()) {
            intensity = ((MaleAnalogExpressionSocket)this._intensitySocket.getConnectedSocket()).evaluate();
        }
        if (intensity < 0.0) {
            intensity = 0.0;
        }
        if (intensity > 100.0) {
            intensity = 100.0;
        }
        light.setTargetIntensity(intensity / 100.0);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._intensitySocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._intensitySocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._intensitySocketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._intensitySocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._intensitySocketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionLightIntensity_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        return Bundle.getMessage(locale, "ActionLightIntensity_Long", namedBean);
    }

    public FemaleAnalogExpressionSocket getIntensitySocket() {
        return this._intensitySocket;
    }

    public String getIntensitySocketSystemName() {
        return this._intensitySocketSystemName;
    }

    public void setIntensitySystemName(String systemName) {
        this._intensitySocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._intensitySocket.isConnected() || !this._intensitySocket.getConnectedSocket().getSystemName().equals(this._intensitySocketSystemName)) {
                String socketSystemName = this._intensitySocketSystemName;
                this._intensitySocket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._intensitySocket.disconnect();
                    if (maleSocket != null) {
                        this._intensitySocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._intensitySocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }
}

