/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanType;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionListenOnBeansLocalVariable
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanType _namedBeanType = NamedBeanType.Light;
    private boolean _listenOnAllProperties = false;
    private String _localVariableBeanToListenOn;
    private String _localVariableNamedBean;
    private String _localVariableEvent;
    private String _localVariableNewValue;
    private final Map<NamedBean, String> _namedBeansEntries = new HashMap<NamedBean, String>();
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private String _executeSocketSystemName;
    private final FemaleDigitalActionSocket _executeSocket;
    @GuardedBy(value="this")
    private final Deque<PropertyChangeEvent> _eventQueue = new ArrayDeque<PropertyChangeEvent>();
    private static final Logger log = LoggerFactory.getLogger(ActionListenOnBeansLocalVariable.class);

    public ActionListenOnBeansLocalVariable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._executeSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ShowDialog_SocketExecute"));
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionListenOnBeansLocalVariable copy = new ActionListenOnBeansLocalVariable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNamedBeanType(this._namedBeanType);
        copy.setLocalVariableBeanToListenOn(this._localVariableBeanToListenOn);
        copy.setLocalVariableNamedBean(this._localVariableNamedBean);
        copy.setLocalVariableEvent(this._localVariableEvent);
        copy.setLocalVariableNewValue(this._localVariableNewValue);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public NamedBeanType getNamedBeanType() {
        return this._namedBeanType;
    }

    public void setNamedBeanType(@Nonnull NamedBeanType namedBeanType) {
        if (namedBeanType == null) {
            throw new IllegalArgumentException("namedBeanType must not be null");
        }
        this._namedBeanType = namedBeanType;
    }

    public boolean getListenOnAllProperties() {
        return this._listenOnAllProperties;
    }

    public void setListenOnAllProperties(boolean listenOnAllProperties) {
        this._listenOnAllProperties = listenOnAllProperties;
    }

    public void setLocalVariableBeanToListenOn(String localVariableBeanToListenOn) {
        this._localVariableBeanToListenOn = localVariableBeanToListenOn != null && !localVariableBeanToListenOn.isEmpty() ? localVariableBeanToListenOn : null;
    }

    public String getLocalVariableBeanToListenOn() {
        return this._localVariableBeanToListenOn;
    }

    public void setLocalVariableNamedBean(String localVariableNamedBean) {
        this._localVariableNamedBean = localVariableNamedBean != null && !localVariableNamedBean.isEmpty() ? localVariableNamedBean : null;
    }

    public String getLocalVariableNamedBean() {
        return this._localVariableNamedBean;
    }

    public void setLocalVariableEvent(String localVariableEvent) {
        this._localVariableEvent = localVariableEvent != null && !localVariableEvent.isEmpty() ? localVariableEvent : null;
    }

    public String getLocalVariableEvent() {
        return this._localVariableEvent;
    }

    public void setLocalVariableNewValue(String localVariableNewValue) {
        this._localVariableNewValue = localVariableNewValue != null && !localVariableNewValue.isEmpty() ? localVariableNewValue : null;
    }

    public String getLocalVariableNewValue() {
        return this._localVariableNewValue;
    }

    public FemaleDigitalActionSocket getExecuteSocket() {
        return this._executeSocket;
    }

    public String getExecuteSocketSystemName() {
        return this._executeSocketSystemName;
    }

    public void setExecuteSocketSystemName(String systemName) {
        this._executeSocketSystemName = systemName;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() {
        if (this._localVariableBeanToListenOn != null && !this._localVariableBeanToListenOn.isBlank()) {
            ConditionalNG conditionalNG;
            this._internalSocket._conditionalNG = conditionalNG = this.getConditionalNG();
            this._internalSocket._newSymbolTable = new DefaultSymbolTable(conditionalNG.getSymbolTable());
            SymbolTable symbolTable = conditionalNG.getSymbolTable();
            Object value = symbolTable.getValue(this._localVariableBeanToListenOn);
            NamedBean namedBean = null;
            if (value instanceof NamedBean) {
                namedBean = (NamedBean)value;
            } else if (value != null) {
                namedBean = this._namedBeanType.getManager().getNamedBean(value.toString());
            }
            if (namedBean != null) {
                if (!this._namedBeansEntries.containsKey(namedBean)) {
                    this._namedBeansEntries.put(namedBean, this._namedBeanType.getPropertyName());
                    this.addPropertyListener(namedBean, this._namedBeanType.getPropertyName());
                }
            } else {
                log.warn("The named bean \"{}\" cannot be found in the manager for {}", value, (Object)this._namedBeanType.toString());
            }
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._executeSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._executeSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._executeSocketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._executeSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._executeSocketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeansLocalVariable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeansLocalVariable_Long", this._localVariableBeanToListenOn, this._namedBeanType.toString());
    }

    @Override
    public void setup() {
        try {
            if (!this._executeSocket.isConnected() || !this._executeSocket.getConnectedSocket().getSystemName().equals(this._executeSocketSystemName)) {
                String socketSystemName = this._executeSocketSystemName;
                this._executeSocket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._executeSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._executeSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    private void addPropertyListener(NamedBean namedBean, String property) {
        if (!this._listenOnAllProperties && property != null) {
            namedBean.addPropertyChangeListener(property, this);
        } else {
            namedBean.addPropertyChangeListener(this);
        }
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        for (Map.Entry<NamedBean, String> namedBeanEntry : this._namedBeansEntries.entrySet()) {
            this.addPropertyListener(namedBeanEntry.getKey(), namedBeanEntry.getValue());
        }
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        for (Map.Entry<NamedBean, String> namedBeanEntry : this._namedBeansEntries.entrySet()) {
            if (!this._listenOnAllProperties && namedBeanEntry.getValue() != null) {
                namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
            } else {
                namedBeanEntry.getKey().removePropertyChangeListener(this);
            }
            namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
        }
        this._listenersAreRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean isQueueEmpty;
        ActionListenOnBeansLocalVariable actionListenOnBeansLocalVariable = this;
        synchronized (actionListenOnBeansLocalVariable) {
            isQueueEmpty = this._eventQueue.isEmpty();
            this._eventQueue.add(evt);
        }
        if (isQueueEmpty) {
            this.getConditionalNG().execute(this._internalSocket);
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG _conditionalNG;
        private SymbolTable _newSymbolTable;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws JmriException {
            if (ActionListenOnBeansLocalVariable.this._executeSocket != null) {
                InternalFemaleSocket internalFemaleSocket = this;
                synchronized (internalFemaleSocket) {
                    String newValue;
                    String event;
                    String namedBean;
                    SymbolTable oldSymbolTable = this._conditionalNG.getSymbolTable();
                    this._conditionalNG.setSymbolTable(this._newSymbolTable);
                    PropertyChangeEvent evt = ActionListenOnBeansLocalVariable.this._eventQueue.poll();
                    if (evt != null) {
                        namedBean = ((NamedBean)evt.getSource()).getDisplayName();
                        event = evt.getPropertyName();
                        newValue = evt.getNewValue() != null ? evt.getNewValue().toString() : null;
                    } else {
                        namedBean = null;
                        event = null;
                        newValue = null;
                    }
                    if (ActionListenOnBeansLocalVariable.this._localVariableNamedBean != null) {
                        this._newSymbolTable.setValue(ActionListenOnBeansLocalVariable.this._localVariableNamedBean, namedBean);
                    }
                    if (ActionListenOnBeansLocalVariable.this._localVariableEvent != null) {
                        this._newSymbolTable.setValue(ActionListenOnBeansLocalVariable.this._localVariableEvent, event);
                    }
                    if (ActionListenOnBeansLocalVariable.this._localVariableNewValue != null) {
                        this._newSymbolTable.setValue(ActionListenOnBeansLocalVariable.this._localVariableNewValue, newValue);
                    }
                    ActionListenOnBeansLocalVariable.this._executeSocket.execute();
                    this._conditionalNG.setSymbolTable(oldSymbolTable);
                    if (!ActionListenOnBeansLocalVariable.this._eventQueue.isEmpty()) {
                        this._conditionalNG.execute(ActionListenOnBeansLocalVariable.this._internalSocket);
                    }
                }
            }
        }
    }
}

