/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanType;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionListenOnBeansTable
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private NamedBeanType _namedBeanType = NamedBeanType.Light;
    private final LogixNG_SelectNamedBean<NamedTable> _selectNamedBean = new LogixNG_SelectNamedBean<NamedTable>(this, NamedTable.class, InstanceManager.getDefault(NamedTableManager.class), this);
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnName = "";
    private boolean _includeCellsWithoutHeader = false;
    private boolean _listenOnAllProperties = false;
    private final List<Map.Entry<NamedBean, String>> _namedBeansEntries = new ArrayList<Map.Entry<NamedBean, String>>();
    private String _localVariableNamedBean;
    private String _localVariableEvent;
    private String _localVariableNewValue;
    @GuardedBy(value="this")
    private final Deque<PropertyChangeEvent> _eventQueue = new ArrayDeque<PropertyChangeEvent>();
    private static final Logger log = LoggerFactory.getLogger(ActionListenOnBeansTable.class);

    public ActionListenOnBeansTable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._selectNamedBean.setOnlyDirectAddressingAllowed();
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionListenOnBeansTable copy = new ActionListenOnBeansTable(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNamedBeanType(this._namedBeanType);
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setTableRowOrColumn(this._tableRowOrColumn);
        copy.setRowOrColumnName(this._rowOrColumnName);
        copy.setIncludeCellsWithoutHeader(this._includeCellsWithoutHeader);
        copy.setLocalVariableNamedBean(this._localVariableNamedBean);
        copy.setLocalVariableEvent(this._localVariableEvent);
        copy.setLocalVariableNewValue(this._localVariableNewValue);
        for (Map.Entry<NamedBean, String> entry : this._namedBeansEntries) {
            copy._namedBeansEntries.add(new AbstractMap.SimpleEntry<NamedBean, String>(entry.getKey(), entry.getValue()));
        }
        return manager.registerAction(copy);
    }

    public NamedBeanType getNamedBeanType() {
        return this._namedBeanType;
    }

    public void setNamedBeanType(@Nonnull NamedBeanType namedBeanType) {
        if (namedBeanType == null) {
            throw new RuntimeException("Daniel");
        }
        this._namedBeanType = namedBeanType;
    }

    public LogixNG_SelectNamedBean<NamedTable> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public TableRowOrColumn getTableRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setTableRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public String getRowOrColumnName() {
        return this._rowOrColumnName;
    }

    public void setRowOrColumnName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new IllegalArgumentException("Row/column name is null");
        }
        this._rowOrColumnName = rowOrColumnName;
    }

    public boolean getListenOnAllProperties() {
        return this._listenOnAllProperties;
    }

    public void setListenOnAllProperties(boolean listenOnAllProperties) {
        this._listenOnAllProperties = listenOnAllProperties;
    }

    public boolean getIncludeCellsWithoutHeader() {
        return this._includeCellsWithoutHeader;
    }

    public void setIncludeCellsWithoutHeader(boolean includeCellsWithoutHeader) {
        this._includeCellsWithoutHeader = includeCellsWithoutHeader;
    }

    public void setLocalVariableNamedBean(String localVariableNamedBean) {
        this._localVariableNamedBean = localVariableNamedBean != null && !localVariableNamedBean.isEmpty() ? localVariableNamedBean : null;
    }

    public String getLocalVariableNamedBean() {
        return this._localVariableNamedBean;
    }

    public void setLocalVariableEvent(String localVariableEvent) {
        this._localVariableEvent = localVariableEvent != null && !localVariableEvent.isEmpty() ? localVariableEvent : null;
    }

    public String getLocalVariableEvent() {
        return this._localVariableEvent;
    }

    public void setLocalVariableNewValue(String localVariableNewValue) {
        this._localVariableNewValue = localVariableNewValue != null && !localVariableNewValue.isEmpty() ? localVariableNewValue : null;
    }

    public String getLocalVariableNewValue() {
        return this._localVariableNewValue;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        ActionListenOnBeansTable actionListenOnBeansTable = this;
        synchronized (actionListenOnBeansTable) {
            String newValue;
            String event;
            String namedBean;
            PropertyChangeEvent evt = this._eventQueue.poll();
            if (evt != null) {
                namedBean = ((NamedBean)evt.getSource()).getDisplayName();
                event = evt.getPropertyName();
                newValue = evt.getNewValue() != null ? evt.getNewValue().toString() : null;
            } else {
                namedBean = null;
                event = null;
                newValue = null;
            }
            SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
            if (this._localVariableNamedBean != null) {
                symbolTable.setValue(this._localVariableNamedBean, namedBean);
            }
            if (this._localVariableEvent != null) {
                symbolTable.setValue(this._localVariableEvent, event);
            }
            if (this._localVariableNewValue != null) {
                symbolTable.setValue(this._localVariableNewValue, newValue);
            }
            if (!this._eventQueue.isEmpty()) {
                this.getConditionalNG().execute();
            }
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionListenOnBeansTable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String tableName = this._selectNamedBean.getDescription(locale);
        return Bundle.getMessage(locale, "ActionListenOnBeansTable_Long", this._namedBeanType.toString(), this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._tableRowOrColumn.toStringLowerCase(), this._rowOrColumnName, tableName);
    }

    @Override
    public void setup() {
    }

    public List<String> getItems() {
        ArrayList<String> items = new ArrayList<String>();
        if (this._selectNamedBean.getNamedBean() == null) {
            log.error("No table name is given");
            return items;
        }
        if (this._rowOrColumnName.isEmpty()) {
            log.error("rowOrColumnName is empty string");
            return items;
        }
        NamedTable table = this._selectNamedBean.getNamedBean().getBean();
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int row = table.getRowNumber(this._rowOrColumnName);
            for (int column = 1; column <= table.numColumns(); ++column) {
                Object cell;
                Object header = table.getCell(0, column);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty()) || (cell = table.getCell(row, column)) == null) continue;
                items.add(cell.toString());
            }
        } else {
            int column = table.getColumnNumber(this._rowOrColumnName);
            for (int row = 1; row <= table.numRows(); ++row) {
                Object cell;
                Object header = table.getCell(row, 0);
                if (!this._includeCellsWithoutHeader && (header == null || header.toString().isEmpty()) || (cell = table.getCell(row, column)) == null || cell.toString().isEmpty()) continue;
                items.add(cell.toString());
            }
        }
        return items;
    }

    @Override
    public void registerListenersForThisClass() {
        if (this._listenersAreRegistered) {
            return;
        }
        List<String> items = this.getItems();
        for (String item : items) {
            NamedBean namedBean = this._namedBeanType.getManager().getNamedBean(item);
            if (namedBean != null) {
                AbstractMap.SimpleEntry<NamedBean, String> namedBeanEntry = new AbstractMap.SimpleEntry<NamedBean, String>(namedBean, this._namedBeanType.getPropertyName());
                this._namedBeansEntries.add(namedBeanEntry);
                if (!this._listenOnAllProperties && this._namedBeanType.getPropertyName() != null) {
                    namedBean.addPropertyChangeListener(this._namedBeanType.getPropertyName(), this);
                    continue;
                }
                namedBean.addPropertyChangeListener(this);
                continue;
            }
            log.warn("The named bean \"{}\" cannot be found in the manager for {}", (Object)item, (Object)this._namedBeanType.toString());
        }
        this._selectNamedBean.registerListeners();
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            return;
        }
        for (Map.Entry<NamedBean, String> namedBeanEntry : this._namedBeansEntries) {
            if (!this._listenOnAllProperties && namedBeanEntry.getValue() != null) {
                namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
            } else {
                namedBeanEntry.getKey().removePropertyChangeListener(this);
            }
            namedBeanEntry.getKey().removePropertyChangeListener(namedBeanEntry.getValue(), this);
        }
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean isQueueEmpty;
        ActionListenOnBeansTable actionListenOnBeansTable = this;
        synchronized (actionListenOnBeansTable) {
            isQueueEmpty = this._eventQueue.isEmpty();
            this._eventQueue.add(evt);
        }
        if (isQueueEmpty) {
            this.getConditionalNG().execute();
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }
}

