/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMemory
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Memory> _selectNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private final LogixNG_SelectNamedBean<Memory> _selectOtherMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private MemoryOperation _memoryOperation = MemoryOperation.SetToString;
    private String _otherConstantValue = "";
    private String _otherLocalVariable = "";
    private String _otherFormula = "";
    private ExpressionNode _otherExpressionNode;
    private boolean _listenToMemory = true;
    private final LogixNG_SelectTable _selectTable = new LogixNG_SelectTable(this, () -> this._memoryOperation == MemoryOperation.CopyTableCellToMemory);
    private static final Logger log = LoggerFactory.getLogger(ActionMemory.class);

    public ActionMemory(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionMemory copy = new ActionMemory(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectOtherMemoryNamedBean.copy(copy._selectOtherMemoryNamedBean);
        copy.setMemoryOperation(this._memoryOperation);
        copy.setOtherConstantValue(this._otherConstantValue);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setOtherFormula(this._otherFormula);
        copy.setListenToMemory(this._listenToMemory);
        this._selectTable.copy(copy._selectTable);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Memory> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectOtherMemoryNamedBean() {
        return this._selectOtherMemoryNamedBean;
    }

    public void setMemoryOperation(MemoryOperation state) throws ParserException {
        this._memoryOperation = state;
        this.parseOtherFormula();
    }

    public MemoryOperation getMemoryOperation() {
        return this._memoryOperation;
    }

    public void setOtherConstantValue(String constantValue) {
        this._otherConstantValue = constantValue;
    }

    public String getConstantValue() {
        return this._otherConstantValue;
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setOtherFormula(String formula) throws ParserException {
        this._otherFormula = formula;
        this.parseOtherFormula();
    }

    public String getOtherFormula() {
        return this._otherFormula;
    }

    private void parseOtherFormula() throws ParserException {
        if (this._memoryOperation == MemoryOperation.CalculateFormula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._otherExpressionNode = parser.parseExpression(this._otherFormula);
        } else {
            this._otherExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Memory memory = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (memory == null) {
            return;
        }
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (this._memoryOperation) {
                case SetToNull: {
                    memory.setValue(null);
                    break;
                }
                case SetToString: {
                    memory.setValue(this._otherConstantValue);
                    break;
                }
                case CopyTableCellToMemory: {
                    Object value = this._selectTable.evaluateTableData(conditionalNG);
                    memory.setValue(value);
                    break;
                }
                case CopyVariableToMemory: {
                    Object variableValue = conditionalNG.getSymbolTable().getValue(this._otherLocalVariable);
                    memory.setValue(variableValue);
                    break;
                }
                case CopyMemoryToMemory: {
                    Memory otherMemory = this._selectOtherMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (otherMemory != null) {
                        memory.setValue(otherMemory.getValue());
                        break;
                    }
                    log.warn("setMemory should copy memory to memory but other memory is null");
                    break;
                }
                case CalculateFormula: {
                    if (this._otherFormula.isEmpty()) {
                        memory.setValue(null);
                        break;
                    }
                    try {
                        if (this._otherExpressionNode == null) {
                            return;
                        }
                        memory.setValue(this._otherExpressionNode.calculate(conditionalNG.getSymbolTable()));
                    }
                    catch (JmriException e) {
                        ref.set(e);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("_memoryOperation has invalid value: {}" + this._memoryOperation.name());
                }
            }
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionMemory_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String copyToMemoryName = this._selectOtherMemoryNamedBean.getDescription(locale);
        switch (this._memoryOperation) {
            case SetToNull: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Null", namedBean);
            }
            case SetToString: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Value", namedBean, this._otherConstantValue);
            }
            case CopyVariableToMemory: {
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyVariableToMemory", namedBean, this._otherLocalVariable);
            }
            case CopyMemoryToMemory: {
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyMemoryToMemory", namedBean, copyToMemoryName);
            }
            case CopyTableCellToMemory: {
                String tableName = this._selectTable.getTableNameDescription(locale);
                String rowName = this._selectTable.getTableRowDescription(locale);
                String columnName = this._selectTable.getTableColumnDescription(locale);
                return Bundle.getMessage(locale, "ActionMemory_Long_CopyTableCellToMemory", namedBean, tableName, rowName, columnName);
            }
            case CalculateFormula: {
                return Bundle.getMessage(locale, "ActionMemory_Long_Formula", namedBean, this._otherFormula);
            }
        }
        throw new IllegalArgumentException("_memoryOperation has invalid value: " + this._memoryOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            if (this._listenToMemory) {
                this._selectOtherMemoryNamedBean.addPropertyChangeListener("value", this);
            }
            this._selectNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered && this._listenToMemory) {
            this._selectOtherMemoryNamedBean.removePropertyChangeListener("value", this);
        }
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectOtherMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum MemoryOperation {
        SetToNull(Bundle.getMessage("ActionMemory_MemoryOperation_SetToNull")),
        SetToString(Bundle.getMessage("ActionMemory_MemoryOperation_SetToString")),
        CopyVariableToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyVariableToMemory")),
        CopyMemoryToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyMemoryToMemory")),
        CopyTableCellToMemory(Bundle.getMessage("ActionMemory_MemoryOperation_CopyTableCellToMemory")),
        CalculateFormula(Bundle.getMessage("ActionMemory_MemoryOperation_CalculateFormula"));

        private final String _text;

        private MemoryOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

