/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;

public class ActionOBlock
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<OBlock> _selectNamedBean = new LogixNG_SelectNamedBean<OBlock>(this, OBlock.class, InstanceManager.getDefault(OBlockManager.class), this);
    private final LogixNG_SelectEnum<DirectOperation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])DirectOperation.values(), (Enum)DirectOperation.Deallocate, (PropertyChangeListener)this);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private String _oblockValue = "";

    public ActionOBlock(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionOBlock copy = new ActionOBlock(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setOBlockValue(this._oblockValue);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<OBlock> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public LogixNG_SelectEnum<DirectOperation> getSelectEnum() {
        return this._selectEnum;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setOBlockValue(@Nonnull String value) {
        this._oblockValue = value;
    }

    public String getOBlockValue() {
        return this._oblockValue;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewData(ConditionalNG conditionalNG) throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                return this._oblockValue;
            }
            case Reference: {
                return ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._dataReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
            }
            case Formula: {
                return this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(conditionalNG.getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _addressing state: " + this._dataAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        DirectOperation oper;
        ConditionalNG conditionalNG = this.getConditionalNG();
        OBlock oblock = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (oblock == null) {
            return;
        }
        DirectOperation theOper = oper = this._selectEnum.evaluateEnum(conditionalNG);
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case Deallocate: {
                    oblock.deAllocate(null);
                    break;
                }
                case SetValue: {
                    oblock.setValue(this.getNewData(conditionalNG));
                    break;
                }
                case SetError: {
                    oblock.setError(true);
                    break;
                }
                case ClearError: {
                    oblock.setError(false);
                    break;
                }
                case SetOutOfService: {
                    oblock.setOutOfService(true);
                    break;
                }
                case ClearOutOfService: {
                    oblock.setOutOfService(false);
                    break;
                }
                case GetBlockWarrant: {
                    Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (memory != null) {
                        Warrant w = oblock.getWarrant();
                        if (w != null) {
                            memory.setValue(w.getDisplayName());
                            break;
                        }
                        memory.setValue("unallocated");
                        break;
                    }
                    throw new JmriException("Memory for GetBlockWarrant is null for oblock - " + oblock.getDisplayName());
                }
                case GetBlockValue: {
                    Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (memory != null) {
                        Object obj = oblock.getValue();
                        if (obj instanceof String) {
                            memory.setValue(obj);
                            break;
                        }
                        memory.setValue("");
                        break;
                    }
                    throw new JmriException("Memory for GetBlockValue is null for oblock - " + oblock.getDisplayName());
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionOBlock_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        String getLocationMemory = this._selectMemoryNamedBean.getDescription(locale);
        if (this._selectEnum.getAddressing() == NamedBeanAddressing.Direct && this._selectEnum.getEnum() != null) {
            switch (this._selectEnum.getEnum()) {
                case SetValue: {
                    return this.getLongDataDescription(locale, "ActionOBlock_Long_Value", namedBean, this._oblockValue);
                }
                case GetBlockWarrant: {
                    return this.getLongDataDescription(locale, "ActionOBlock_Long_GetWarrant", namedBean, getLocationMemory);
                }
                case GetBlockValue: {
                    return this.getLongDataDescription(locale, "ActionOBlock_Long_GetTrain", namedBean, getLocationMemory);
                }
            }
        }
        return Bundle.getMessage(locale, "ActionOBlock_Long", namedBean, state);
    }

    private String getLongDataDescription(Locale locale, String bundleKey, String namedBean, String value) {
        switch (this._dataAddressing) {
            case Direct: {
                return Bundle.getMessage(locale, bundleKey, namedBean, value);
            }
            case Reference: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByReference", this._dataReference));
            }
            case LocalVariable: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
            }
            case Formula: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByFormula", this._dataFormula));
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
        this._selectMemoryNamedBean.addPropertyChangeListener("value", this);
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
        this._selectMemoryNamedBean.removePropertyChangeListener("value", this);
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum DirectOperation {
        Deallocate(Bundle.getMessage("ActionOBlock_Deallocate")),
        SetValue(Bundle.getMessage("ActionOBlock_SetValue")),
        SetError(Bundle.getMessage("ActionOBlock_SetError")),
        ClearError(Bundle.getMessage("ActionOBlock_ClearError")),
        SetOutOfService(Bundle.getMessage("ActionOBlock_SetOutOfService")),
        ClearOutOfService(Bundle.getMessage("ActionOBlock_ClearOutOfService")),
        GetBlockWarrant(Bundle.getMessage("ActionOBlock_GetBlockWarrant")),
        GetBlockValue(Bundle.getMessage("ActionOBlock_GetValue"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

