/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ActionPower
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectEnum<PowerState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])PowerState.values(), (Enum)PowerState.On, (PropertyChangeListener)this);

    public ActionPower(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException, ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionPower copy = new ActionPower(sysName, userName);
        copy.setComment(this.getComment());
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<PowerState> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        AtomicReference exception = new AtomicReference();
        PowerState powerState = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            try {
                InstanceManager.getDefault(PowerManager.class).setPower(powerState.getID());
            }
            catch (JmriException e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (JmriException)exception.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Power_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Power_Long", this._selectEnum.getDescription(locale));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum PowerState {
        Off(4, Bundle.getMessage("PowerStateOff")),
        On(2, Bundle.getMessage("PowerStateOn"));

        private final int _id;
        private final String _text;

        private PowerState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static PowerState get(int id) {
            switch (id) {
                case 4: {
                    return Off;
                }
                case 2: {
                    return On;
                }
            }
            throw new IllegalArgumentException("invalid power state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

