/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReporter
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Reporter> _selectNamedBean = new LogixNG_SelectNamedBean<Reporter>(this, Reporter.class, InstanceManager.getDefault(ReporterManager.class), this);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private ReporterValue _reporterValue = ReporterValue.CopyCurrentReport;
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private static final Logger log = LoggerFactory.getLogger(ActionReporter.class);

    public ActionReporter(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionReporter copy = new ActionReporter(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        copy.setReporterValue(this._reporterValue);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Reporter> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public void setReporterValue(ReporterValue value) {
        this._reporterValue = value;
    }

    public ReporterValue getReporterValue() {
        return this._reporterValue;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    Object getReporterData(Reporter reporter) throws JmriException {
        Object obj;
        ReporterValue value = this._reporterValue;
        switch (value) {
            case CopyCurrentReport: {
                obj = reporter.getCurrentReport();
                break;
            }
            case CopyLastReport: {
                obj = reporter.getLastReport();
                break;
            }
            case CopyState: {
                obj = reporter.getState();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value name: " + value.name());
            }
        }
        return obj;
    }

    void updateDestination(Object data) throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(this.getConditionalNG());
                if (memory == null) break;
                memory.setValue(data);
                break;
            }
            case Reference: {
                String refName = ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._dataReference);
                log.debug("ref ref = {}, name = {}", (Object)this._dataReference, (Object)refName);
                Memory refMem = InstanceManager.getDefault(MemoryManager.class).getMemory(refName);
                if (refMem == null) {
                    throw new IllegalArgumentException("invalid memory reference: " + refName);
                }
                refMem.setValue(data);
                break;
            }
            case LocalVariable: {
                log.debug("LocalVariable: lv = {}", (Object)this._dataLocalVariable);
                this.getConditionalNG().getSymbolTable().setValue(this._dataLocalVariable, data);
                break;
            }
            case Formula: {
                String formulaName;
                String string = formulaName = this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
                if (formulaName == null) {
                    throw new IllegalArgumentException("invalid memory formula, name is null");
                }
                Memory formulaMem = InstanceManager.getDefault(MemoryManager.class).getMemory(formulaName);
                if (formulaMem == null) {
                    throw new IllegalArgumentException("invalid memory formula: " + formulaName);
                }
                formulaMem.setValue(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
            }
        }
    }

    @Override
    public void execute() throws JmriException {
        Reporter reporter = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (reporter == null) {
            return;
        }
        log.debug("reporter = {}", (Object)reporter.getDisplayName());
        Object data = this.getReporterData(reporter);
        log.debug("data = {}", data);
        this.updateDestination(data);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionReporter_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String bean = this._selectNamedBean.getDescription(locale);
        String dest = "";
        switch (this._dataAddressing) {
            case Direct: {
                String memoryName = this._selectMemoryNamedBean.getDescription(locale);
                dest = Bundle.getMessage(locale, "AddressByDirect", memoryName);
                break;
            }
            case Reference: {
                dest = Bundle.getMessage(locale, "AddressByReference", this._dataReference);
                break;
            }
            case LocalVariable: {
                dest = Bundle.getMessage(locale, "AddressByLocalVariable", this._dataLocalVariable);
                break;
            }
            case Formula: {
                dest = Bundle.getMessage(locale, "AddressByFormula", this._dataFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
            }
        }
        String item = this.getReporterValue().toString();
        return Bundle.getMessage(locale, "ActionReporter_Long", item, bean, dest);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum ReporterValue {
        CopyCurrentReport(Bundle.getMessage("ActionReporter_CopyCurrentReport")),
        CopyLastReport(Bundle.getMessage("ActionReporter_CopyLastReport")),
        CopyState(Bundle.getMessage("ActionReporter_CopyState"));

        private final String _text;

        private ReporterValue(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

