/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRequestUpdateAllSensors
extends AbstractDigitalAction {
    private SystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(ActionRequestUpdateAllSensors.class);

    public ActionRequestUpdateAllSensors(String sys, String user, SystemConnectionMemo memo) {
        super(sys, user);
        this._memo = memo;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionRequestUpdateAllSensors copy = new ActionRequestUpdateAllSensors(sysName, userName, this._memo);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    public void setMemo(SystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public SystemConnectionMemo getMemo() {
        return this._memo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        if (this._memo != null) {
            if (!this._memo.provides(SensorManager.class)) throw new RuntimeException("_memo doesn't provide a sensor manager");
            this._memo.get(SensorManager.class).updateAll();
            return;
        } else {
            InstanceManager.getDefault(SensorManager.class).updateAll();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionRequestUpdateAllSensors_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._memo != null) {
            return Bundle.getMessage(locale, "ActionRequestUpdateAllSensors_LongConnection", this._memo.getUserName());
        }
        return Bundle.getMessage(locale, "ActionRequestUpdateAllSensors_Long");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }
}

