/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ActionSensor
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Sensor> _selectNamedBean = new LogixNG_SelectNamedBean<Sensor>(this, Sensor.class, InstanceManager.getDefault(SensorManager.class), this);
    private final LogixNG_SelectEnum<SensorState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])SensorState.values(), (Enum)SensorState.Active, (PropertyChangeListener)this);
    private static final int TOGGLE_ID = -1;

    public ActionSensor(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSensor copy = new ActionSensor(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Sensor> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<SensorState> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        Sensor sensor = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (sensor == null) {
            return;
        }
        SensorState state = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (state == SensorState.Toggle) {
                if (sensor.getKnownState() == 4) {
                    sensor.setCommandedState(2);
                } else {
                    sensor.setCommandedState(4);
                }
            } else {
                sensor.setCommandedState(state.getID());
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Sensor_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        return Bundle.getMessage(locale, "Sensor_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum SensorState {
        Inactive(4, Bundle.getMessage("SensorStateInactive")),
        Active(2, Bundle.getMessage("SensorStateActive")),
        Toggle(-1, Bundle.getMessage("SensorToggleStatus")),
        Unknown(1, Bundle.getMessage("BeanStateUnknown")),
        Inconsistent(8, Bundle.getMessage("BeanStateInconsistent"));

        private final int _id;
        private final String _text;

        private SensorState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static SensorState get(int id) {
            switch (id) {
                case 1: {
                    return Unknown;
                }
                case 8: {
                    return Inconsistent;
                }
                case 4: {
                    return Inactive;
                }
                case 2: {
                    return Active;
                }
                case -1: {
                    return Toggle;
                }
            }
            throw new IllegalArgumentException("invalid sensor state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

