/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSetReporter
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Reporter> _selectNamedBean = new LogixNG_SelectNamedBean<Reporter>(this, Reporter.class, InstanceManager.getDefault(ReporterManager.class), this);
    private final LogixNG_SelectNamedBean<Memory> _selectOtherMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private ReporterOperation _reporterOperation = ReporterOperation.SetToString;
    private String _otherConstantValue = "";
    private String _otherLocalVariable = "";
    private String _otherFormula = "";
    private ExpressionNode _otherExpressionNode;
    private boolean _provideAnIdTag = false;
    private final LogixNG_SelectTable _selectTable = new LogixNG_SelectTable(this, () -> this._reporterOperation == ReporterOperation.CopyTableCellToReporter);
    private static final Logger log = LoggerFactory.getLogger(ActionSetReporter.class);

    public ActionSetReporter(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSetReporter copy = new ActionSetReporter(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectOtherMemoryNamedBean.copy(copy._selectOtherMemoryNamedBean);
        copy.setMemoryOperation(this._reporterOperation);
        copy.setOtherConstantValue(this._otherConstantValue);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setOtherFormula(this._otherFormula);
        copy.setProvideAnIdTag(this._provideAnIdTag);
        this._selectTable.copy(copy._selectTable);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Reporter> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectOtherMemoryNamedBean() {
        return this._selectOtherMemoryNamedBean;
    }

    public void setMemoryOperation(ReporterOperation state) throws ParserException {
        this._reporterOperation = state;
        this.parseOtherFormula();
    }

    public ReporterOperation getReporterOperation() {
        return this._reporterOperation;
    }

    public void setOtherConstantValue(String constantValue) {
        this._otherConstantValue = constantValue;
    }

    public String getConstantValue() {
        return this._otherConstantValue;
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    public void setProvideAnIdTag(boolean createAnIdTag) {
        this._provideAnIdTag = createAnIdTag;
    }

    public boolean isProvideAnIdTag() {
        return this._provideAnIdTag;
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setOtherFormula(String formula) throws ParserException {
        this._otherFormula = formula;
        this.parseOtherFormula();
    }

    public String getOtherFormula() {
        return this._otherFormula;
    }

    private void parseOtherFormula() throws ParserException {
        if (this._reporterOperation == ReporterOperation.CalculateFormula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._otherExpressionNode = parser.parseExpression(this._otherFormula);
        } else {
            this._otherExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Reporter reporter = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (reporter == null) {
            return;
        }
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            Object report;
            switch (this._reporterOperation) {
                case SetToNull: {
                    report = null;
                    break;
                }
                case SetToString: {
                    report = this._otherConstantValue;
                    break;
                }
                case CopyTableCellToReporter: {
                    report = this._selectTable.evaluateTableData(conditionalNG);
                    break;
                }
                case CopyVariableToReporter: {
                    report = conditionalNG.getSymbolTable().getValue(this._otherLocalVariable);
                    break;
                }
                case CopyMemoryToReporter: {
                    Memory otherMemory = this._selectOtherMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (otherMemory != null) {
                        report = otherMemory.getValue();
                        break;
                    }
                    log.warn("setReporter should copy memory to reporter but memory is null");
                    return;
                }
                case CalculateFormula: {
                    if (this._otherFormula.isEmpty()) {
                        report = null;
                        break;
                    }
                    try {
                        if (this._otherExpressionNode == null) {
                            return;
                        }
                        report = this._otherExpressionNode.calculate(conditionalNG.getSymbolTable());
                        break;
                    }
                    catch (JmriException e) {
                        ref.set(e);
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("_reporterOperation has invalid value: {}" + this._reporterOperation.name());
                }
            }
            if (this._provideAnIdTag) {
                IdTag idTag;
                if (report == null) {
                    throw new IllegalArgumentException("report is null. Can't provide an IdTag");
                }
                if (report instanceof IdTag) {
                    idTag = (IdTag)report;
                } else {
                    String name = TypeConversionUtil.convertToString(report, false);
                    idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(name);
                    report = idTag;
                }
                idTag.setWhereLastSeen(reporter);
            }
            reporter.setReport(report);
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionSetReporter_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String copyToMemoryName = this._selectOtherMemoryNamedBean.getDescription(locale);
        switch (this._reporterOperation) {
            case SetToNull: {
                return Bundle.getMessage(locale, "ActionSetReporter_Long_Null", namedBean);
            }
            case SetToString: {
                return Bundle.getMessage(locale, "ActionSetReporter_Long_Value", namedBean, this._otherConstantValue);
            }
            case CopyVariableToReporter: {
                return Bundle.getMessage(locale, "ActionSetReporter_Long_CopyVariableToReporter", namedBean, this._otherLocalVariable);
            }
            case CopyMemoryToReporter: {
                return Bundle.getMessage(locale, "ActionSetReporter_Long_CopyMemoryToReporter", namedBean, copyToMemoryName);
            }
            case CopyTableCellToReporter: {
                String tableName = this._selectTable.getTableNameDescription(locale);
                String rowName = this._selectTable.getTableRowDescription(locale);
                String columnName = this._selectTable.getTableColumnDescription(locale);
                return Bundle.getMessage(locale, "ActionSetReporter_Long_CopyTableCellToReporter", namedBean, tableName, rowName, columnName);
            }
            case CalculateFormula: {
                return Bundle.getMessage(locale, "ActionSetReporter_Long_Formula", namedBean, this._otherFormula);
            }
        }
        throw new IllegalArgumentException("_memoryOperation has invalid value: " + this._reporterOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._selectNamedBean.registerListeners();
            this._selectOtherMemoryNamedBean.addPropertyChangeListener("value", this);
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._selectNamedBean.unregisterListeners();
            this._selectOtherMemoryNamedBean.removePropertyChangeListener("value", this);
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectOtherMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum ReporterOperation {
        SetToNull(Bundle.getMessage("ActionSetReporter_ReporterOperation_SetToNull")),
        SetToString(Bundle.getMessage("ActionSetReporter_ReporterOperation_SetToString")),
        CopyVariableToReporter(Bundle.getMessage("ActionSetReporter_ReporterOperation_CopyVariableToReporter")),
        CopyMemoryToReporter(Bundle.getMessage("ActionSetReporter_ReporterOperation_CopyMemoryToReporter")),
        CopyTableCellToReporter(Bundle.getMessage("ActionSetReporter_ReporterOperation_CopyTableCellToReporter")),
        CalculateFormula(Bundle.getMessage("ActionSetReporter_ReporterOperation_CalculateFormula"));

        private final String _text;

        private ReporterOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

