/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ShutDownManager;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionShutDownTask
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _callSocketSystemName;
    private String _runSocketSystemName;
    private final FemaleDigitalExpressionSocket _callSocket;
    private final FemaleDigitalActionSocket _runSocket;
    private final Object _lock = new Object();
    private static final Logger log = LoggerFactory.getLogger(ActionShutDownTask.class);

    public ActionShutDownTask(String sys, String user) {
        super(sys, user);
        this._callSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "E");
        this._runSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionShutDownTask copy = new ActionShutDownTask(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() throws JmriException {
        final ConditionalNG conditionalNG = this.getConditionalNG();
        final DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG.getSymbolTable());
        AbstractShutDownTask shutDownTask = new AbstractShutDownTask("LogixNG action ShutDownTask"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                if (ActionShutDownTask.this._callSocket.isConnected()) {
                    InternalCallSocket internalSocket = new InternalCallSocket();
                    internalSocket.conditionalNG = conditionalNG;
                    internalSocket.newSymbolTable = newSymbolTable;
                    try {
                        Object object = ActionShutDownTask.this._lock;
                        synchronized (object) {
                            conditionalNG.execute(internalSocket);
                            while (!internalSocket._completed) {
                                ActionShutDownTask.this._lock.wait();
                            }
                            return internalSocket._result;
                        }
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted exception: {}", (Object)e, (Object)e);
                        return true;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runEarly() {
                if (ActionShutDownTask.this._runSocket.isConnected()) {
                    InternalRunSocket internalSocket = new InternalRunSocket();
                    internalSocket.conditionalNG = conditionalNG;
                    internalSocket.newSymbolTable = newSymbolTable;
                    try {
                        Object object = ActionShutDownTask.this._lock;
                        synchronized (object) {
                            conditionalNG.execute(internalSocket);
                            while (!internalSocket._completed) {
                                ActionShutDownTask.this._lock.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted exception: {}", (Object)e, (Object)e);
                    }
                }
            }

            @Override
            public void run() {
            }
        };
        InstanceManager.getDefault(ShutDownManager.class).register(shutDownTask);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._callSocket;
            }
            case 1: {
                return this._runSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._callSocket) {
            this._callSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._runSocket) {
            this._runSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._callSocket) {
            this._callSocketSystemName = null;
        } else if (socket == this._runSocket) {
            this._runSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionShutDownTask_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionShutDownTask_Long", this._callSocket.getName(), this._runSocket.getName());
    }

    public FemaleDigitalExpressionSocket getCallSocket() {
        return this._callSocket;
    }

    public String getCallSocketSystemName() {
        return this._callSocketSystemName;
    }

    public void setCallSocketSystemName(String systemName) {
        this._callSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getRunSocket() {
        return this._runSocket;
    }

    public String getRunSocketSystemName() {
        return this._runSocketSystemName;
    }

    public void setRunSocketSystemName(String systemName) {
        this._runSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._callSocket.isConnected() || !this._callSocket.getConnectedSocket().getSystemName().equals(this._callSocketSystemName)) {
                socketSystemName = this._callSocketSystemName;
                this._callSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._callSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._callSocket.getConnectedSocket().setup();
            }
            if (!this._runSocket.isConnected() || !this._runSocket.getConnectedSocket().getSystemName().equals(this._runSocketSystemName)) {
                socketSystemName = this._runSocketSystemName;
                this._runSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._runSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._runSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    private class InternalRunSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;
        private boolean _completed;

        public InternalRunSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
            this._completed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws JmriException {
            if (this.conditionalNG == null) {
                throw new NullPointerException("conditionalNG is null");
            }
            if (ActionShutDownTask.this._runSocket != null) {
                SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                this.conditionalNG.setSymbolTable(this.newSymbolTable);
                ActionShutDownTask.this._runSocket.execute();
                this.conditionalNG.setSymbolTable(oldSymbolTable);
                Object object = ActionShutDownTask.this._lock;
                synchronized (object) {
                    this._completed = true;
                    ActionShutDownTask.this._lock.notifyAll();
                }
            }
        }
    }

    private class InternalCallSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;
        private boolean _completed;
        private boolean _result;

        public InternalCallSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "E");
            this._completed = false;
            this._result = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws JmriException {
            if (this.conditionalNG == null) {
                throw new NullPointerException("conditionalNG is null");
            }
            if (ActionShutDownTask.this._callSocket != null) {
                SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                this.conditionalNG.setSymbolTable(this.newSymbolTable);
                this._result = ActionShutDownTask.this._callSocket.evaluate();
                this.conditionalNG.setSymbolTable(oldSymbolTable);
                Object object = ActionShutDownTask.this._lock;
                synchronized (object) {
                    this._completed = true;
                    ActionShutDownTask.this._lock.notifyAll();
                }
            }
        }
    }
}

