/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSignalHead
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<SignalHead> _selectNamedBean = new LogixNG_SelectNamedBean<SignalHead>(this, SignalHead.class, InstanceManager.getDefault(SignalHeadManager.class), this);
    private NamedBeanAddressing _operationAddressing = NamedBeanAddressing.Direct;
    private OperationType _operationType = OperationType.Appearance;
    private String _operationReference = "";
    private String _operationLocalVariable = "";
    private String _operationFormula = "";
    private ExpressionNode _operationExpressionNode;
    private NamedBeanAddressing _appearanceAddressing = NamedBeanAddressing.Direct;
    private int _signalHeadAppearance = 0;
    private String _appearanceReference = "";
    private String _appearanceLocalVariable = "";
    private String _appearanceFormula = "";
    private ExpressionNode _appearanceExpressionNode;
    private final LogixNG_SelectNamedBean<SignalHead> _selectExampleNamedBean = new LogixNG_SelectNamedBean<SignalHead>(this, SignalHead.class, InstanceManager.getDefault(SignalHeadManager.class), this);
    private static final Logger log = LoggerFactory.getLogger(ActionSignalHead.class);

    public ActionSignalHead(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSignalHead copy = new ActionSignalHead(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setAppearance(this._signalHeadAppearance);
        copy.setOperationAddressing(this._operationAddressing);
        copy.setOperationType(this._operationType);
        copy.setOperationFormula(this._operationFormula);
        copy.setOperationLocalVariable(this._operationLocalVariable);
        copy.setOperationReference(this._operationReference);
        copy.setAppearanceAddressing(this._appearanceAddressing);
        copy.setAppearanceFormula(this._appearanceFormula);
        copy.setAppearanceLocalVariable(this._appearanceLocalVariable);
        copy.setAppearanceReference(this._appearanceReference);
        this._selectExampleNamedBean.copy(copy._selectExampleNamedBean);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<SignalHead> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<SignalHead> getSelectExampleNamedBean() {
        return this._selectExampleNamedBean;
    }

    public void setOperationAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._operationAddressing = addressing;
        this.parseOperationFormula();
    }

    public NamedBeanAddressing getOperationAddressing() {
        return this._operationAddressing;
    }

    public void setOperationType(OperationType operationType) {
        this._operationType = operationType;
    }

    public OperationType getOperationType() {
        return this._operationType;
    }

    public void setOperationReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._operationReference = reference;
    }

    public String getOperationReference() {
        return this._operationReference;
    }

    public void setOperationLocalVariable(@Nonnull String localVariable) {
        this._operationLocalVariable = localVariable;
    }

    public String getOperationLocalVariable() {
        return this._operationLocalVariable;
    }

    public void setOperationFormula(@Nonnull String formula) throws ParserException {
        this._operationFormula = formula;
        this.parseOperationFormula();
    }

    public String getOperationFormula() {
        return this._operationFormula;
    }

    private void parseOperationFormula() throws ParserException {
        if (this._operationAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._operationExpressionNode = parser.parseExpression(this._operationFormula);
        } else {
            this._operationExpressionNode = null;
        }
    }

    public void setAppearanceAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._appearanceAddressing = addressing;
        this.parseAppearanceFormula();
    }

    public NamedBeanAddressing getAppearanceAddressing() {
        return this._appearanceAddressing;
    }

    public void setAppearance(int appearance) {
        this._signalHeadAppearance = appearance;
    }

    public int getAppearance() {
        return this._signalHeadAppearance;
    }

    public void setAppearanceReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._appearanceReference = reference;
    }

    public String getAppearanceReference() {
        return this._appearanceReference;
    }

    public void setAppearanceLocalVariable(@Nonnull String localVariable) {
        this._appearanceLocalVariable = localVariable;
    }

    public String getAppearanceLocalVariable() {
        return this._appearanceLocalVariable;
    }

    public void setAppearanceFormula(@Nonnull String formula) throws ParserException {
        this._appearanceFormula = formula;
        this.parseAppearanceFormula();
    }

    public String getAppearanceFormula() {
        return this._appearanceFormula;
    }

    private void parseAppearanceFormula() throws ParserException {
        if (this._appearanceAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._appearanceExpressionNode = parser.parseExpression(this._appearanceFormula);
        } else {
            this._appearanceExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private int getAppearanceFromName(String name, SignalHead signalHead) {
        String[] keys = signalHead.getValidStateKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!name.equals(keys[i])) continue;
            return signalHead.getValidStates()[i];
        }
        throw new IllegalArgumentException("Appearance " + name + " is not valid for signal head " + signalHead.getSystemName());
    }

    private int getNewAppearance(ConditionalNG conditionalNG, SignalHead signalHead) throws JmriException {
        switch (this._appearanceAddressing) {
            case Direct: {
                return this._signalHeadAppearance;
            }
            case Reference: {
                return this.getAppearanceFromName(ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._appearanceReference), signalHead);
            }
            case LocalVariable: {
                SymbolTable symbolTable = conditionalNG.getSymbolTable();
                return this.getAppearanceFromName(TypeConversionUtil.convertToString(symbolTable.getValue(this._appearanceLocalVariable), false), signalHead);
            }
            case Formula: {
                return this._appearanceExpressionNode != null ? this.getAppearanceFromName(TypeConversionUtil.convertToString(this._appearanceExpressionNode.calculate(conditionalNG.getSymbolTable()), false), signalHead) : -1;
            }
        }
        throw new IllegalArgumentException("invalid _aspectAddressing state: " + this._appearanceAddressing.name());
    }

    private OperationType getOperation(ConditionalNG conditionalNG) throws JmriException {
        String oper = "";
        try {
            switch (this._operationAddressing) {
                case Direct: {
                    return this._operationType;
                }
                case Reference: {
                    oper = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._operationReference);
                    return OperationType.valueOf(oper);
                }
                case LocalVariable: {
                    SymbolTable symbolTable = conditionalNG.getSymbolTable();
                    oper = TypeConversionUtil.convertToString(symbolTable.getValue(this._operationLocalVariable), false);
                    return OperationType.valueOf(oper);
                }
                case Formula: {
                    if (this._appearanceExpressionNode != null) {
                        oper = TypeConversionUtil.convertToString(this._operationExpressionNode.calculate(conditionalNG.getSymbolTable()), false);
                        return OperationType.valueOf(oper);
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("invalid _addressing state: " + this._operationAddressing.name());
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unknown operation: " + oper, e);
        }
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        SignalHead signalHead = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (signalHead == null) {
            return;
        }
        OperationType operation = this.getOperation(conditionalNG);
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            try {
                switch (operation) {
                    case Appearance: {
                        int newAppearance = this.getNewAppearance(conditionalNG, signalHead);
                        if (newAppearance != -1) {
                            signalHead.setAppearance(newAppearance);
                        }
                        break;
                    }
                    case Lit: {
                        signalHead.setLit(true);
                        break;
                    }
                    case NotLit: {
                        signalHead.setLit(false);
                        break;
                    }
                    case Held: {
                        signalHead.setHeld(true);
                        break;
                    }
                    case NotHeld: {
                        signalHead.setHeld(false);
                        break;
                    }
                    default: {
                        throw new JmriException("Unknown enum: " + this._operationType.name());
                    }
                }
            }
            catch (JmriException e) {
                ref.set(e);
            }
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SignalHead_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String appearance;
        String operation;
        String namedBean = this._selectNamedBean.getDescription(locale);
        switch (this._operationAddressing) {
            case Direct: {
                operation = Bundle.getMessage(locale, "AddressByDirect", this._operationType._text);
                break;
            }
            case Reference: {
                operation = Bundle.getMessage(locale, "AddressByReference", this._operationReference);
                break;
            }
            case LocalVariable: {
                operation = Bundle.getMessage(locale, "AddressByLocalVariable", this._operationLocalVariable);
                break;
            }
            case Formula: {
                operation = Bundle.getMessage(locale, "AddressByFormula", this._operationFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _operationAddressing state: " + this._operationAddressing.name());
            }
        }
        switch (this._appearanceAddressing) {
            case Direct: {
                SignalHead signalHead = null;
                if (this._selectNamedBean.getAddressing() == NamedBeanAddressing.Direct) {
                    if (this._selectNamedBean.getNamedBeanIfDirectAddressing() != null) {
                        signalHead = this._selectNamedBean.getNamedBeanIfDirectAddressing();
                    }
                } else if (this._selectExampleNamedBean.getNamedBean() != null) {
                    signalHead = this._selectExampleNamedBean.getNamedBeanIfDirectAddressing();
                }
                String a = "";
                if (signalHead != null) {
                    a = signalHead.getAppearanceName(this._signalHeadAppearance);
                }
                appearance = Bundle.getMessage(locale, "AddressByDirect", a);
                break;
            }
            case Reference: {
                appearance = Bundle.getMessage(locale, "AddressByReference", this._appearanceReference);
                break;
            }
            case LocalVariable: {
                appearance = Bundle.getMessage(locale, "AddressByLocalVariable", this._appearanceLocalVariable);
                break;
            }
            case Formula: {
                appearance = Bundle.getMessage(locale, "AddressByFormula", this._appearanceFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._appearanceAddressing.name());
            }
        }
        if (this._operationAddressing == NamedBeanAddressing.Direct) {
            if (this._operationType == OperationType.Appearance) {
                return Bundle.getMessage(locale, "SignalHead_LongAppearance", namedBean, appearance);
            }
            return Bundle.getMessage(locale, "SignalHead_Long", namedBean, operation);
        }
        return Bundle.getMessage(locale, "SignalHead_LongUnknownOper", namedBean, operation, appearance);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionSignalHead: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectExampleNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum OperationType {
        Appearance(Bundle.getMessage("SignalHeadOperationType_Appearance")),
        Lit(Bundle.getMessage("SignalHeadOperationType_Lit")),
        NotLit(Bundle.getMessage("SignalHeadOperationType_NotLit")),
        Held(Bundle.getMessage("SignalHeadOperationType_Held")),
        NotHeld(Bundle.getMessage("SignalHeadOperationType_NotHeld"));

        private final String _text;

        private OperationType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

