/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.Sound;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;

public class ActionSound
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectEnum<Operation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])Operation.values(), (Enum)Operation.Play, (PropertyChangeListener)this);
    private NamedBeanAddressing _soundAddressing = NamedBeanAddressing.Direct;
    private String _sound = "";
    private String _soundReference = "";
    private String _soundLocalVariable = "";
    private String _soundFormula = "";
    private ExpressionNode _soundExpressionNode;

    public ActionSound(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionSound copy = new ActionSound(sysName, userName);
        copy.setComment(this.getComment());
        copy.setSound(this._sound);
        this._selectEnum.copy(copy._selectEnum);
        copy.setSoundAddressing(this._soundAddressing);
        copy.setSoundFormula(this._soundFormula);
        copy.setSoundLocalVariable(this._soundLocalVariable);
        copy.setSoundReference(this._soundReference);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<Operation> getSelectEnum() {
        return this._selectEnum;
    }

    public void setSoundAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._soundAddressing = addressing;
        this.parseSoundFormula();
    }

    public NamedBeanAddressing getSoundAddressing() {
        return this._soundAddressing;
    }

    public void setSound(String sound) {
        this._sound = sound == null ? "" : sound;
    }

    public String getSound() {
        return this._sound;
    }

    public void setSoundReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._soundReference = reference;
    }

    public String getSoundReference() {
        return this._soundReference;
    }

    public void setSoundLocalVariable(@Nonnull String localVariable) {
        this._soundLocalVariable = localVariable;
    }

    public String getSoundLocalVariable() {
        return this._soundLocalVariable;
    }

    public void setSoundFormula(@Nonnull String formula) throws ParserException {
        this._soundFormula = formula;
        this.parseSoundFormula();
    }

    public String getSoundFormula() {
        return this._soundFormula;
    }

    private void parseSoundFormula() throws ParserException {
        if (this._soundAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._soundExpressionNode = parser.parseExpression(this._soundFormula);
        } else {
            this._soundExpressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getTheSound() throws JmriException {
        switch (this._soundAddressing) {
            case Direct: {
                return this._sound;
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._soundReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._soundLocalVariable), false);
            }
            case Formula: {
                return this._soundExpressionNode != null ? TypeConversionUtil.convertToString(this._soundExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : "";
            }
        }
        throw new IllegalArgumentException("invalid _soundAddressing state: " + this._soundAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Operation operation = this._selectEnum.evaluateEnum(this.getConditionalNG());
        String path = this.getTheSound();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (operation) {
                case Play: {
                    if (path.equals("")) break;
                    try {
                        new Sound(path).play(true);
                        break;
                    }
                    catch (NullPointerException ex) {
                        throw new JmriException(Bundle.getMessage("ActionSound_Error_SoundNotFound", path));
                    }
                }
                default: {
                    throw new IllegalArgumentException("invalid operation: " + operation.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionSound_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String sound;
        String operation = this._selectEnum.getDescription(locale);
        switch (this._soundAddressing) {
            case Direct: {
                sound = Bundle.getMessage(locale, "AddressByDirect", this._sound);
                break;
            }
            case Reference: {
                sound = Bundle.getMessage(locale, "AddressByReference", this._soundReference);
                break;
            }
            case LocalVariable: {
                sound = Bundle.getMessage(locale, "AddressByLocalVariable", this._soundLocalVariable);
                break;
            }
            case Formula: {
                sound = Bundle.getMessage(locale, "AddressByFormula", this._soundFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _stateAddressing state: " + this._soundAddressing.name());
            }
        }
        if (this._selectEnum.getAddressing() == NamedBeanAddressing.Direct) {
            if (this._selectEnum.getEnum() == Operation.Play) {
                return Bundle.getMessage(locale, "ActionSound_Long_Play", sound);
            }
            return Bundle.getMessage(locale, "ActionSound_Long", operation, sound);
        }
        return Bundle.getMessage(locale, "ActionSound_LongUnknownOper", operation, sound);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._listenersAreRegistered = false;
        }
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void firePropertyChange(String p, Object old, Object n) {
        super.firePropertyChange(p, old, n);
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum Operation {
        Play(Bundle.getMessage("ActionSound_Operation_Play"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

