/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTable
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectTable _selectTableToSet = new LogixNG_SelectTable(this, () -> true);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private final LogixNG_SelectNamedBean<Block> _selectBlockNamedBean = new LogixNG_SelectNamedBean<Block>(this, Block.class, InstanceManager.getDefault(BlockManager.class), this);
    private final LogixNG_SelectNamedBean<Reporter> _selectReporterNamedBean = new LogixNG_SelectNamedBean<Reporter>(this, Reporter.class, InstanceManager.getDefault(ReporterManager.class), this);
    private VariableOperation _variableOperation = VariableOperation.SetToString;
    private ConstantType _constantType = ConstantType.String;
    private String _constantValue = "";
    private String _otherLocalVariable = "";
    private String _reference = "";
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private boolean _listenToMemory = false;
    private boolean _listenToBlock = false;
    private boolean _listenToReporter = false;
    private final LogixNG_SelectTable _selectTable = new LogixNG_SelectTable(this, () -> this._variableOperation == VariableOperation.CopyTableCellToVariable);
    private static final Logger log = LoggerFactory.getLogger(ActionTable.class);

    public ActionTable(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._selectMemoryNamedBean.setOnlyDirectAddressingAllowed();
        this._selectBlockNamedBean.setOnlyDirectAddressingAllowed();
        this._selectReporterNamedBean.setOnlyDirectAddressingAllowed();
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionTable copy = new ActionTable(sysName, userName);
        copy.setComment(this.getComment());
        this._selectTableToSet.copy(copy._selectTableToSet);
        copy.setVariableOperation(this._variableOperation);
        copy.setConstantType(this._constantType);
        copy.setConstantValue(this._constantValue);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        this._selectBlockNamedBean.copy(copy._selectBlockNamedBean);
        this._selectReporterNamedBean.copy(copy._selectReporterNamedBean);
        copy.setOtherLocalVariable(this._otherLocalVariable);
        copy.setReference(this._reference);
        copy.setFormula(this._formula);
        this._selectTable.copy(copy._selectTable);
        copy.setListenToMemory(this._listenToMemory);
        copy.setListenToBlock(this._listenToBlock);
        copy.setListenToReporter(this._listenToReporter);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectTable getSelectTableToSet() {
        return this._selectTableToSet;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public LogixNG_SelectNamedBean<Block> getSelectBlockNamedBean() {
        return this._selectBlockNamedBean;
    }

    public LogixNG_SelectNamedBean<Reporter> getSelectReporterNamedBean() {
        return this._selectReporterNamedBean;
    }

    public void setVariableOperation(VariableOperation variableOperation) throws ParserException {
        this._variableOperation = variableOperation;
        this.parseFormula();
    }

    public VariableOperation getVariableOperation() {
        return this._variableOperation;
    }

    public LogixNG_SelectTable getSelectTable() {
        return this._selectTable;
    }

    public void setOtherLocalVariable(@Nonnull String localVariable) {
        this.assertListenersAreNotRegistered(log, "setOtherLocalVariable");
        this._otherLocalVariable = localVariable;
    }

    public String getOtherLocalVariable() {
        return this._otherLocalVariable;
    }

    public void setReference(@Nonnull String reference) {
        this.assertListenersAreNotRegistered(log, "setReference");
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setConstantType(ConstantType constantType) {
        this._constantType = constantType;
    }

    public ConstantType getConstantType() {
        return this._constantType;
    }

    public void setConstantValue(String constantValue) {
        this._constantValue = constantValue;
    }

    public String getConstantValue() {
        return this._constantValue;
    }

    public void setFormula(String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    public void setListenToMemory(boolean listenToMemory) {
        this._listenToMemory = listenToMemory;
    }

    public boolean getListenToMemory() {
        return this._listenToMemory;
    }

    public void setListenToBlock(boolean listenToBlock) {
        this._listenToBlock = listenToBlock;
    }

    public boolean getListenToBlock() {
        return this._listenToBlock;
    }

    public void setListenToReporter(boolean listenToReporter) {
        this._listenToReporter = listenToReporter;
    }

    public boolean getListenToReporter() {
        return this._listenToReporter;
    }

    private void parseFormula() throws ParserException {
        if (this._variableOperation == VariableOperation.CalculateFormula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        AtomicReference ref = new AtomicReference();
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            Object value;
            block0 : switch (this._variableOperation) {
                case SetToNull: {
                    value = null;
                    break;
                }
                case SetToString: {
                    switch (this._constantType) {
                        case String: {
                            value = this._constantValue;
                            break block0;
                        }
                        case Integer: {
                            value = TypeConversionUtil.convertToLong(this._constantValue);
                            break block0;
                        }
                        case FloatingNumber: {
                            value = TypeConversionUtil.convertToDouble(this._constantValue, true, true, true);
                            break block0;
                        }
                        case Boolean: {
                            value = TypeConversionUtil.convertToBoolean(this._constantValue, true);
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("_constantType has invalid value: {}" + this._constantType.name());
                }
                case CopyVariableToVariable: {
                    value = conditionalNG.getSymbolTable().getValue(this._otherLocalVariable);
                    break;
                }
                case CopyMemoryToVariable: {
                    Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (memory != null) {
                        value = memory.getValue();
                        break;
                    }
                    log.warn("ActionTable should copy memory to variable but memory is null");
                    return;
                }
                case CopyReferenceToVariable: {
                    value = ReferenceUtil.getReference(conditionalNG.getSymbolTable(), this._reference);
                    break;
                }
                case CopyTableCellToVariable: {
                    value = this._selectTable.evaluateTableData(conditionalNG);
                    break;
                }
                case CopyBlockToVariable: {
                    Block block = this._selectBlockNamedBean.evaluateNamedBean(conditionalNG);
                    if (block != null) {
                        value = block.getValue();
                        break;
                    }
                    log.warn("ActionTable should copy block value to variable but block is null");
                    return;
                }
                case CopyReporterToVariable: {
                    Reporter reporter = this._selectReporterNamedBean.evaluateNamedBean(conditionalNG);
                    if (reporter != null) {
                        value = reporter.getCurrentReport();
                        break;
                    }
                    log.warn("ActionTable should copy current report to variable but reporter is null");
                    return;
                }
                case CalculateFormula: {
                    if (this._formula.isEmpty()) {
                        value = null;
                        break;
                    }
                    if (this._expressionNode == null) {
                        return;
                    }
                    value = this._expressionNode.calculate(conditionalNG.getSymbolTable());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("_variableOperation has invalid value: {}" + this._variableOperation.name());
                }
            }
            this._selectTableToSet.evaluateAndSetTableData(conditionalNG, value);
        });
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionTable_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String setTableName = this._selectTableToSet.getTableNameDescription(locale);
        String setRowName = this._selectTableToSet.getTableRowDescription(locale);
        String setColumnName = this._selectTableToSet.getTableColumnDescription(locale);
        String setTable = Bundle.getMessage(locale, "ActionTable_Table", setTableName, setRowName, setColumnName);
        String copyToMemoryName = this._selectMemoryNamedBean.getDescription(locale);
        String copyToBlockName = this._selectBlockNamedBean.getDescription(locale);
        String copyToReporterName = this._selectReporterNamedBean.getDescription(locale);
        switch (this._variableOperation) {
            case SetToNull: {
                return Bundle.getMessage(locale, "ActionTable_Long_Null", setTable);
            }
            case SetToString: {
                return Bundle.getMessage(locale, "ActionTable_Long_Value", setTable, this._constantType._text, this._constantValue);
            }
            case CopyVariableToVariable: {
                return Bundle.getMessage(locale, "ActionTable_Long_CopyVariableToVariable", setTable, this._otherLocalVariable);
            }
            case CopyMemoryToVariable: {
                return Bundle.getMessage(locale, "ActionTable_Long_CopyMemoryToVariable", setTable, copyToMemoryName, Base.getListenString(this._listenToMemory));
            }
            case CopyReferenceToVariable: {
                return Bundle.getMessage(locale, "ActionTable_Long_CopyReferenceToVariable", setTable, this._reference);
            }
            case CopyBlockToVariable: {
                return Bundle.getMessage(locale, "ActionTable_Long_CopyBlockToVariable", setTable, copyToBlockName, Base.getListenString(this._listenToBlock));
            }
            case CopyTableCellToVariable: {
                String tableName = this._selectTable.getTableNameDescription(locale);
                String rowName = this._selectTable.getTableRowDescription(locale);
                String columnName = this._selectTable.getTableColumnDescription(locale);
                return Bundle.getMessage(locale, "ActionTable_Long_CopyTableCellToVariable", setTable, tableName, rowName, columnName);
            }
            case CopyReporterToVariable: {
                return Bundle.getMessage(locale, "ActionTable_Long_CopyReporterToVariable", setTable, copyToReporterName, Base.getListenString(this._listenToReporter));
            }
            case CalculateFormula: {
                return Bundle.getMessage(locale, "ActionTable_Long_Formula", setTable, this._formula);
            }
        }
        throw new IllegalArgumentException("_variableOperation has invalid value: " + this._variableOperation.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            if (this._listenToMemory && this._variableOperation == VariableOperation.CopyMemoryToVariable) {
                this._selectMemoryNamedBean.addPropertyChangeListener("value", this);
            }
            if (this._listenToBlock && this._variableOperation == VariableOperation.CopyBlockToVariable) {
                this._selectBlockNamedBean.addPropertyChangeListener("value", this);
            }
            if (this._listenToReporter && this._variableOperation == VariableOperation.CopyReporterToVariable) {
                this._selectReporterNamedBean.addPropertyChangeListener("currentReport", this);
            }
            this._selectMemoryNamedBean.registerListeners();
            this._selectBlockNamedBean.registerListeners();
            this._selectReporterNamedBean.registerListeners();
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._listenToMemory && this._variableOperation == VariableOperation.CopyMemoryToVariable) {
                this._selectMemoryNamedBean.removePropertyChangeListener("value", this);
            }
            if (this._listenToBlock && this._variableOperation == VariableOperation.CopyBlockToVariable) {
                this._selectBlockNamedBean.removePropertyChangeListener("value", this);
            }
            if (this._listenToReporter && this._variableOperation == VariableOperation.CopyReporterToVariable) {
                this._selectReporterNamedBean.removePropertyChangeListener("currentReport", this);
            }
            this._selectMemoryNamedBean.unregisterListeners();
            this._selectBlockNamedBean.unregisterListeners();
            this._selectReporterNamedBean.unregisterListeners();
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionTable: bean = {}, report = {}", (Object)cdl, report);
        this._selectMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectBlockNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectReporterNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    public static enum ConstantType {
        String(Bundle.getMessage("ActionTable_ConstantType_String")),
        Integer(Bundle.getMessage("ActionTable_ConstantType_Integer")),
        FloatingNumber(Bundle.getMessage("ActionTable_ConstantType_FloatingNumber")),
        Boolean(Bundle.getMessage("ActionTable_ConstantType_Boolean"));

        private final String _text;

        private ConstantType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum VariableOperation {
        SetToNull(Bundle.getMessage("ActionTable_VariableOperation_SetToNull")),
        SetToString(Bundle.getMessage("ActionTable_VariableOperation_SetToString")),
        CopyVariableToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyVariableToVariable")),
        CopyMemoryToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyMemoryToVariable")),
        CopyReferenceToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyReferenceToVariable")),
        CopyTableCellToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyTableCellToVariable")),
        CopyBlockToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyBlockToVariable")),
        CopyReporterToVariable(Bundle.getMessage("ActionTable_VariableOperation_CopyReporterToVariable")),
        CalculateFormula(Bundle.getMessage("ActionTable_VariableOperation_CalculateFormula"));

        private final String _text;

        private VariableOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

