/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.SystemConnectionMemo;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.AnalogExpressionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleAnalogExpressionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleAnalogExpressionSocket;
import jmri.jmrit.logixng.MaleDigitalExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionThrottle
extends AbstractDigitalAction
implements FemaleSocketListener {
    public static final int LOCO_ADDRESS_SOCKET = 0;
    public static final int LOCO_SPEED_SOCKET = 1;
    public static final int LOCO_DIRECTION_SOCKET = 2;
    public static final int LOCO_FUNCTION_SOCKET = 3;
    public static final int LOCO_FUNCTION_ONOFF_SOCKET = 4;
    public static final int NUM_LOCO_SOCKETS = 5;
    private SystemConnectionMemo _memo;
    private ThrottleManager _throttleManager;
    private ThrottleManager _oldThrottleManager;
    private DccThrottle _throttle;
    private ThrottleListener _throttleListener;
    private String _locoAddressSocketSystemName;
    private String _locoSpeedSocketSystemName;
    private String _locoDirectionSocketSystemName;
    private String _locoFunctionSocketSystemName;
    private String _locoFunctionOnOffSocketSystemName;
    private final FemaleAnalogExpressionSocket _locoAddressSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Address"));
    private final FemaleAnalogExpressionSocket _locoSpeedSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Speed"));
    private final FemaleDigitalExpressionSocket _locoDirectionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Direction"));
    private final FemaleAnalogExpressionSocket _locoFunctionSocket = InstanceManager.getDefault(AnalogExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_Function"));
    private final FemaleDigitalExpressionSocket _locoFunctionOnOffSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ActionThrottle_SocketName_FunctionOnOff"));
    private boolean _stopLocoWhenSwitchingLoco = true;
    private static final Logger log = LoggerFactory.getLogger(ActionThrottle.class);

    public ActionThrottle(String sys, String user) {
        super(sys, user);
        this.setMemo(null);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionThrottle copy = new ActionThrottle(sysName, userName);
        copy.setComment(this.getComment());
        copy.setMemo(this._memo);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public void setMemo(SystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
        if (this._memo != null) {
            this._throttleManager = this._memo.get(ThrottleManager.class);
            if (this._throttleManager == null) {
                throw new IllegalArgumentException("Memo " + memo.getUserName() + " doesn't have a ThrottleManager");
            }
        } else {
            this._throttleManager = InstanceManager.getDefault(ThrottleManager.class);
        }
    }

    public SystemConnectionMemo getMemo() {
        return this._memo;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        int currentLocoAddress = -1;
        int newLocoAddress = -1;
        if (this._throttle != null) {
            currentLocoAddress = this._throttle.getLocoAddress().getNumber();
        }
        if (this._locoAddressSocket.isConnected()) {
            newLocoAddress = (int)((MaleAnalogExpressionSocket)this._locoAddressSocket.getConnectedSocket()).evaluate();
        }
        if (this._throttleManager != this._oldThrottleManager) {
            currentLocoAddress = -1;
            this._oldThrottleManager = this._throttleManager;
        }
        if (newLocoAddress != currentLocoAddress) {
            if (this._throttle != null) {
                if (this._stopLocoWhenSwitchingLoco) {
                    this._throttle.setSpeedSetting(0.0f);
                }
                this._throttleManager.releaseThrottle(this._throttle, this._throttleListener);
                this._throttle = null;
            }
            if (newLocoAddress != -1) {
                this._throttleListener = new ThrottleListener(){

                    @Override
                    public void notifyThrottleFound(DccThrottle t) {
                        ActionThrottle.this._throttle = t;
                        ActionThrottle.this.executeConditionalNG();
                    }

                    @Override
                    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                        log.warn("loco {} cannot be aquired", (Object)address.getNumber());
                    }

                    @Override
                    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
                        log.warn("Loco {} cannot be aquired. Decision required.", (Object)address.getNumber());
                    }
                };
                boolean result = this._throttleManager.requestThrottle(newLocoAddress, this._throttleListener);
                if (!result) {
                    log.warn("loco {} cannot be aquired", (Object)newLocoAddress);
                }
            }
        }
        if (this._throttle != null) {
            double speed = 0.0;
            boolean isForward = true;
            int function = 0;
            boolean isFunctionOn = true;
            if (this._locoSpeedSocket.isConnected()) {
                speed = ((MaleAnalogExpressionSocket)this._locoSpeedSocket.getConnectedSocket()).evaluate();
            }
            if (this._locoDirectionSocket.isConnected()) {
                isForward = ((MaleDigitalExpressionSocket)this._locoDirectionSocket.getConnectedSocket()).evaluate();
            }
            if (this._locoFunctionSocket.isConnected()) {
                function = (int)Math.round(((MaleAnalogExpressionSocket)this._locoFunctionSocket.getConnectedSocket()).evaluate());
            }
            if (this._locoFunctionOnOffSocket.isConnected()) {
                isFunctionOn = ((MaleDigitalExpressionSocket)this._locoFunctionOnOffSocket.getConnectedSocket()).evaluate();
            }
            DccThrottle throttle = this._throttle;
            float spd = (float)speed;
            boolean fwd = isForward;
            int func = function;
            boolean funcState = isFunctionOn;
            ThreadingUtil.runOnLayoutWithJmriException(() -> {
                if (this._locoSpeedSocket.isConnected()) {
                    throttle.setSpeedSetting(spd);
                }
                if (this._locoDirectionSocket.isConnected()) {
                    throttle.setIsForward(fwd);
                }
                if (this._locoFunctionSocket.isConnected() && this._locoFunctionOnOffSocket.isConnected()) {
                    throttle.setFunction(func, funcState);
                }
            });
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._locoAddressSocket;
            }
            case 1: {
                return this._locoSpeedSocket;
            }
            case 2: {
                return this._locoDirectionSocket;
            }
            case 3: {
                return this._locoFunctionSocket;
            }
            case 4: {
                return this._locoFunctionOnOffSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 5;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._locoAddressSocket) {
            this._locoAddressSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoSpeedSocket) {
            this._locoSpeedSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoDirectionSocket) {
            this._locoDirectionSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoFunctionSocket) {
            this._locoFunctionSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else if (socket == this._locoFunctionOnOffSocket) {
            this._locoFunctionOnOffSocketSystemName = socket.getConnectedSocket().getSystemName();
            this.executeConditionalNG();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._locoAddressSocket) {
            if (this._throttle != null) {
                this._throttle.setSpeedSetting(0.0f);
                this._throttleManager.releaseThrottle(this._throttle, this._throttleListener);
            }
            this._locoAddressSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoSpeedSocket) {
            this._locoSpeedSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoDirectionSocket) {
            this._locoDirectionSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoFunctionSocket) {
            this._locoFunctionSocketSystemName = null;
            this.executeConditionalNG();
        } else if (socket == this._locoFunctionOnOffSocket) {
            this._locoFunctionOnOffSocketSystemName = null;
            this.executeConditionalNG();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    private void executeConditionalNG() {
        ConditionalNG c;
        if (this._listenersAreRegistered && (c = this.getConditionalNG()) != null) {
            c.execute();
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionThrottle_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._memo != null) {
            return Bundle.getMessage(locale, "ActionThrottle_LongConnection", this._memo.getUserName());
        }
        return Bundle.getMessage(locale, "ActionThrottle_Long");
    }

    public FemaleAnalogExpressionSocket getLocoAddressSocket() {
        return this._locoAddressSocket;
    }

    public String getLocoAddressSocketSystemName() {
        return this._locoAddressSocketSystemName;
    }

    public void setLocoAddressSocketSystemName(String systemName) {
        this._locoAddressSocketSystemName = systemName;
    }

    public FemaleAnalogExpressionSocket getLocoSpeedSocket() {
        return this._locoSpeedSocket;
    }

    public String getLocoSpeedSocketSystemName() {
        return this._locoSpeedSocketSystemName;
    }

    public void setLocoSpeedSocketSystemName(String systemName) {
        this._locoSpeedSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getLocoDirectionSocket() {
        return this._locoDirectionSocket;
    }

    public String getLocoDirectionSocketSystemName() {
        return this._locoDirectionSocketSystemName;
    }

    public void setLocoDirectionSocketSystemName(String systemName) {
        this._locoDirectionSocketSystemName = systemName;
    }

    public FemaleAnalogExpressionSocket getLocoFunctionSocket() {
        return this._locoFunctionSocket;
    }

    public String getLocoFunctionSocketSystemName() {
        return this._locoFunctionSocketSystemName;
    }

    public void setLocoFunctionSocketSystemName(String systemName) {
        this._locoFunctionSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getLocoFunctionOnOffSocket() {
        return this._locoFunctionOnOffSocket;
    }

    public String getLocoFunctionOnOffSocketSystemName() {
        return this._locoFunctionOnOffSocketSystemName;
    }

    public void setLocoFunctionOnOffSocketSystemName(String systemName) {
        this._locoFunctionOnOffSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._locoAddressSocket.isConnected() || !this._locoAddressSocket.getConnectedSocket().getSystemName().equals(this._locoAddressSocketSystemName)) {
                socketSystemName = this._locoAddressSocketSystemName;
                this._locoAddressSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoAddressSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoAddressSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._locoAddressSocket.getConnectedSocket().setup();
            }
            if (!this._locoSpeedSocket.isConnected() || !this._locoSpeedSocket.getConnectedSocket().getSystemName().equals(this._locoSpeedSocketSystemName)) {
                socketSystemName = this._locoSpeedSocketSystemName;
                this._locoSpeedSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoSpeedSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoSpeedSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._locoSpeedSocket.getConnectedSocket().setup();
            }
            if (!this._locoDirectionSocket.isConnected() || !this._locoDirectionSocket.getConnectedSocket().getSystemName().equals(this._locoDirectionSocketSystemName)) {
                socketSystemName = this._locoDirectionSocketSystemName;
                this._locoDirectionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoDirectionSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoDirectionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._locoDirectionSocket.getConnectedSocket().setup();
            }
            if (!this._locoFunctionSocket.isConnected() || !this._locoFunctionSocket.getConnectedSocket().getSystemName().equals(this._locoFunctionSocketSystemName)) {
                socketSystemName = this._locoFunctionSocketSystemName;
                this._locoFunctionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(AnalogExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoFunctionSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoFunctionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load analog expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._locoFunctionSocket.getConnectedSocket().setup();
            }
            if (!this._locoFunctionOnOffSocket.isConnected() || !this._locoFunctionOnOffSocket.getConnectedSocket().getSystemName().equals(this._locoFunctionOnOffSocketSystemName)) {
                socketSystemName = this._locoFunctionOnOffSocketSystemName;
                this._locoFunctionOnOffSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    this._locoFunctionOnOffSocket.disconnect();
                    if (maleSocket != null) {
                        this._locoFunctionOnOffSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._locoFunctionOnOffSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    public boolean isStopLocoWhenSwitchingLoco() {
        return this._stopLocoWhenSwitchingLoco;
    }

    public void setStopLocoWhenSwitchingLoco(boolean value) {
        this._stopLocoWhenSwitchingLoco = value;
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
        if (this._throttle != null) {
            this._throttleManager.releaseThrottle(this._throttle, this._throttleListener);
        }
    }
}

