/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.SystemConnectionMemo;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionThrottleFunction
extends AbstractDigitalAction
implements PropertyChangeListener {
    private SystemConnectionMemo _memo;
    private ThrottleManager _throttleManager;
    private ThrottleManager _oldThrottleManager;
    private DccThrottle _throttle;
    private ThrottleListener _throttleListener;
    private final LogixNG_SelectInteger _selectAddress = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectInteger _selectFunction = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectEnum<FunctionState> _selectOnOff = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])FunctionState.values(), (Enum)FunctionState.On, (PropertyChangeListener)this);
    private static final Logger log = LoggerFactory.getLogger(ActionThrottleFunction.class);

    public ActionThrottleFunction(String sys, String user) {
        super(sys, user);
        this.setMemo(null);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionThrottleFunction copy = new ActionThrottleFunction(sysName, userName);
        copy.setComment(this.getComment());
        copy.setMemo(this._memo);
        this._selectAddress.copy(copy._selectAddress);
        this._selectFunction.copy(copy._selectFunction);
        this._selectOnOff.copy(copy._selectOnOff);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectInteger getSelectAddress() {
        return this._selectAddress;
    }

    public LogixNG_SelectInteger getSelectFunction() {
        return this._selectFunction;
    }

    public LogixNG_SelectEnum<FunctionState> getSelectOnOff() {
        return this._selectOnOff;
    }

    public void setMemo(SystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
        if (this._memo != null) {
            this._throttleManager = this._memo.get(ThrottleManager.class);
            if (this._throttleManager == null) {
                throw new IllegalArgumentException("Memo " + memo.getUserName() + " doesn't have a ThrottleManager");
            }
        } else {
            this._throttleManager = InstanceManager.getDefault(ThrottleManager.class);
        }
    }

    public SystemConnectionMemo getMemo() {
        return this._memo;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        int currentLocoAddress = -1;
        int newLocoAddress = -1;
        if (this._throttle != null) {
            currentLocoAddress = this._throttle.getLocoAddress().getNumber();
        }
        newLocoAddress = this._selectAddress.evaluateValue(conditionalNG);
        if (this._throttleManager != this._oldThrottleManager) {
            currentLocoAddress = -1;
            this._oldThrottleManager = this._throttleManager;
        }
        if (newLocoAddress != currentLocoAddress) {
            if (this._throttle != null) {
                this._throttleManager.releaseThrottle(this._throttle, this._throttleListener);
                this._throttle = null;
            }
            if (newLocoAddress != -1) {
                this._throttleListener = new ThrottleListener(){

                    @Override
                    public void notifyThrottleFound(DccThrottle t) {
                        ActionThrottleFunction.this._throttle = t;
                        ActionThrottleFunction.this.executeConditionalNG();
                    }

                    @Override
                    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                        log.warn("loco {} cannot be aquired", (Object)address.getNumber());
                    }

                    @Override
                    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
                        log.warn("Loco {} cannot be aquired. Decision required.", (Object)address.getNumber());
                    }
                };
                boolean result = this._throttleManager.requestThrottle(newLocoAddress, this._throttleListener);
                if (!result) {
                    log.warn("loco {} cannot be aquired", (Object)newLocoAddress);
                }
            }
        }
        if (this._throttle != null) {
            int function = this._selectFunction.evaluateValue(conditionalNG);
            boolean isFunctionOn = this._selectOnOff.evaluateEnum((ConditionalNG)conditionalNG)._value;
            DccThrottle throttle = this._throttle;
            int func = function;
            boolean funcState = isFunctionOn;
            ThreadingUtil.runOnLayoutWithJmriException(() -> throttle.setFunction(func, funcState));
        }
    }

    private void executeConditionalNG() {
        ConditionalNG c;
        if (this._listenersAreRegistered && (c = this.getConditionalNG()) != null) {
            c.execute();
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionThrottleFunction_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._memo != null) {
            return Bundle.getMessage(locale, "ActionThrottleFunction_LongConnection", this._selectAddress.getDescription(locale), this._selectFunction.getDescription(locale), this._selectOnOff.getDescription(locale), this._memo.getUserName());
        }
        return Bundle.getMessage(locale, "ActionThrottleFunction_Long", this._selectAddress.getDescription(locale), this._selectFunction.getDescription(locale), this._selectOnOff.getDescription(locale));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._listenersAreRegistered = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
        if (this._throttle != null) {
            this._throttleManager.releaseThrottle(this._throttle, this._throttleListener);
        }
    }

    public static enum FunctionState {
        Off(false, Bundle.getMessage("StateOff")),
        On(true, Bundle.getMessage("StateOn"));

        private final boolean _value;
        private final String _text;

        private FunctionState(boolean value, String text) {
            this._value = value;
            this._text = text;
        }

        public boolean getValue() {
            return this._value;
        }

        public String toString() {
            return this._text;
        }
    }
}

