/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTurnout
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private final LogixNG_SelectNamedBean<Turnout> _selectNamedBean = new LogixNG_SelectNamedBean<Turnout>(this, Turnout.class, InstanceManager.getDefault(TurnoutManager.class), this);
    private final LogixNG_SelectEnum<TurnoutState> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])TurnoutState.values(), (Enum)TurnoutState.Thrown, (PropertyChangeListener)this);
    private static final int TOGGLE_ID = -1;
    private static final Logger log = LoggerFactory.getLogger(ActionTurnout.class);

    public ActionTurnout(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user, Category.ITEM);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionTurnout copy = new ActionTurnout(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Turnout> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<TurnoutState> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public void execute() throws JmriException {
        Turnout turnout = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (turnout == null) {
            return;
        }
        TurnoutState state = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            if (state == TurnoutState.Toggle) {
                if (turnout.getKnownState() == 2) {
                    turnout.setCommandedState(4);
                } else {
                    turnout.setCommandedState(2);
                }
            } else {
                turnout.setCommandedState(state.getID());
            }
        });
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Turnout_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        return Bundle.getMessage(locale, "Turnout_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        log.debug("getUsageReport :: ActionTurnout: bean = {}, report = {}", (Object)cdl, report);
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum TurnoutState {
        Closed(2, InstanceManager.getDefault(TurnoutManager.class).getClosedText()),
        Thrown(4, InstanceManager.getDefault(TurnoutManager.class).getThrownText()),
        Toggle(-1, Bundle.getMessage("TurnoutToggleStatus")),
        Unknown(1, Bundle.getMessage("BeanStateUnknown")),
        Inconsistent(8, Bundle.getMessage("BeanStateInconsistent"));

        private final int _id;
        private final String _text;

        private TurnoutState(int id, String text) {
            this._id = id;
            this._text = text;
        }

        public static TurnoutState get(int id) {
            switch (id) {
                case 1: {
                    return Unknown;
                }
                case 8: {
                    return Inconsistent;
                }
                case 2: {
                    return Closed;
                }
                case 4: {
                    return Thrown;
                }
                case -1: {
                    return Toggle;
                }
            }
            throw new IllegalArgumentException("invalid turnout state");
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            return this._text;
        }
    }
}

