/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionWarrant
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<Warrant> _selectNamedBean = new LogixNG_SelectNamedBean<Warrant>(this, Warrant.class, InstanceManager.getDefault(WarrantManager.class), this);
    private final LogixNG_SelectEnum<DirectOperation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])DirectOperation.values(), (Enum)DirectOperation.AllocateWarrantRoute, (PropertyChangeListener)this);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private NamedBeanAddressing _dataAddressing = NamedBeanAddressing.Direct;
    private String _dataReference = "";
    private String _dataLocalVariable = "";
    private String _dataFormula = "";
    private ExpressionNode _dataExpressionNode;
    private String _trainData = "";
    private ControlAutoTrain _controlAutoTrain = ControlAutoTrain.Halt;
    private static final Logger log = LoggerFactory.getLogger(ActionWarrant.class);

    public ActionWarrant(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ActionWarrant copy = new ActionWarrant(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        copy.setDataAddressing(this._dataAddressing);
        copy.setDataReference(this._dataReference);
        copy.setDataLocalVariable(this._dataLocalVariable);
        copy.setDataFormula(this._dataFormula);
        copy.setTrainData(this._trainData);
        copy.setControlAutoTrain(this._controlAutoTrain);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<Warrant> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public LogixNG_SelectEnum<DirectOperation> getSelectEnum() {
        return this._selectEnum;
    }

    public void setDataAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._dataAddressing = addressing;
        this.parseDataFormula();
    }

    public NamedBeanAddressing getDataAddressing() {
        return this._dataAddressing;
    }

    public void setDataReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._dataReference = reference;
    }

    public String getDataReference() {
        return this._dataReference;
    }

    public void setDataLocalVariable(@Nonnull String localVariable) {
        this._dataLocalVariable = localVariable;
    }

    public String getDataLocalVariable() {
        return this._dataLocalVariable;
    }

    public void setDataFormula(@Nonnull String formula) throws ParserException {
        this._dataFormula = formula;
        this.parseDataFormula();
    }

    public String getDataFormula() {
        return this._dataFormula;
    }

    private void parseDataFormula() throws ParserException {
        if (this._dataAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._dataExpressionNode = parser.parseExpression(this._dataFormula);
        } else {
            this._dataExpressionNode = null;
        }
    }

    public void setTrainData(@Nonnull String trainData) {
        this._trainData = trainData;
    }

    public String getTrainData() {
        return this._trainData;
    }

    public void setControlAutoTrain(ControlAutoTrain controlAutoTrain) {
        this._controlAutoTrain = controlAutoTrain;
    }

    public ControlAutoTrain getControlAutoTrain() {
        return this._controlAutoTrain;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private String getNewData(DirectOperation theOper, SymbolTable symbolTable) throws JmriException {
        switch (this._dataAddressing) {
            case Direct: {
                switch (theOper) {
                    case SetTrainId: 
                    case SetTrainName: {
                        return this._trainData;
                    }
                    case ControlAutoTrain: {
                        return this._controlAutoTrain.name();
                    }
                }
                return "";
            }
            case Reference: {
                return ReferenceUtil.getReference(symbolTable, this._dataReference);
            }
            case LocalVariable: {
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._dataLocalVariable), false);
            }
            case Formula: {
                return this._dataExpressionNode != null ? TypeConversionUtil.convertToString(this._dataExpressionNode.calculate(symbolTable), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        Warrant warrant = this._selectNamedBean.evaluateNamedBean(conditionalNG);
        if (warrant == null) {
            return;
        }
        SymbolTable symbolTable = conditionalNG.getSymbolTable();
        DirectOperation theOper = this._selectEnum.evaluateEnum(conditionalNG);
        if (!theOper.equals((Object)DirectOperation.GetTrainLocation) && warrant.getRunMode() == 2 && !theOper.equals((Object)DirectOperation.ControlAutoTrain)) {
            throw new JmriException("Cannot \"" + theOper.toString() + "\" when warrant is running - " + warrant.getDisplayName());
        }
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            switch (theOper) {
                case AllocateWarrantRoute: {
                    warrant.allocateRoute(false, null);
                    break;
                }
                case DeallocateWarrant: {
                    warrant.deAllocate();
                    break;
                }
                case SetRouteTurnouts: {
                    String msg = warrant.setRoute(false, null);
                    if (msg == null) break;
                    log.warn("Warrant {} unable to Set Route - {}", (Object)warrant.getDisplayName(), (Object)msg);
                    break;
                }
                case AutoRunTrain: {
                    WarrantTableFrame frame = WarrantTableFrame.getDefault();
                    String err = frame.runTrain(warrant, 2);
                    if (err == null) break;
                    warrant.stopWarrant(true, true);
                    throw new JmriException("runAutoTrain error - " + err);
                }
                case ManuallyRunTrain: {
                    String err = warrant.setRoute(false, null);
                    if (err == null) {
                        err = warrant.setRunMode(3, null, null, null, false);
                    }
                    if (err == null) break;
                    throw new JmriException("runManualTrain error - " + err);
                }
                case ControlAutoTrain: {
                    int controlAction = 0;
                    switch (this._controlAutoTrain) {
                        case Halt: {
                            controlAction = 1;
                            break;
                        }
                        case Resume: {
                            controlAction = 2;
                            break;
                        }
                        case Stop: {
                            controlAction = 0;
                            break;
                        }
                        case EStop: {
                            controlAction = 5;
                            break;
                        }
                        case SpeedUp: {
                            controlAction = 7;
                            break;
                        }
                        case MoveToNext: {
                            controlAction = 4;
                            break;
                        }
                        case Abort: {
                            controlAction = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid train control action: " + this._controlAutoTrain);
                        }
                    }
                    if (warrant.controlRunTrain(controlAction)) break;
                    log.info("Warrant {} {}({}) failed. - {}", new Object[]{warrant.getDisplayName(), theOper.toString(), this._controlAutoTrain.toString(), warrant.getMessage()});
                    throw new JmriException("Warrant " + warrant.getDisplayName() + " " + theOper.toString() + "(" + this._controlAutoTrain.toString() + ") failed. " + warrant.getMessage());
                }
                case SetTrainId: {
                    if (warrant.getSpeedUtil().setAddress(this.getNewData(theOper, symbolTable))) break;
                    throw new JmriException("invalid train ID in action - " + warrant.getDisplayName());
                }
                case SetTrainName: {
                    warrant.setTrainName(this.getNewData(theOper, symbolTable));
                    break;
                }
                case GetTrainLocation: {
                    Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(conditionalNG);
                    if (memory != null) {
                        memory.setValue(warrant.getCurrentBlockName());
                        break;
                    }
                    throw new JmriException("Memory for GetTrainLocation is null for warrant - " + warrant.getDisplayName());
                }
                default: {
                    throw new IllegalArgumentException("invalid oper state: " + theOper.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ActionWarrant_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        String getLocationMemory = this._selectMemoryNamedBean.getDescription(locale);
        if (this._selectEnum.getAddressing() == NamedBeanAddressing.Direct && this._selectEnum.getEnum() != null) {
            switch (this._selectEnum.getEnum()) {
                case SetTrainId: {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Train_Id", namedBean, this._trainData);
                }
                case SetTrainName: {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Train_Name", namedBean, this._trainData);
                }
                case ControlAutoTrain: {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Control", namedBean, this._controlAutoTrain.name());
                }
                case GetTrainLocation: {
                    return this.getLongDataDescription(locale, "ActionWarrant_Long_Location", namedBean, getLocationMemory);
                }
            }
        }
        return Bundle.getMessage(locale, "ActionWarrant_Long", namedBean, state);
    }

    private String getLongDataDescription(Locale locale, String bundleKey, String namedBean, String value) {
        switch (this._dataAddressing) {
            case Direct: {
                return Bundle.getMessage(locale, bundleKey, namedBean, value);
            }
            case Reference: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByReference", this._dataReference));
            }
            case LocalVariable: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByLocalVariable", this._dataLocalVariable));
            }
            case Formula: {
                return Bundle.getMessage(locale, bundleKey, namedBean, Bundle.getMessage("AddressByFormula", this._dataFormula));
            }
        }
        throw new IllegalArgumentException("invalid _dataAddressing state: " + this._dataAddressing.name());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
        this._selectMemoryNamedBean.addPropertyChangeListener("value", this);
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
        this._selectMemoryNamedBean.removePropertyChangeListener("value", this);
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
        this._selectNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
        this._selectMemoryNamedBean.getUsageDetail(level, bean, report, cdl, this, LogixNG_SelectNamedBean.Type.Action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum ControlAutoTrain {
        Halt(Bundle.getMessage("ActionWarrant_Halt_AutoTrain")),
        Resume(Bundle.getMessage("ActionWarrant_Resume_AutoTrain")),
        Abort(Bundle.getMessage("ActionWarrant_Abort_AutoTrain")),
        Stop(Bundle.getMessage("ActionWarrant_Stop_AutoTrain")),
        EStop(Bundle.getMessage("ActionWarrant_EStop_AutoTrain")),
        MoveToNext(Bundle.getMessage("ActionWarrant_MoveToNext_AutoTrain")),
        SpeedUp(Bundle.getMessage("ActionWarrant_SpeedUp_AutoTrain"));

        private final String _text;

        private ControlAutoTrain(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum DirectOperation {
        None(""),
        AllocateWarrantRoute(Bundle.getMessage("ActionWarrant_AllocateWarrantRoute")),
        DeallocateWarrant(Bundle.getMessage("ActionWarrant_DeallocateWarrant")),
        SetRouteTurnouts(Bundle.getMessage("ActionWarrant_SetRouteTurnouts")),
        AutoRunTrain(Bundle.getMessage("ActionWarrant_AutoRunTrain")),
        ManuallyRunTrain(Bundle.getMessage("ActionWarrant_ManuallyRunTrain")),
        ControlAutoTrain(Bundle.getMessage("ActionWarrant_ControlAutoTrain")),
        SetTrainId(Bundle.getMessage("ActionWarrant_SetTrainId")),
        SetTrainName(Bundle.getMessage("ActionWarrant_SetTrainName")),
        GetTrainLocation(Bundle.getMessage("ActionWarrant_GetTrainLocation"));

        private final String _text;

        private DirectOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

