/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.VariableLight;
import jmri.VariableLightManager;
import jmri.jmrit.logixng.AnalogActionManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractAnalogAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;

public class AnalogActionLightIntensity
extends AbstractAnalogAction
implements PropertyChangeListener {
    public static final int INTENSITY_SOCKET = 0;
    private final LogixNG_SelectNamedBean<VariableLight> _selectNamedBean = new LogixNG_SelectNamedBean<VariableLight>(this, VariableLight.class, InstanceManager.getDefault(VariableLightManager.class), this);

    public AnalogActionLightIntensity(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        AnalogActionManager manager = InstanceManager.getDefault(AnalogActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        AnalogActionLightIntensity copy = new AnalogActionLightIntensity(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<VariableLight> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void setValue(double value) throws JmriException {
        VariableLight light = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (light == null) {
            return;
        }
        double intensity = value;
        if (intensity < 0.0) {
            intensity = 0.0;
        }
        if (intensity > 100.0) {
            intensity = 100.0;
        }
        light.setTargetIntensity(intensity / 100.0);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "AnalogActionLightIntensity_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        return Bundle.getMessage(locale, "AnalogActionLightIntensity_Long", namedBean);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._listenersAreRegistered = true;
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._listenersAreRegistered = false;
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }
}

