/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalBooleanActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalBooleanAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalBooleanLogixAction
extends AbstractDigitalBooleanAction
implements FemaleSocketListener {
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket;
    When _when = When.Either;
    private static final Logger log = LoggerFactory.getLogger(DigitalBooleanLogixAction.class);

    public DigitalBooleanLogixAction(String sys, String user, When trigger) {
        super(sys, user);
        this._socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
        this._when = trigger;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalBooleanActionManager manager = InstanceManager.getDefault(DigitalBooleanActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        DigitalBooleanLogixAction copy = new DigitalBooleanLogixAction(sysName, userName, this._when);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void execute(boolean value) throws JmriException {
        if (this._socket.isConnected()) {
            switch (this._when) {
                case True: {
                    if (!value) break;
                    this._socket.execute();
                    break;
                }
                case False: {
                    if (value) break;
                    this._socket.execute();
                    break;
                }
                case Either: {
                    this._socket.execute();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("_whichChange has unknown value: " + this._when);
                }
            }
        }
    }

    public When getTrigger() {
        return this._when;
    }

    public void setTrigger(When trigger) {
        this._when = trigger;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DigitalBooleanLogixAction_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "DigitalBooleanLogixAction_Long", this._when.toString());
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setActionSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum When {
        True(Bundle.getMessage("DigitalBooleanLogixAction_When_True")),
        False(Bundle.getMessage("DigitalBooleanLogixAction_When_False")),
        Either(Bundle.getMessage("DigitalBooleanLogixAction_When_Either"));

        private final String _text;

        private When(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

