/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleStringActionSocket;
import jmri.jmrit.logixng.FemaleStringExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoStringAction
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _stringExpressionSocketSystemName;
    private String _stringActionSocketSystemName;
    private final FemaleStringExpressionSocket _stringExpressionSocket = InstanceManager.getDefault(StringExpressionManager.class).createFemaleSocket(this, this, "E");
    private final FemaleStringActionSocket _stringActionSocket = InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, "A");
    private static final Logger log = LoggerFactory.getLogger(DoStringAction.class);

    public DoStringAction(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        DoStringAction copy = new DoStringAction(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void execute() throws JmriException {
        String result = this._stringExpressionSocket.evaluate();
        this._stringActionSocket.setValue(result);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._stringExpressionSocket;
            }
            case 1: {
                return this._stringActionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._stringExpressionSocket) {
            this._stringExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._stringActionSocket) {
            this._stringActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._stringExpressionSocket) {
            this._stringExpressionSocketSystemName = null;
        } else if (socket == this._stringActionSocket) {
            this._stringActionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "DoStringAction_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "DoStringAction_Long", this._stringExpressionSocket.getName(), this._stringActionSocket.getName());
    }

    public FemaleStringActionSocket getStringActionSocket() {
        return this._stringActionSocket;
    }

    public String getStringActionSocketSystemName() {
        return this._stringActionSocketSystemName;
    }

    public void setStringActionSocketSystemName(String systemName) {
        this._stringActionSocketSystemName = systemName;
    }

    public FemaleStringExpressionSocket getStringExpressionSocket() {
        return this._stringExpressionSocket;
    }

    public String getStringExpressionSocketSystemName() {
        return this._stringExpressionSocketSystemName;
    }

    public void setStringExpressionSocketSystemName(String systemName) {
        this._stringExpressionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._stringExpressionSocket.isConnected() || !this._stringExpressionSocket.getConnectedSocket().getSystemName().equals(this._stringExpressionSocketSystemName)) {
                socketSystemName = this._stringExpressionSocketSystemName;
                this._stringExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(StringExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._stringExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load string expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._stringExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._stringActionSocket.isConnected() || !this._stringActionSocket.getConnectedSocket().getSystemName().equals(this._stringActionSocketSystemName)) {
                socketSystemName = this._stringActionSocketSystemName;
                this._stringActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(StringActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._stringActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load string action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._stringActionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

