/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class EnableLogixNG
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectNamedBean<LogixNG> _selectNamedBean = new LogixNG_SelectNamedBean<LogixNG>(this, LogixNG.class, InstanceManager.getDefault(LogixNG_Manager.class), this);
    private final LogixNG_SelectEnum<Operation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])Operation.values(), (Enum)Operation.Disable, (PropertyChangeListener)this);

    public EnableLogixNG(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        EnableLogixNG copy = new EnableLogixNG(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectNamedBean<LogixNG> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    public LogixNG_SelectEnum<Operation> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        LogixNG logixNG = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (logixNG == null) {
            return;
        }
        Operation operation = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> operation.runTask(logixNG));
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "EnableLogixNG_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String namedBean = this._selectNamedBean.getDescription(locale);
        String state = this._selectEnum.getDescription(locale);
        return Bundle.getMessage(locale, "EnableLogixNG_Long", namedBean, state);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum Operation {
        Enable(Bundle.getMessage("EnableLogixNG_Enable"), lng -> lng.setEnabled(true)),
        Disable(Bundle.getMessage("EnableLogixNG_Disable"), lng -> lng.setEnabled(false)),
        Activate(Bundle.getMessage("EnableLogixNG_Activate"), lng -> lng.setActive(true)),
        Deactivate(Bundle.getMessage("EnableLogixNG_Deactivate"), lng -> lng.setActive(false));

        private final String _text;
        private final LogixNG_Task _task;

        private Operation(String text, LogixNG_Task task) {
            this._text = text;
            this._task = task;
        }

        public void runTask(LogixNG logixNG) {
            this._task.run(logixNG);
        }

        public String toString() {
            return this._text;
        }
    }

    private static interface LogixNG_Task {
        public void run(LogixNG var1);
    }
}

