/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BreakException;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ContinueException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class For
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _initActionSocketSystemName;
    private String _whileExpressionSocketSystemName;
    private String _afterEachActionSocketSystemName;
    private String _doActionSocketSystemName;
    private final FemaleDigitalActionSocket _initActionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("For_SocketName_Init"));
    private final FemaleDigitalExpressionSocket _whileExpressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("For_SocketName_While"));
    private final FemaleDigitalActionSocket _afterEachActionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("For_SocketName_AfterEach"));
    private final FemaleDigitalActionSocket _doActionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("For_SocketName_Do"));
    private static final Logger log = LoggerFactory.getLogger(For.class);

    public For(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        For copy = new For(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    @Override
    public void execute() throws JmriException {
        this._initActionSocket.execute();
        while (this._whileExpressionSocket.evaluate()) {
            try {
                this._doActionSocket.execute();
            }
            catch (BreakException e) {
                break;
            }
            catch (ContinueException continueException) {
                // empty catch block
            }
            this._afterEachActionSocket.execute();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._initActionSocket;
            }
            case 1: {
                return this._whileExpressionSocket;
            }
            case 2: {
                return this._afterEachActionSocket;
            }
            case 3: {
                return this._doActionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 4;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._initActionSocket) {
            this._initActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._whileExpressionSocket) {
            this._whileExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._afterEachActionSocket) {
            this._afterEachActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._doActionSocket) {
            this._doActionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._initActionSocket) {
            this._initActionSocketSystemName = null;
        } else if (socket == this._whileExpressionSocket) {
            this._whileExpressionSocketSystemName = null;
        } else if (socket == this._afterEachActionSocket) {
            this._afterEachActionSocketSystemName = null;
        } else if (socket == this._doActionSocket) {
            this._doActionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "For_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "For_Long", this._initActionSocket.getName(), this._whileExpressionSocket.getName(), this._afterEachActionSocket.getName(), this._doActionSocket.getName());
    }

    public FemaleDigitalActionSocket getInitActionSocket() {
        return this._initActionSocket;
    }

    public String getInitActionSocketSystemName() {
        return this._initActionSocketSystemName;
    }

    public void setInitActionSocketSystemName(String systemName) {
        this._initActionSocketSystemName = systemName;
    }

    public FemaleDigitalExpressionSocket getWhileExpressionSocket() {
        return this._whileExpressionSocket;
    }

    public String getWhileExpressionSocketSystemName() {
        return this._whileExpressionSocketSystemName;
    }

    public void setWhileExpressionSocketSystemName(String systemName) {
        this._whileExpressionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getAfterEachActionSocket() {
        return this._afterEachActionSocket;
    }

    public String getAfterEachExpressionSocketSystemName() {
        return this._afterEachActionSocketSystemName;
    }

    public void setAfterEachActionSocketSystemName(String systemName) {
        this._afterEachActionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getDoActionSocket() {
        return this._doActionSocket;
    }

    public String getDoExpressionSocketSystemName() {
        return this._doActionSocketSystemName;
    }

    public void setDoActionSocketSystemName(String systemName) {
        this._doActionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._initActionSocket.isConnected() || !this._initActionSocket.getConnectedSocket().getSystemName().equals(this._initActionSocketSystemName)) {
                socketSystemName = this._initActionSocketSystemName;
                this._initActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._initActionSocket.disconnect();
                    if (maleSocket != null) {
                        this._initActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._initActionSocket.getConnectedSocket().setup();
            }
            if (!this._whileExpressionSocket.isConnected() || !this._whileExpressionSocket.getConnectedSocket().getSystemName().equals(this._whileExpressionSocketSystemName)) {
                socketSystemName = this._whileExpressionSocketSystemName;
                this._whileExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._whileExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._whileExpressionSocket.getConnectedSocket().setup();
            }
            if (!this._afterEachActionSocket.isConnected() || !this._afterEachActionSocket.getConnectedSocket().getSystemName().equals(this._afterEachActionSocketSystemName)) {
                socketSystemName = this._afterEachActionSocketSystemName;
                this._afterEachActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._afterEachActionSocket.disconnect();
                    if (maleSocket != null) {
                        this._afterEachActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._afterEachActionSocket.getConnectedSocket().setup();
            }
            if (!this._doActionSocket.isConnected() || !this._doActionSocket.getConnectedSocket().getSystemName().equals(this._doActionSocketSystemName)) {
                socketSystemName = this._doActionSocketSystemName;
                this._doActionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._doActionSocket.disconnect();
                    if (maleSocket != null) {
                        this._doActionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._doActionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

