/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BreakException;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.ContinueException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.actions.CommonManager;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForEach
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener {
    private final LogixNG_SelectString _selectVariable = new LogixNG_SelectString(this, this);
    private final LogixNG_SelectNamedBean<Memory> _selectMemoryNamedBean = new LogixNG_SelectNamedBean<Memory>(this, Memory.class, InstanceManager.getDefault(MemoryManager.class), this);
    private boolean _useCommonSource = true;
    private CommonManager _commonManager = CommonManager.Sensors;
    private UserSpecifiedSource _userSpecifiedSource = UserSpecifiedSource.Variable;
    private String _formula = "";
    private ExpressionNode _expressionNode;
    private String _variableName = "";
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
    private static final Logger log = LoggerFactory.getLogger(ForEach.class);

    public ForEach(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ForEach copy = new ForEach(sysName, userName);
        copy.setComment(this.getComment());
        copy.setUseCommonSource(this._useCommonSource);
        copy.setCommonManager(this._commonManager);
        copy.setUserSpecifiedSource(this._userSpecifiedSource);
        this._selectVariable.copy(copy._selectVariable);
        this._selectMemoryNamedBean.copy(copy._selectMemoryNamedBean);
        copy.setFormula(this._formula);
        copy.setLocalVariableName(this._variableName);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectString getSelectVariable() {
        return this._selectVariable;
    }

    public LogixNG_SelectNamedBean<Memory> getSelectMemoryNamedBean() {
        return this._selectMemoryNamedBean;
    }

    public void setUseCommonSource(boolean commonSource) {
        this._useCommonSource = commonSource;
    }

    public boolean isUseCommonSource() {
        return this._useCommonSource;
    }

    public void setCommonManager(CommonManager commonManager) throws ParserException {
        this._commonManager = commonManager;
        this.parseFormula();
    }

    public CommonManager getCommonManager() {
        return this._commonManager;
    }

    public void setUserSpecifiedSource(UserSpecifiedSource userSpecifiedSource) throws ParserException {
        this._userSpecifiedSource = userSpecifiedSource;
        this.parseFormula();
    }

    public UserSpecifiedSource getUserSpecifiedSource() {
        return this._userSpecifiedSource;
    }

    public void setFormula(String formula) throws ParserException {
        this._formula = formula;
        this.parseFormula();
    }

    public String getFormula() {
        return this._formula;
    }

    private void parseFormula() throws ParserException {
        if (this._userSpecifiedSource == UserSpecifiedSource.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._expressionNode = parser.parseExpression(this._formula);
        } else {
            this._expressionNode = null;
        }
    }

    public String getLocalVariableName() {
        return this._variableName;
    }

    public void setLocalVariableName(String localVariableName) {
        this._variableName = localVariableName;
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    @Override
    public void execute() throws JmriException {
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        AtomicReference<SortedSet<? extends NamedBean>> collectionRef = new AtomicReference<SortedSet<? extends NamedBean>>();
        AtomicReference ref = new AtomicReference();
        ConditionalNG conditionalNG = this.getConditionalNG();
        if (this._useCommonSource) {
            collectionRef.set(this._commonManager.getManager().getNamedBeanSet());
        } else {
            ThreadingUtil.runOnLayoutWithJmriException(() -> {
                Object value = null;
                switch (this._userSpecifiedSource) {
                    case Variable: {
                        Object variableValue;
                        String otherLocalVariable = this._selectVariable.evaluateValue(this.getConditionalNG());
                        value = variableValue = conditionalNG.getSymbolTable().getValue(otherLocalVariable);
                        break;
                    }
                    case Memory: {
                        Memory memory = this._selectMemoryNamedBean.evaluateNamedBean(this.getConditionalNG());
                        if (memory != null) {
                            value = memory.getValue();
                            break;
                        }
                        log.warn("ForEach memory is null");
                        break;
                    }
                    case Formula: {
                        if (this._formula.isEmpty() || this._expressionNode == null) break;
                        value = this._expressionNode.calculate(conditionalNG.getSymbolTable());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("_userSpecifiedSource has invalid value: {}" + this._userSpecifiedSource.name());
                    }
                }
                if (value instanceof Manager) {
                    collectionRef.set(((Manager)value).getNamedBeanSet());
                } else if (value != null && value.getClass().isArray()) {
                    collectionRef.set((SortedSet<? extends NamedBean>)((Object)Arrays.asList((Object[])value)));
                } else if (value instanceof Collection) {
                    collectionRef.set((SortedSet<? extends NamedBean>)((Collection)value));
                } else if (value instanceof Map) {
                    collectionRef.set((SortedSet<? extends NamedBean>)((Map)value).entrySet());
                } else {
                    throw new JmriException(Bundle.getMessage("ForEach_InvalidValue", value != null ? value.getClass().getName() : null));
                }
            });
        }
        if (ref.get() != null) {
            throw (JmriException)ref.get();
        }
        for (Object o : (Collection)collectionRef.get()) {
            symbolTable.setValue(this._variableName, o);
            try {
                this._socket.execute();
            }
            catch (BreakException e) {
                break;
            }
            catch (ContinueException continueException) {
            }
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ForEach_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._useCommonSource) {
            return Bundle.getMessage(locale, "ForEach_Long_Common", this._commonManager.toString(), this._variableName, this._socket.getName());
        }
        switch (this._userSpecifiedSource) {
            case Variable: {
                return Bundle.getMessage(locale, "ForEach_Long_LocalVariable", this._selectVariable.getDescription(locale), this._variableName, this._socket.getName());
            }
            case Memory: {
                return Bundle.getMessage(locale, "ForEach_Long_Memory", this._selectMemoryNamedBean.getDescription(locale), this._variableName, this._socket.getName());
            }
            case Formula: {
                return Bundle.getMessage(locale, "ForEach_Long_Formula", this._formula, this._variableName, this._socket.getName());
            }
        }
        throw new IllegalArgumentException("_variableOperation has invalid value: " + this._userSpecifiedSource.name());
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            if (this._userSpecifiedSource == UserSpecifiedSource.Memory) {
                this._selectMemoryNamedBean.registerListeners();
            }
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._userSpecifiedSource == UserSpecifiedSource.Memory) {
                this._selectMemoryNamedBean.unregisterListeners();
            }
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum UserSpecifiedSource {
        Variable(Bundle.getMessage("ForEach_UserSpecifiedSource_Variable")),
        Memory(Bundle.getMessage("ForEach_UserSpecifiedSource_Memory")),
        Formula(Bundle.getMessage("ForEach_UserSpecifiedSource_Formula"));

        private final String _text;

        private UserSpecifiedSource(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

