/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalAction;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfThenElse
extends AbstractDigitalAction
implements FemaleSocketListener {
    private ExecuteType _executeType = ExecuteType.ExecuteOnChange;
    private EvaluateType _evaluateType = EvaluateType.EvaluateAll;
    private final List<ExpressionEntry> _expressionEntries = new ArrayList<ExpressionEntry>();
    private final List<ActionEntry> _actionEntries = new ArrayList<ActionEntry>();
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(IfThenElse.class);

    public IfThenElse(String sys, String user) {
        super(sys, user);
        this._expressionEntries.add(new ExpressionEntry(InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("IfThenElse_Socket_If"))));
        this._actionEntries.add(new ActionEntry(InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("IfThenElse_Socket_Then"))));
        this._actionEntries.add(new ActionEntry(InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("IfThenElse_Socket_Else"))));
    }

    public IfThenElse(String sys, String user, List<Map.Entry<String, String>> expressionSystemNames, List<Map.Entry<String, String>> actionSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this.setExpressionSystemNames(expressionSystemNames);
        this.setActionSystemNames(actionSystemNames);
    }

    public static String getNewSocketName(String propertyName, String[] names) {
        for (int x = 1; x < 10000; ++x) {
            boolean validName = true;
            String name = Bundle.getMessage(propertyName, x);
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                validName = false;
                break;
            }
            if (!validName) continue;
            return name;
        }
        throw new RuntimeException("Unable to find a new socket name");
    }

    public String getNewExpressionSocketName() {
        String[] names = new String[this.getChildCount()];
        for (int i = 0; i < this.getChildCount(); ++i) {
            names[i] = this.getChild(i).getName();
        }
        return IfThenElse.getNewSocketName("IfThenElse_Socket_ElseIf", names);
    }

    public String getNewActionSocketName() {
        String[] names = new String[this.getChildCount()];
        for (int i = 0; i < this.getChildCount(); ++i) {
            names[i] = this.getChild(i).getName();
        }
        return IfThenElse.getNewSocketName("IfThenElse_Socket_Then2", names);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        IfThenElse copy = new IfThenElse(sysName, userName);
        copy.setComment(this.getComment());
        copy.setExecuteType(this._executeType);
        copy.setEvaluateType(this._evaluateType);
        while (copy.getChildCount() < this.getChildCount()) {
            copy.doSocketOperation(copy.getChildCount() - 2, FemaleSocketOperation.InsertAfter);
        }
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setExpressionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._expressionEntries.isEmpty()) {
            throw new RuntimeException("expression system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalExpressionSocket socket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._expressionEntries.add(new ExpressionEntry(socket, entry.getValue()));
        }
    }

    private void setActionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._actionEntries.isEmpty()) {
            throw new RuntimeException("action system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleDigitalActionSocket socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._actionEntries.add(new ActionEntry(socket, entry.getValue()));
        }
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    @Override
    public void execute() throws JmriException {
        boolean changed = false;
        DigitalAction socketToExecute = null;
        for (int i = 0; i < this._expressionEntries.size(); ++i) {
            ExpressionEntry entry = this._expressionEntries.get(i);
            boolean result = entry._socket.evaluate();
            TriState _expressionResult = TriState.getValue(result);
            if (this._executeType != ExecuteType.AlwaysExecute && _expressionResult == entry._lastExpressionResult) continue;
            changed = true;
            entry._lastExpressionResult = _expressionResult;
            if (!result) continue;
            if (socketToExecute == null) {
                socketToExecute = this._actionEntries.get((int)i)._socket;
            }
            if (this._evaluateType == EvaluateType.EvaluateNeeded) break;
        }
        if (changed && socketToExecute == null) {
            socketToExecute = this._actionEntries.get((int)(this._actionEntries.size() - 1))._socket;
        }
        if (socketToExecute != null) {
            socketToExecute.execute();
        } else {
            log.trace("socketToExecute is null");
        }
    }

    public ExecuteType getExecuteType() {
        return this._executeType;
    }

    public void setExecuteType(ExecuteType type) {
        this._executeType = type;
    }

    public EvaluateType getEvaluateType() {
        return this._evaluateType;
    }

    public void setEvaluateType(EvaluateType type) {
        this._evaluateType = type;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index + 1 > this.getChildCount()) {
            throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
        }
        if (index + 1 == this.getChildCount()) {
            return this._actionEntries.get((int)(this._actionEntries.size() - 1))._socket;
        }
        if (index % 2 == 0) {
            return this._expressionEntries.get((int)(index >> 1))._socket;
        }
        return this._actionEntries.get((int)(index >> 1))._socket;
    }

    @Override
    public int getChildCount() {
        return this._expressionEntries.size() + this._actionEntries.size();
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        int numChilds = this.getChildCount();
        switch (oper) {
            case Remove: {
                return index >= 0 && index + 2 < numChilds && numChilds > 4 && !this.getChild(index).isConnected() && !this.getChild(index + 1).isConnected();
            }
            case InsertBefore: {
                return index >= 0;
            }
            case InsertAfter: {
                return index < numChilds - 1;
            }
            case MoveUp: {
                return index >= 2 && index < numChilds - 2;
            }
            case MoveDown: {
                return index >= 0 && index < numChilds - 4;
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        int expressionIndex = index >> 1;
        int actionIndex = index >> 1;
        if (index % 2 != 0) {
            actionIndex = index >> 1;
            expressionIndex = (index >> 1) + 1;
        }
        FemaleDigitalExpressionSocket exprSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, this.getNewExpressionSocketName());
        FemaleDigitalActionSocket actionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, this.getNewActionSocketName());
        this._expressionEntries.add(expressionIndex, new ExpressionEntry(exprSocket));
        this._actionEntries.add(actionIndex, new ActionEntry(actionSocket));
        ArrayList<FemaleSocket> addList = new ArrayList<FemaleSocket>();
        addList.add(actionSocket);
        addList.add(exprSocket);
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        int actionIndex = index >> 1;
        int expressionIndex = index >> 1;
        if (index % 2 != 0) {
            expressionIndex = (index >> 1) + 1;
        }
        ArrayList<FemaleSocket> removeList = new ArrayList<FemaleSocket>();
        removeList.add(this._actionEntries.remove((int)actionIndex)._socket);
        removeList.add(this._expressionEntries.remove((int)expressionIndex)._socket);
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        int actionIndex = index >> 1;
        int expressionIndex = index >> 1;
        if (index % 2 != 0) {
            expressionIndex = (index >> 1) + 1;
        }
        ActionEntry actionTemp = this._actionEntries.get(actionIndex);
        this._actionEntries.set(actionIndex, this._actionEntries.get(actionIndex + 1));
        this._actionEntries.set(actionIndex + 1, actionTemp);
        ExpressionEntry exprTemp = this._expressionEntries.get(expressionIndex);
        this._expressionEntries.set(expressionIndex, this._expressionEntries.get(expressionIndex + 1));
        this._expressionEntries.set(expressionIndex + 1, exprTemp);
        ArrayList<FemaleSocket> list = new ArrayList<FemaleSocket>();
        list.add(this._actionEntries.get((int)actionIndex)._socket);
        list.add(this._actionEntries.get((int)(actionIndex + 1))._socket);
        list.add(this._expressionEntries.get((int)expressionIndex)._socket);
        list.add(this._expressionEntries.get((int)(expressionIndex + 1))._socket);
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (index + 1 >= this.getChildCount()) {
                    throw new UnsupportedOperationException("Cannot remove only the last socket");
                }
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                if (this.getChild(index + 1).isConnected()) {
                    throw new UnsupportedOperationException("Socket below is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index < 0) {
                    throw new UnsupportedOperationException("cannot move up static sockets");
                }
                if (index <= 1) {
                    throw new UnsupportedOperationException("cannot move up first two children");
                }
                this.moveSocketDown(index - 2);
                break;
            }
            case MoveDown: {
                if (index + 2 >= this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last two children");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        for (ExpressionEntry expressionEntry : this._expressionEntries) {
            if (socket != expressionEntry._socket) continue;
            expressionEntry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
        for (ActionEntry actionEntry : this._actionEntries) {
            if (socket != actionEntry._socket) continue;
            actionEntry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        for (ExpressionEntry expressionEntry : this._expressionEntries) {
            if (socket != expressionEntry._socket) continue;
            expressionEntry._socketSystemName = null;
        }
        for (ActionEntry actionEntry : this._actionEntries) {
            if (socket != actionEntry._socket) continue;
            actionEntry._socketSystemName = null;
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "IfThenElse_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "IfThenElse_Long", this._executeType.toString());
    }

    public int getNumExpressions() {
        return this._expressionEntries.size();
    }

    public FemaleDigitalExpressionSocket getExpressionSocket(int socket) {
        return this._expressionEntries.get((int)socket)._socket;
    }

    public String getExpressionSocketSystemName(int socket) {
        return this._expressionEntries.get((int)socket)._socketSystemName;
    }

    public void setExpressionSocketSystemName(int socket, String systemName) {
        this._expressionEntries.get((int)socket)._socketSystemName = systemName;
    }

    public int getNumActions() {
        return this._actionEntries.size();
    }

    public FemaleDigitalActionSocket getActionSocket(int socket) {
        return this._actionEntries.get((int)socket)._socket;
    }

    public String getActionSocketSystemName(int socket) {
        return this._actionEntries.get((int)socket)._socketSystemName;
    }

    public void setActionSocketSystemName(int socket, String systemName) {
        this._actionEntries.get((int)socket)._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            for (ExpressionEntry ee : this._expressionEntries) {
                if (!ee._socket.isConnected() || !ee._socket.getConnectedSocket().getSystemName().equals(ee._socketSystemName)) {
                    socketSystemName = ee._socketSystemName;
                    ee._socket.disconnect();
                    if (socketSystemName == null) continue;
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    ee._socket.disconnect();
                    if (maleSocket != null) {
                        ee._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital expression {}", (Object)socketSystemName);
                    continue;
                }
                ee._socket.getConnectedSocket().setup();
            }
            for (ActionEntry ae : this._actionEntries) {
                if (!ae._socket.isConnected() || !ae._socket.getConnectedSocket().getSystemName().equals(ae._socketSystemName)) {
                    socketSystemName = ae._socketSystemName;
                    ae._socket.disconnect();
                    if (socketSystemName == null) continue;
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    ae._socket.disconnect();
                    if (maleSocket != null) {
                        ae._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load digital action {}", (Object)socketSystemName);
                    continue;
                }
                ae._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
        this.disableCheckForUnconnectedSocket = false;
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    private static class ActionEntry {
        private String _socketSystemName;
        private final FemaleDigitalActionSocket _socket;

        private ActionEntry(FemaleDigitalActionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ActionEntry(FemaleDigitalActionSocket socket) {
            this._socket = socket;
        }
    }

    private static class ExpressionEntry {
        private String _socketSystemName;
        private final FemaleDigitalExpressionSocket _socket;
        private TriState _lastExpressionResult = TriState.Unknown;

        private ExpressionEntry(FemaleDigitalExpressionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ExpressionEntry(FemaleDigitalExpressionSocket socket) {
            this._socket = socket;
        }
    }

    private static enum TriState {
        Unknown,
        False,
        True;


        public static TriState getValue(boolean value) {
            return value ? True : False;
        }
    }

    public static enum EvaluateType {
        EvaluateAll(Bundle.getMessage("IfThenElse_EvaluateType_EvaluateAll")),
        EvaluateNeeded(Bundle.getMessage("IfThenElse_EvaluateType_EvaluateNeeded"));

        private final String _text;

        private EvaluateType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum ExecuteType {
        ExecuteOnChange(Bundle.getMessage("IfThenElse_ExecuteType_ExecuteOnChange")),
        AlwaysExecute(Bundle.getMessage("IfThenElse_ExecuteType_AlwaysExecute"));

        private final String _text;

        private ExecuteType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

