/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDecode
extends AbstractDigitalAction
implements PropertyChangeListener {
    private String _jsonLocalVariable;
    private String _resultLocalVariable;
    private static final Logger log = LoggerFactory.getLogger(JsonDecode.class);

    public JsonDecode(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        JsonDecode copy = new JsonDecode(sysName, userName);
        copy.setComment(this.getComment());
        copy.setJsonLocalVariable(this._jsonLocalVariable);
        copy.setResultLocalVariable(this._resultLocalVariable);
        return manager.registerAction(copy);
    }

    public void setJsonLocalVariable(String variableName) {
        this.assertListenersAreNotRegistered(log, "setJsonLocalVariable");
        this._jsonLocalVariable = variableName;
    }

    public String getJsonLocalVariable() {
        return this._jsonLocalVariable;
    }

    public void setResultLocalVariable(String variableName) {
        this.assertListenersAreNotRegistered(log, "setResultLocalVariable");
        this._resultLocalVariable = variableName;
    }

    public String getResultLocalVariable() {
        return this._resultLocalVariable;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() throws JmriException {
        if (this._jsonLocalVariable == null) {
            return;
        }
        if (this._resultLocalVariable == null) {
            return;
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        SymbolTable symbolTable = conditionalNG.getSymbolTable();
        String json = TypeConversionUtil.convertToString(symbolTable.getValue(this._jsonLocalVariable), false);
        ObjectMapper om = new ObjectMapper();
        try {
            JsonNode jsonNode = om.readTree(json);
            symbolTable.setValue(this._resultLocalVariable, jsonNode);
        }
        catch (JsonProcessingException ex) {
            throw new JmriException(ex);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "JsonDecode_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "JsonDecode_Long", this._jsonLocalVariable, this._resultLocalVariable);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }
}

