/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.GlobalVariable;
import jmri.jmrit.logixng.GlobalVariableManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLocalVariables
extends AbstractDigitalAction {
    private boolean _includeGlobalVariables = true;
    private boolean _expandArraysAndMaps = false;
    private boolean _showClassName = false;
    private static final Logger log = LoggerFactory.getLogger(LogLocalVariables.class);

    public LogLocalVariables(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        LogLocalVariables copy = new LogLocalVariables(sysName, userName);
        copy.setComment(this.getComment());
        copy._includeGlobalVariables = this._includeGlobalVariables;
        copy._expandArraysAndMaps = this._expandArraysAndMaps;
        copy._showClassName = this._showClassName;
        return manager.registerAction(copy);
    }

    public void setIncludeGlobalVariables(boolean value) {
        this._includeGlobalVariables = value;
    }

    public boolean isIncludeGlobalVariables() {
        return this._includeGlobalVariables;
    }

    public void setExpandArraysAndMaps(boolean value) {
        this._expandArraysAndMaps = value;
    }

    public boolean isExpandArraysAndMaps() {
        return this._expandArraysAndMaps;
    }

    public void setShowClassName(boolean value) {
        this._showClassName = value;
    }

    public boolean isShowClassName() {
        return this._showClassName;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N in Warning strings.")
    public void execute() {
        ConditionalNG c = this.getConditionalNG();
        log.warn(Bundle.getMessage("LogLocalVariables_Start"));
        for (SymbolTable.Symbol s : c.getSymbolTable().getSymbols().values()) {
            SymbolTable.printVariable(log, "    ", s.getName(), c.getSymbolTable().getValue(s.getName()), this._expandArraysAndMaps, this._showClassName, Bundle.getMessage("LogLocalVariables_VariableName"), Bundle.getMessage("LogLocalVariables_VariableValue"));
        }
        if (this._includeGlobalVariables) {
            log.warn(Bundle.getMessage("LogLocalVariables_GlobalVariables_Start"));
            for (GlobalVariable gv : InstanceManager.getDefault(GlobalVariableManager.class).getNamedBeanSet()) {
                SymbolTable.printVariable(log, "    ", gv.getUserName(), gv.getValue(), this._expandArraysAndMaps, this._showClassName, Bundle.getMessage("LogLocalVariables_GlobalVariableName"), Bundle.getMessage("LogLocalVariables_GlobalVariableValue"));
            }
        }
        log.warn(Bundle.getMessage("LogLocalVariables_End"));
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "LogLocalVariables_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "LogLocalVariables_Long");
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

