/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalBooleanActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalBooleanActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logix
extends AbstractDigitalAction
implements FemaleSocketListener {
    private ExecuteType _executeType = ExecuteType.ExecuteOnChange;
    private boolean _lastExpressionResult = false;
    private String _expressionSocketSystemName;
    private String _actionSocketSystemName;
    private final FemaleDigitalExpressionSocket _expressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "E");
    private final FemaleDigitalBooleanActionSocket _actionSocket = InstanceManager.getDefault(DigitalBooleanActionManager.class).createFemaleSocket(this, this, "A");
    private static final Logger log = LoggerFactory.getLogger(Logix.class);

    public Logix(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Logix copy = new Logix(sysName, userName);
        copy.setComment(this.getComment());
        copy.setExecuteType(this._executeType);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    public ExecuteType getExecuteType() {
        return this._executeType;
    }

    public void setExecuteType(ExecuteType type) {
        this._executeType = type;
    }

    @Override
    public void execute() throws JmriException {
        boolean result = this._expressionSocket.evaluate();
        if (this._executeType == ExecuteType.ExecuteAlways || result != this._lastExpressionResult) {
            this._actionSocket.execute(result);
        }
        this._lastExpressionResult = result;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._expressionSocket;
            }
            case 1: {
                return this._actionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = null;
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Logix_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Logix_Long", this._executeType.toString());
    }

    public FemaleDigitalExpressionSocket getExpressionSocket() {
        return this._expressionSocket;
    }

    public String getExpressionSocketSystemName() {
        return this._expressionSocketSystemName;
    }

    public void setExpressionSocketSystemName(String systemName) {
        this._expressionSocketSystemName = systemName;
    }

    public FemaleDigitalBooleanActionSocket getActionSocket() {
        return this._actionSocket;
    }

    public String getActionSocketSystemName() {
        return this._actionSocketSystemName;
    }

    public void setActionSocketSystemName(String systemName) {
        this._actionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._expressionSocket.isConnected() || !this._expressionSocket.getConnectedSocket().getSystemName().equals(this._expressionSocketSystemName)) {
                socketSystemName = this._expressionSocketSystemName;
                this._expressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._expressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._expressionSocket.getConnectedSocket().setup();
            }
            if (!this._actionSocket.isConnected() || !this._actionSocket.getConnectedSocket().getSystemName().equals(this._actionSocketSystemName)) {
                socketSystemName = this._actionSocketSystemName;
                this._actionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalBooleanActionManager.class).getBySystemName(socketSystemName);
                    this._actionSocket.disconnect();
                    if (maleSocket != null) {
                        this._actionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital boolean action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._actionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    public static enum ExecuteType {
        ExecuteOnChange(Bundle.getMessage("Logix_ExecuteOnChange")),
        ExecuteAlways(Bundle.getMessage("Logix_ExecuteAlways"));

        private final String _text;

        private ExecuteType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

