/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.LogixNG_SelectComboBox;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramOnMain
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener {
    private static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.implementation.ImplementationBundle");
    private String _executeSocketSystemName;
    private final FemaleDigitalActionSocket _executeSocket;
    private SystemConnectionMemo _memo;
    private AddressedProgrammerManager _programmerManager;
    private ThrottleManager _throttleManager;
    private final LogixNG_SelectComboBox _selectProgrammingMode;
    private final LogixNG_SelectEnum<LongOrShortAddress> _selectLongOrShortAddress = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])LongOrShortAddress.values(), (Enum)LongOrShortAddress.Auto, (PropertyChangeListener)this);
    private final LogixNG_SelectInteger _selectAddress = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectInteger _selectCV = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectInteger _selectValue = new LogixNG_SelectInteger(this, this);
    private String _localVariableForStatus = "";
    private boolean _wait = true;
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private static final Logger log = LoggerFactory.getLogger(ProgramOnMain.class);

    public ProgramOnMain(String sys, String user) {
        super(sys, user);
        String[] modes = new String[]{""};
        this._selectProgrammingMode = new LogixNG_SelectComboBox(this, modes, modes[0], this);
        this.setMemo(null);
        this._executeSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ProgramOnMain_Socket"));
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ProgramOnMain copy = new ProgramOnMain(sysName, userName);
        copy.setComment(this.getComment());
        copy.setMemo(this._memo);
        this._selectProgrammingMode.copy(copy._selectProgrammingMode);
        this._selectLongOrShortAddress.copy(copy._selectLongOrShortAddress);
        this._selectAddress.copy(copy._selectAddress);
        this._selectCV.copy(copy._selectCV);
        this._selectValue.copy(copy._selectValue);
        copy._wait = this._wait;
        copy.setLocalVariableForStatus(this._localVariableForStatus);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public final LogixNG_SelectComboBox getSelectProgrammingMode() {
        return this._selectProgrammingMode;
    }

    public final LogixNG_SelectInteger getSelectAddress() {
        return this._selectAddress;
    }

    public LogixNG_SelectEnum<LongOrShortAddress> getSelectLongOrShortAddress() {
        return this._selectLongOrShortAddress;
    }

    public final LogixNG_SelectInteger getSelectCV() {
        return this._selectCV;
    }

    public final LogixNG_SelectInteger getSelectValue() {
        return this._selectValue;
    }

    public void setLocalVariableForStatus(String localVariable) {
        this._localVariableForStatus = localVariable;
    }

    public String getLocalVariableForStatus() {
        return this._localVariableForStatus;
    }

    public void setWait(boolean wait) {
        this._wait = wait;
    }

    public boolean getWait() {
        return this._wait;
    }

    public final void setMemo(SystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
        if (this._memo != null) {
            this._programmerManager = this._memo.get(AddressedProgrammerManager.class);
            this._throttleManager = this._memo.get(ThrottleManager.class);
            if (this._throttleManager == null) {
                throw new IllegalArgumentException("Memo " + memo.getUserName() + " doesn't have a ThrottleManager");
            }
            if (this._programmerManager == null) {
                this._programmerManager = InstanceManager.getDefault(AddressedProgrammerManager.class);
            }
        } else {
            this._programmerManager = InstanceManager.getDefault(AddressedProgrammerManager.class);
            this._throttleManager = InstanceManager.getDefault(ThrottleManager.class);
        }
        ArrayList<String> modeList = new ArrayList<String>();
        for (ProgrammingMode mode : this._programmerManager.getDefaultModes()) {
            log.debug("Available programming mode: {}", (Object)mode);
            modeList.add(mode.getStandardName());
        }
        if (modeList.isEmpty()) {
            modeList.add(ProgrammingMode.OPSBYTEMODE.getStandardName());
        }
        String[] modes = (String[])modeList.toArray(String[]::new);
        this._selectProgrammingMode.setValues(modes);
    }

    public final SystemConnectionMemo getMemo() {
        return this._memo;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    private void doProgrammingOnMain(ConditionalNG conditionalNG, DefaultSymbolTable newSymbolTable, ProgrammingMode progMode, int address, LongOrShortAddress longOrShort, int cv, int value, boolean wait) throws JmriException {
        block12: {
            try {
                boolean longAddress;
                switch (longOrShort) {
                    case Short: {
                        longAddress = false;
                        break;
                    }
                    case Long: {
                        longAddress = true;
                        break;
                    }
                    case Auto: {
                        longAddress = !this._throttleManager.canBeShortAddress(address);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("longOrShort has unknown value");
                    }
                }
                AddressedProgrammer programmer = this._programmerManager.getAddressedProgrammer(new DccLocoAddress(address, longAddress));
                if (programmer != null) {
                    programmer.setMode(progMode);
                    if (!progMode.equals(programmer.getMode())) {
                        throw new IllegalArgumentException("The addressed programmer doesn't support mode " + progMode.getStandardName());
                    }
                    AtomicInteger result = new AtomicInteger(-1);
                    programmer.writeCV("" + cv, value, (value1, status) -> {
                        result.set(status);
                        log.debug("Result of programming cv {} to value {} for address {}: {}", new Object[]{cv, value, address, status});
                        ProgramOnMain programOnMain = this;
                        synchronized (programOnMain) {
                            this._internalSocket.conditionalNG = conditionalNG;
                            this._internalSocket.newSymbolTable = newSymbolTable;
                            this._internalSocket.status = status;
                            conditionalNG.execute(this._internalSocket);
                        }
                    });
                    if (!wait) break block12;
                    try {
                        while (result.get() == -1) {
                            Thread.sleep(10L);
                        }
                        break block12;
                    }
                    catch (InterruptedException e) {
                        log.warn("Waiting for programmer to complete was aborted");
                        break block12;
                    }
                }
                throw new IllegalArgumentException("An addressed programmer isn't available for address " + address);
            }
            catch (ProgrammerException e) {
                throw new JmriException(e);
            }
        }
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG.getSymbolTable());
        String progModeStr = this._selectProgrammingMode.evaluateValue(conditionalNG);
        ProgrammingMode progMode = new ProgrammingMode(progModeStr);
        int address = this._selectAddress.evaluateValue(conditionalNG);
        LongOrShortAddress longOrShort = this._selectLongOrShortAddress.evaluateEnum(conditionalNG);
        int cv = this._selectCV.evaluateValue(conditionalNG);
        int value = this._selectValue.evaluateValue(conditionalNG);
        this.doProgrammingOnMain(conditionalNG, newSymbolTable, progMode, address, longOrShort, cv, value, this._wait);
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._executeSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._executeSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._executeSocketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._executeSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._executeSocketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ProgramOnMain_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        if (this._memo != null) {
            return Bundle.getMessage(locale, "ProgramOnMain_LongConnection", this._selectLongOrShortAddress.getDescription(locale), this._selectAddress.getDescription(locale, false), this._selectCV.getDescription(locale, false), this._selectValue.getDescription(locale, false), this._selectProgrammingMode.getDescription(locale), this._memo.getUserName());
        }
        return Bundle.getMessage(locale, "ProgramOnMain_Long", this._selectLongOrShortAddress.getDescription(locale), this._selectAddress.getDescription(locale, false), this._selectCV.getDescription(locale, false), this._selectValue.getDescription(locale, false), this._selectProgrammingMode.getDescription(locale));
    }

    public FemaleDigitalActionSocket getExecuteSocket() {
        return this._executeSocket;
    }

    public String getExecuteSocketSystemName() {
        return this._executeSocketSystemName;
    }

    public void setExecuteSocketSystemName(String systemName) {
        this._executeSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._executeSocket.isConnected() || !this._executeSocket.getConnectedSocket().getSystemName().equals(this._executeSocketSystemName)) {
                String socketSystemName = this._executeSocketSystemName;
                this._executeSocket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._executeSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._executeSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum LongOrShortAddress {
        Short(Bundle.getMessage("ProgramOnMain_LongOrShortAddress_Short")),
        Long(Bundle.getMessage("ProgramOnMain_LongOrShortAddress_Long")),
        Auto(Bundle.getMessage("ProgramOnMain_LongOrShortAddress_Auto"));

        private final String _text;

        private LongOrShortAddress(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;
        private int status;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (ProgramOnMain.this._executeSocket != null) {
                MaleSocket maleSocket = (MaleSocket)ProgramOnMain.this.getParent();
                try {
                    SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                    this.conditionalNG.setSymbolTable(this.newSymbolTable);
                    if (!ProgramOnMain.this._localVariableForStatus.isEmpty()) {
                        this.newSymbolTable.setValue(ProgramOnMain.this._localVariableForStatus, this.status);
                    }
                    ProgramOnMain.this._executeSocket.execute();
                    this.conditionalNG.setSymbolTable(oldSymbolTable);
                }
                catch (JmriException e) {
                    if (e.getErrors() != null) {
                        maleSocket.handleError(ProgramOnMain.this, rbx.getString("ExceptionExecuteMulti"), e.getErrors(), e, log);
                    } else {
                        maleSocket.handleError((Base)ProgramOnMain.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                    }
                }
                catch (RuntimeException e) {
                    maleSocket.handleError((Base)ProgramOnMain.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                }
            }
        }
    }
}

