/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunOnce
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket;
    private boolean _hasExecuted = false;
    private static final Logger log = LoggerFactory.getLogger(RunOnce.class);

    public RunOnce(String sys, String user) {
        super(sys, user);
        this._socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("RunOnce_Socket_Action"));
    }

    public RunOnce(String sys, String user, String socketName, String socketSystemName) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, socketName);
        this._socketSystemName = socketSystemName;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        RunOnce copy = new RunOnce(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    @Override
    public void execute() throws JmriException {
        if (!this._hasExecuted && this._socket != null) {
            this._socket.execute();
        }
        this._hasExecuted = true;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        if (index == 0) {
            return this._socket;
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._socket) {
            this._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._socket) {
            this._socketSystemName = null;
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "RunOnce_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "RunOnce_Long");
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }
}

