/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.ThreadingUtil;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDialog
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener,
VetoableChangeListener {
    private static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.implementation.ImplementationBundle");
    private String _validateSocketSystemName;
    private final FemaleDigitalExpressionSocket _validateSocket;
    private String _executeSocketSystemName;
    private final FemaleDigitalActionSocket _executeSocket;
    private Set<Button> _enabledButtons = new HashSet<Button>();
    private String _localVariableForSelectedButton = "";
    private String _localVariableForInputString = "";
    private boolean _modal = true;
    private boolean _multiLine = false;
    private FormatType _formatType = FormatType.OnlyText;
    private String _format = "";
    private final List<Data> _dataList = new ArrayList<Data>();
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private JDialog _dialog;
    private static final Logger log = LoggerFactory.getLogger(ShowDialog.class);

    public ShowDialog(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._validateSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ShowDialog_SocketValidate"));
        this._executeSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ShowDialog_SocketExecute"));
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException, JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ShowDialog copy = new ShowDialog(sysName, userName);
        copy.setComment(this.getComment());
        for (Button button : this._enabledButtons) {
            copy.getEnabledButtons().add(button);
        }
        copy.setLocalVariableForSelectedButton(this._localVariableForSelectedButton);
        copy.setLocalVariableForInputString(this._localVariableForInputString);
        copy.setModal(this._modal);
        copy.setMultiLine(this._multiLine);
        copy.setFormat(this._format);
        copy.setFormatType(this._formatType);
        for (Data data : this._dataList) {
            copy.getDataList().add(new Data(data));
        }
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public Set<Button> getEnabledButtons() {
        return this._enabledButtons;
    }

    public void setModal(boolean modal) {
        this._modal = modal;
    }

    public boolean getModal() {
        return this._modal;
    }

    public void setMultiLine(boolean multiLine) {
        this._multiLine = multiLine;
    }

    public boolean getMultiLine() {
        return this._multiLine;
    }

    public void setLocalVariableForSelectedButton(String localVariable) {
        this._localVariableForSelectedButton = localVariable;
    }

    public String getLocalVariableForSelectedButton() {
        return this._localVariableForSelectedButton;
    }

    public void setLocalVariableForInputString(String localVariableForInputString) {
        this._localVariableForInputString = localVariableForInputString;
    }

    public String getLocalVariableForInputString() {
        return this._localVariableForInputString;
    }

    public void setFormatType(FormatType formatType) {
        this._formatType = formatType;
    }

    public FormatType getFormatType() {
        return this._formatType;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public List<Data> getDataList() {
        return this._dataList;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private List<Object> getDataValues() throws JmriException {
        ArrayList<Object> values = new ArrayList<Object>();
        block6: for (Data _data : this._dataList) {
            switch (_data._dataType) {
                case LocalVariable: {
                    values.add(this.getConditionalNG().getSymbolTable().getValue(_data._data));
                    continue block6;
                }
                case Memory: {
                    MemoryManager memoryManager = InstanceManager.getDefault(MemoryManager.class);
                    Memory memory = memoryManager.getMemory(_data._data);
                    if (memory == null) {
                        throw new IllegalArgumentException("Memory '" + _data._data + "' not found");
                    }
                    values.add(memory.getValue());
                    continue block6;
                }
                case Reference: {
                    values.add(ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), _data._data));
                    continue block6;
                }
                case Formula: {
                    if (_data._expressionNode == null) continue block6;
                    values.add(_data._expressionNode.calculate(this.getConditionalNG().getSymbolTable()));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("_formatType has invalid value: " + this._formatType.name());
        }
        return values;
    }

    @Override
    public void execute() throws JmriException {
        Object value2;
        String str;
        switch (this._formatType) {
            case OnlyText: {
                str = this._format;
                break;
            }
            case CommaSeparatedList: {
                StringBuilder sb = new StringBuilder();
                for (Object value2 : this.getDataValues()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(value2 != null ? value2.toString() : "null");
                }
                str = sb.toString();
                break;
            }
            case StringFormat: {
                str = String.format(this._format, this.getDataValues().toArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("_formatType has invalid value: " + this._formatType.name());
            }
        }
        ConditionalNG conditionalNG = this.getConditionalNG();
        DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG.getSymbolTable());
        Object strMultiLine = this._multiLine ? "<html>" + str + "</html>" : str;
        value2 = null;
        if (!this._localVariableForInputString.isEmpty()) {
            value2 = newSymbolTable.getValue(this._localVariableForInputString);
        }
        Object currentValue = value2;
        ThreadingUtil.runOnGUIEventually(() -> this.lambda$execute$1((String)strMultiLine, currentValue, conditionalNG, newSymbolTable));
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._validateSocket;
            }
            case 1: {
                return this._executeSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._validateSocket) {
            this._validateSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._executeSocket) {
            this._executeSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._validateSocket) {
            this._validateSocketSystemName = null;
        } else if (socket == this._executeSocket) {
            this._executeSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ShowDialog_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String bundleKey;
        switch (this._formatType) {
            case OnlyText: {
                bundleKey = "ShowDialog_Long_TextOnly";
                break;
            }
            case CommaSeparatedList: {
                bundleKey = "ShowDialog_Long_CommaSeparatedList";
                break;
            }
            case StringFormat: {
                bundleKey = "ShowDialog_Long_StringFormat";
                break;
            }
            default: {
                throw new RuntimeException("_formatType has unknown value: " + this._formatType.name());
            }
        }
        return Bundle.getMessage(locale, bundleKey, this._format);
    }

    public FemaleDigitalExpressionSocket getValidateSocket() {
        return this._validateSocket;
    }

    public String getValidateSocketSystemName() {
        return this._validateSocketSystemName;
    }

    public void setValidateSocketSystemName(String systemName) {
        this._validateSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getExecuteSocket() {
        return this._executeSocket;
    }

    public String getExecuteSocketSystemName() {
        return this._executeSocketSystemName;
    }

    public void setExecuteSocketSystemName(String systemName) {
        this._executeSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._validateSocket.isConnected() || !this._validateSocket.getConnectedSocket().getSystemName().equals(this._validateSocketSystemName)) {
                socketSystemName = this._validateSocketSystemName;
                this._validateSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._validateSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._validateSocket.getConnectedSocket().setup();
            }
            if (!this._executeSocket.isConnected() || !this._executeSocket.getConnectedSocket().getSystemName().equals(this._executeSocketSystemName)) {
                socketSystemName = this._executeSocketSystemName;
                this._executeSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._executeSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._executeSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    private /* synthetic */ void lambda$execute$1(String strMultiLine, Object currentValue, ConditionalNG conditionalNG, DefaultSymbolTable newSymbolTable) {
        if (this._dialog != null) {
            this._dialog.dispose();
        }
        this._dialog = new JDialog((Frame)null, Bundle.getMessage("ShowDialog_Title"), this._modal);
        this._dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowDialog.this._dialog = null;
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._dialog.getContentPane().add(panel);
        panel.add(new JLabel(strMultiLine));
        JTextField textField = new JTextField(20);
        if (!this._localVariableForInputString.isEmpty()) {
            if (currentValue != null) {
                String strValue = TypeConversionUtil.convertToString(currentValue, false);
                textField.setText(strValue);
            }
            panel.add((Component)textField, "North");
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        for (Button button : Button.values()) {
            if (!this._enabledButtons.contains((Object)button)) continue;
            JButton jbutton = new JButton(button._text);
            jbutton.addActionListener(e -> {
                ShowDialog showDialog = this;
                synchronized (showDialog) {
                    this._internalSocket.conditionalNG = conditionalNG;
                    this._internalSocket.newSymbolTable = newSymbolTable;
                    this._internalSocket.selectedButton = button._value;
                    this._internalSocket.inputValue = textField.getText();
                    conditionalNG.execute(this._internalSocket);
                }
            });
            buttonPanel.add(jbutton);
        }
        panel.add((Component)buttonPanel, "South");
        this._dialog.pack();
        this._dialog.setLocationRelativeTo(null);
        this._dialog.setVisible(true);
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;
        private int selectedButton;
        private String inputValue;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (ShowDialog.this._executeSocket != null) {
                MaleSocket maleSocket = (MaleSocket)ShowDialog.this.getParent();
                try {
                    SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                    this.conditionalNG.setSymbolTable(this.newSymbolTable);
                    if (!ShowDialog.this._localVariableForSelectedButton.isEmpty()) {
                        this.newSymbolTable.setValue(ShowDialog.this._localVariableForSelectedButton, this.selectedButton);
                    }
                    if (!ShowDialog.this._localVariableForInputString.isEmpty()) {
                        this.newSymbolTable.setValue(ShowDialog.this._localVariableForInputString, this.inputValue);
                    }
                    boolean result = true;
                    if (ShowDialog.this._validateSocket.isConnected()) {
                        result = ShowDialog.this._validateSocket.evaluate();
                    }
                    if (result) {
                        ShowDialog.this._dialog.dispose();
                        ShowDialog.this._executeSocket.execute();
                    }
                    this.conditionalNG.setSymbolTable(oldSymbolTable);
                }
                catch (JmriException e) {
                    if (e.getErrors() != null) {
                        maleSocket.handleError(ShowDialog.this, rbx.getString("ExceptionExecuteMulti"), e.getErrors(), e, log);
                    } else {
                        maleSocket.handleError((Base)ShowDialog.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                    }
                }
                catch (RuntimeException e) {
                    maleSocket.handleError((Base)ShowDialog.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                }
            }
        }
    }

    public static class Data {
        private DataType _dataType = DataType.LocalVariable;
        private String _data = "";
        private ExpressionNode _expressionNode;

        public Data(Data data) throws ParserException {
            this._dataType = data._dataType;
            this._data = data._data;
            this.calculateFormula();
        }

        public Data(DataType dataType, String data) throws ParserException {
            if (dataType != null) {
                this._dataType = dataType;
            } else {
                log.warn("dataType is null");
            }
            this._data = data;
            this.calculateFormula();
        }

        private void calculateFormula() throws ParserException {
            if (this._dataType == DataType.Formula) {
                HashMap<String, Variable> variables = new HashMap<String, Variable>();
                RecursiveDescentParser parser = new RecursiveDescentParser(variables);
                this._expressionNode = parser.parseExpression(this._data);
            } else {
                this._expressionNode = null;
            }
        }

        public void setDataType(DataType dataType) {
            if (dataType != null) {
                this._dataType = dataType;
            } else {
                log.warn("dataType is null");
            }
        }

        public DataType getDataType() {
            return this._dataType;
        }

        public void setData(String data) {
            this._data = data;
        }

        public String getData() {
            return this._data;
        }
    }

    public static enum DataType {
        LocalVariable(Bundle.getMessage("ShowDialog_Operation_LocalVariable")),
        Memory(Bundle.getMessage("ShowDialog_Operation_Memory")),
        Reference(Bundle.getMessage("ShowDialog_Operation_Reference")),
        Formula(Bundle.getMessage("ShowDialog_Operation_Formula"));

        private final String _text;

        private DataType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum Button {
        Ok(1, Bundle.getMessage("ButtonOK")),
        Cancel(2, Bundle.getMessage("ButtonCancel")),
        Yes(3, Bundle.getMessage("ButtonYes")),
        No(4, Bundle.getMessage("ButtonNo"));

        private final int _value;
        private final String _text;

        private Button(int value, String text) {
            this._value = value;
            this._text = text;
        }

        public int getValue() {
            return this._value;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum FormatType {
        OnlyText(Bundle.getMessage("ShowDialog_FormatType_TextOnly"), true, false),
        CommaSeparatedList(Bundle.getMessage("ShowDialog_FormatType_CommaSeparatedList"), false, true),
        StringFormat(Bundle.getMessage("ShowDialog_FormatType_StringFormat"), true, true);

        private final String _text;
        private final boolean _useFormat;
        private final boolean _useData;

        private FormatType(String text, boolean useFormat, boolean useData) {
            this._text = text;
            this._useFormat = useFormat;
            this._useData = useData;
        }

        public String toString() {
            return this._text;
        }

        public boolean getUseFormat() {
            return this._useFormat;
        }

        public boolean getUseData() {
            return this._useData;
        }
    }
}

