/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.ShutDownManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;

public class ShutdownComputer
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectEnum<Operation> _selectEnum = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])Operation.values(), (Enum)Operation.ShutdownJMRI, (PropertyChangeListener)this);

    public ShutdownComputer(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        ShutdownComputer copy = new ShutdownComputer(sysName, userName);
        copy.setComment(this.getComment());
        this._selectEnum.copy(copy._selectEnum);
        return manager.registerAction(copy);
    }

    public LogixNG_SelectEnum<Operation> getSelectEnum() {
        return this._selectEnum;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() throws JmriException {
        Operation operation = this._selectEnum.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnGUI(() -> {
            switch (operation) {
                case ShutdownComputer: {
                    InstanceManager.getDefault(ShutDownManager.class).shutdownOS();
                    break;
                }
                case RebootComputer: {
                    InstanceManager.getDefault(ShutDownManager.class).restartOS();
                    break;
                }
                case ShutdownJMRI: {
                    InstanceManager.getDefault(ShutDownManager.class).shutdown();
                    break;
                }
                case RebootJMRI: {
                    InstanceManager.getDefault(ShutDownManager.class).restart();
                    break;
                }
                default: {
                    throw new RuntimeException("_operation has invalid value: " + operation.name());
                }
            }
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "ShutdownComputer_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "ShutdownComputer_Long", this._selectEnum.getDescription(locale));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectEnum.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectEnum.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    public static enum Operation {
        ShutdownComputer(Bundle.getMessage("ShutdownComputer_ShutdownComputer")),
        RebootComputer(Bundle.getMessage("ShutdownComputer_RebootComputer")),
        ShutdownJMRI(Bundle.getMessage("ShutdownComputer_ShutdownJMRI")),
        RebootJMRI(Bundle.getMessage("ShutdownComputer_RebootJMRI"));

        private final String _text;

        private Operation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

