/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrix.lenz.XNetTurnout;
import jmri.jmrix.loconet.LnTurnout;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulateTurnoutFeedback
extends AbstractDigitalAction
implements PropertyChangeListener,
VetoableChangeListener {
    private final TurnoutListener _turnoutListener = new TurnoutListener();
    private final Map<Turnout, TurnoutTimerTask> _timerTasks = new HashMap<Turnout, TurnoutTimerTask>();
    private int _delay = 3;
    private final Map<String, TurnoutInfo> _turnouts = new HashMap<String, TurnoutInfo>();
    private boolean _hasBeenExecuted = false;
    private static final Logger log = LoggerFactory.getLogger(SimulateTurnoutFeedback.class);

    public SimulateTurnoutFeedback(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user, Category.OTHER);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        SimulateTurnoutFeedback copy = new SimulateTurnoutFeedback(sysName, userName);
        copy.setComment(this.getComment());
        copy._delay = this._delay;
        return manager.registerAction(copy);
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SimulateTurnoutFeedback_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "SimulateTurnoutFeedback_Long", this._delay);
    }

    @Override
    public void setup() {
    }

    @Override
    public void execute() throws JmriException {
        if (!this._hasBeenExecuted && this._listenersAreRegistered) {
            this.registerTurnoutListeners();
        }
        this._hasBeenExecuted = true;
    }

    private void registerTurnoutListeners() {
        TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
        for (Turnout t : tm.getNamedBeanSet()) {
            this.addTurnoutListener(t);
        }
        tm.addPropertyChangeListener("beans", this);
        tm.addVetoableChangeListener(this);
    }

    @Override
    public synchronized void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            this._listenersAreRegistered = true;
            if (this._hasBeenExecuted) {
                this.registerTurnoutListeners();
            }
        }
    }

    @Override
    public synchronized void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
            for (Turnout t : tm.getNamedBeanSet()) {
                this.removeTurnoutListener(t);
            }
            tm.removePropertyChangeListener("beans", this);
            tm.removeVetoableChangeListener(this);
            this._listenersAreRegistered = false;
        }
    }

    private boolean hasTurnoutFeedback(Turnout t) {
        switch (t.getFeedbackMode()) {
            case 1: 
            case 64: 
            case 128: {
                return false;
            }
            case 16: {
                return t.getFirstSensor() != null;
            }
            case 32: {
                return t.getFirstSensor() != null && t.getSecondSensor() != null;
            }
            case 2: 
            case 4: 
            case 8: 
            case 256: {
                return true;
            }
        }
        log.debug("Unsupported turnout feedback mode: {}, {}", (Object)t.getFeedbackMode(), (Object)t.getFeedbackModeName());
        return false;
    }

    private void addTurnoutListener(Turnout turnout) {
        if (!this._turnouts.containsKey(turnout.getSystemName())) {
            TurnoutInfo ti = new TurnoutInfo(turnout);
            this._turnouts.put(turnout.getSystemName(), ti);
            turnout.addPropertyChangeListener("feedbackchange", this);
            turnout.addPropertyChangeListener("turnoutFeedbackFirstSensorChange", this);
            turnout.addPropertyChangeListener("turnoutFeedbackSecondSensorChange", this);
            if (this.hasTurnoutFeedback(turnout)) {
                turnout.addPropertyChangeListener("CommandedState", this._turnoutListener);
                ti._hasListener = true;
            }
        }
    }

    private void removeTurnoutListener(Turnout turnout) {
        TurnoutInfo ti = this._turnouts.remove(turnout.getSystemName());
        turnout.removePropertyChangeListener("feedbackchange", this);
        turnout.removePropertyChangeListener("turnoutFeedbackFirstSensorChange", this);
        turnout.removePropertyChangeListener("turnoutFeedbackSecondSensorChange", this);
        if (ti != null && ti._hasListener) {
            turnout.removePropertyChangeListener("CommandedState", this._turnoutListener);
            ti._hasListener = false;
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        String evp;
        if ("beans".equals(evt.getPropertyName())) {
            String sysName;
            if (!(evt.getSource() instanceof TurnoutManager)) {
                log.error("Non-TurnoutManager sent event : {}", (Object)evt);
                return;
            }
            TurnoutManager manager = (TurnoutManager)evt.getSource();
            if (evt.getNewValue() != null) {
                sysName = evt.getNewValue().toString();
                Turnout turnout = manager.getBySystemName(sysName);
                if (this._listenersAreRegistered && turnout != null) {
                    this.addTurnoutListener(turnout);
                }
            } else if (evt.getOldValue() != null) {
                sysName = evt.getOldValue().toString();
                TurnoutInfo turnoutInfo = this._turnouts.get(sysName);
                if (this._listenersAreRegistered && turnoutInfo != null && turnoutInfo._turnout != null) {
                    this.removeTurnoutListener(turnoutInfo._turnout);
                }
            }
        }
        if ("feedbackchange".equals(evp = evt.getPropertyName()) || "turnoutFeedbackFirstSensorChange".equals(evp) || "turnoutFeedbackSecondSensorChange".equals(evp)) {
            TurnoutInfo ti = this._turnouts.get(evt.getSource().toString());
            if (this.hasTurnoutFeedback(ti._turnout)) {
                if (!ti._hasListener) {
                    ti._turnout.addPropertyChangeListener("CommandedState", this._turnoutListener);
                    ti._hasListener = true;
                }
            } else if (ti._hasListener) {
                ti._turnout.removePropertyChangeListener("CommandedState", this._turnoutListener);
                ti._hasListener = false;
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("DoDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Turnout) {
            this.removeTurnoutListener((Turnout)evt.getOldValue());
        }
    }

    @Override
    public void disposeMe() {
    }

    private class TurnoutTimerTask
    extends TimerTask {
        private final Turnout _turnout;
        private final int _newState;

        private TurnoutTimerTask(Turnout t, int newState) {
            this._turnout = t;
            this._newState = newState;
            this.startMove();
        }

        private void startMove() {
            switch (this._turnout.getFeedbackMode()) {
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
                case 32: {
                    Sensor sensor2;
                    Sensor sensor1 = this._turnout.getFirstSensor();
                    if (sensor1 != null) {
                        sensor1.setCommandedState(4);
                    }
                    if ((sensor2 = this._turnout.getSecondSensor()) == null) break;
                    sensor2.setCommandedState(4);
                    break;
                }
                case 256: {
                    break;
                }
                default: {
                    log.debug("Unsupported turnout feedback mode: {}, {}", (Object)this._turnout.getFeedbackMode(), (Object)this._turnout.getFeedbackModeName());
                }
            }
        }

        private void stopMove() {
            switch (this._turnout.getFeedbackMode()) {
                case 2: {
                    if (this._turnout instanceof LnTurnout) {
                        LnTurnout lnTurnout = (LnTurnout)this._turnout;
                        lnTurnout.newKnownState(this._newState);
                        break;
                    }
                    if (this._turnout instanceof XNetTurnout) {
                        XNetTurnout xnetTurnout = (XNetTurnout)this._turnout;
                        xnetTurnout.newKnownState(this._newState);
                        break;
                    }
                    log.warn("Unknown type of turnout {}, {}", (Object)this._turnout.getSystemName(), (Object)this._turnout.getDisplayName());
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    Sensor sensor = this._turnout.getFirstSensor();
                    if (this._newState == 2) {
                        if (sensor == null) break;
                        sensor.setCommandedState(4);
                        break;
                    }
                    if (this._newState != 4 || sensor == null) break;
                    sensor.setCommandedState(2);
                    break;
                }
                case 32: {
                    Sensor sensor;
                    if (this._newState == 2) {
                        Sensor sensor2 = this._turnout.getSecondSensor();
                        if (sensor2 == null) break;
                        sensor2.setCommandedState(2);
                        break;
                    }
                    if (this._newState != 4 || (sensor = this._turnout.getFirstSensor()) == null) break;
                    sensor.setCommandedState(2);
                    break;
                }
                case 256: {
                    break;
                }
                default: {
                    log.debug("Unsupported turnout feedback mode: {}, {}", (Object)this._turnout.getFeedbackMode(), (Object)this._turnout.getFeedbackModeName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<Turnout, TurnoutTimerTask> map = SimulateTurnoutFeedback.this._timerTasks;
            synchronized (map) {
                SimulateTurnoutFeedback.this._timerTasks.remove(this._turnout);
            }
            this.stopMove();
        }
    }

    private class TurnoutListener
    implements PropertyChangeListener {
        private TurnoutListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageTurnout(Turnout t, int newState) {
            Map<Turnout, TurnoutTimerTask> map = SimulateTurnoutFeedback.this._timerTasks;
            synchronized (map) {
                TurnoutTimerTask task;
                if (SimulateTurnoutFeedback.this._timerTasks.containsKey(t)) {
                    task = SimulateTurnoutFeedback.this._timerTasks.get(t);
                    task.cancel();
                    SimulateTurnoutFeedback.this._timerTasks.remove(t);
                }
                task = new TurnoutTimerTask(t, newState);
                SimulateTurnoutFeedback.this._timerTasks.put(t, task);
                TimerUtil.schedule((TimerTask)task, (long)SimulateTurnoutFeedback.this._delay * 1000L);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("CommandedState".equals(evt.getPropertyName())) {
                String sysName = evt.getSource().toString();
                TurnoutManager tm = InstanceManager.getDefault(TurnoutManager.class);
                Turnout t = tm.getBySystemName(sysName);
                if (t == null) {
                    log.error("Turnout {} does not exists in manager {}", (Object)sysName, (Object)tm);
                    return;
                }
                switch (t.getFeedbackMode()) {
                    case 1: 
                    case 64: 
                    case 128: {
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 256: {
                        this.manageTurnout(t, (Integer)evt.getNewValue());
                        break;
                    }
                    default: {
                        log.debug("Unsupported turnout feedback mode: {}, {}", (Object)t.getFeedbackMode(), (Object)t.getFeedbackModeName());
                    }
                }
            }
        }
    }

    private static class TurnoutInfo {
        private final Turnout _turnout;
        private boolean _hasListener;

        TurnoutInfo(Turnout turnout) {
            this._turnout = turnout;
        }
    }
}

