/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleSocketOperation;
import jmri.jmrit.logixng.FemaleStringActionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.StringActionManager;
import jmri.jmrit.logixng.actions.AbstractStringAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMany
extends AbstractStringAction
implements FemaleSocketListener {
    private final List<ActionEntry> _actionEntries = new ArrayList<ActionEntry>();
    private boolean disableCheckForUnconnectedSocket = false;
    private static final Logger log = LoggerFactory.getLogger(StringMany.class);

    public StringMany(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._actionEntries.add(new ActionEntry(InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, this.getNewSocketName())));
    }

    public StringMany(String sys, String user, List<Map.Entry<String, String>> actionSystemNames) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this.setActionSystemNames(actionSystemNames);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        StringActionManager manager = InstanceManager.getDefault(StringActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        StringMany copy = new StringMany(sysName, userName);
        copy.setComment(this.getComment());
        copy.setNumSockets(this.getChildCount());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    private void setActionSystemNames(List<Map.Entry<String, String>> systemNames) {
        if (!this._actionEntries.isEmpty()) {
            throw new RuntimeException("action system names cannot be set more than once");
        }
        for (Map.Entry<String, String> entry : systemNames) {
            FemaleStringActionSocket socket = InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, entry.getKey());
            this._actionEntries.add(new ActionEntry(socket, entry.getValue()));
        }
    }

    public String getActionSystemName(int index) {
        return this._actionEntries.get((int)index)._socketSystemName;
    }

    @Override
    public void setup() {
        this.disableCheckForUnconnectedSocket = true;
        for (ActionEntry ae : this._actionEntries) {
            try {
                if (!ae._socket.isConnected() || !ae._socket.getConnectedSocket().getSystemName().equals(ae._socketSystemName)) {
                    String socketSystemName = ae._socketSystemName;
                    ae._socket.disconnect();
                    if (socketSystemName == null) continue;
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(StringActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        ae._socket.connect(maleSocket);
                        maleSocket.setup();
                        continue;
                    }
                    log.error("cannot load string action {}", (Object)socketSystemName);
                    continue;
                }
                ae._socket.getConnectedSocket().setup();
            }
            catch (SocketAlreadyConnectedException ex) {
                throw new RuntimeException("socket is already connected");
            }
        }
        this.checkFreeSocket();
        this.disableCheckForUnconnectedSocket = false;
    }

    @Override
    public Category getCategory() {
        return Category.COMMON;
    }

    @Override
    public void setValue(String value) throws JmriException {
        for (ActionEntry actionEntry : this._actionEntries) {
            actionEntry._socket.setValue(value);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        return this._actionEntries.get((int)index)._socket;
    }

    @Override
    public int getChildCount() {
        return this._actionEntries.size();
    }

    private void setNumSockets(int num) {
        ArrayList<FemaleStringActionSocket> addList = new ArrayList<FemaleStringActionSocket>();
        while (this._actionEntries.size() < num) {
            FemaleStringActionSocket socket = InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._actionEntries.add(new ActionEntry(socket));
            addList.add(socket);
        }
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void checkFreeSocket() {
        boolean hasFreeSocket = false;
        for (ActionEntry entry : this._actionEntries) {
            hasFreeSocket |= !entry._socket.isConnected();
        }
        if (!hasFreeSocket) {
            FemaleStringActionSocket socket = InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
            this._actionEntries.add(new ActionEntry(socket));
            ArrayList<FemaleStringActionSocket> list = new ArrayList<FemaleStringActionSocket>();
            list.add(socket);
            this.firePropertyChange("ChildCount", null, list);
        }
    }

    @Override
    public boolean isSocketOperationAllowed(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (this._actionEntries.size() == 1) {
                    return false;
                }
                return !this.getChild(index).isConnected();
            }
            case InsertBefore: {
                return true;
            }
            case InsertAfter: {
                return true;
            }
            case MoveUp: {
                return index > 0;
            }
            case MoveDown: {
                return index + 1 < this.getChildCount();
            }
        }
        throw new UnsupportedOperationException("Oper is unknown" + oper.name());
    }

    private void insertNewSocket(int index) {
        FemaleStringActionSocket socket = InstanceManager.getDefault(StringActionManager.class).createFemaleSocket(this, this, this.getNewSocketName());
        this._actionEntries.add(index, new ActionEntry(socket));
        ArrayList<FemaleStringActionSocket> addList = new ArrayList<FemaleStringActionSocket>();
        addList.add(socket);
        this.firePropertyChange("ChildCount", null, addList);
    }

    private void removeSocket(int index) {
        ArrayList<FemaleStringActionSocket> removeList = new ArrayList<FemaleStringActionSocket>();
        removeList.add(this._actionEntries.remove((int)index)._socket);
        this.firePropertyChange("ChildCount", removeList, null);
    }

    private void moveSocketDown(int index) {
        ActionEntry temp = this._actionEntries.get(index);
        this._actionEntries.set(index, this._actionEntries.get(index + 1));
        this._actionEntries.set(index + 1, temp);
        ArrayList<FemaleStringActionSocket> list = new ArrayList<FemaleStringActionSocket>();
        list.add(this._actionEntries.get((int)index)._socket);
        list.add(this._actionEntries.get((int)(index + 1))._socket);
        this.firePropertyChange("ChildReorder", null, list);
    }

    @Override
    public void doSocketOperation(int index, FemaleSocketOperation oper) {
        switch (oper) {
            case Remove: {
                if (this.getChild(index).isConnected()) {
                    throw new UnsupportedOperationException("Socket is connected");
                }
                this.removeSocket(index);
                break;
            }
            case InsertBefore: {
                this.insertNewSocket(index);
                break;
            }
            case InsertAfter: {
                this.insertNewSocket(index + 1);
                break;
            }
            case MoveUp: {
                if (index == 0) {
                    throw new UnsupportedOperationException("cannot move up first child");
                }
                this.moveSocketDown(index - 1);
                break;
            }
            case MoveDown: {
                if (index + 1 == this.getChildCount()) {
                    throw new UnsupportedOperationException("cannot move down last child");
                }
                this.moveSocketDown(index);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Oper is unknown" + oper.name());
            }
        }
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (this.disableCheckForUnconnectedSocket) {
            return;
        }
        for (ActionEntry entry : this._actionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = socket.getConnectedSocket().getSystemName();
        }
        this.checkFreeSocket();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        for (ActionEntry entry : this._actionEntries) {
            if (socket != entry._socket) continue;
            entry._socketSystemName = null;
            break;
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Many_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Many_Long");
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }

    private static class ActionEntry {
        private String _socketSystemName;
        private final FemaleStringActionSocket _socket;

        private ActionEntry(FemaleStringActionSocket socket, String socketSystemName) {
            this._socketSystemName = socketSystemName;
            this._socket = socket;
        }

        private ActionEntry(FemaleStringActionSocket socket) {
            this._socket = socket;
        }
    }
}

