/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BreakException;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ContinueException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.Table;
import jmri.jmrit.logixng.TableRowOrColumn;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.ReferenceUtil;
import jmri.jmrit.logixng.util.parser.ExpressionNode;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.parser.RecursiveDescentParser;
import jmri.jmrit.logixng.util.parser.Variable;
import jmri.util.TypeConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableForEach
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener {
    private final LogixNG_SelectNamedBean<NamedTable> _selectNamedBean = new LogixNG_SelectNamedBean<NamedTable>(this, NamedTable.class, InstanceManager.getDefault(NamedTableManager.class), this);
    private NamedBeanAddressing _rowOrColumnAddressing = NamedBeanAddressing.Direct;
    private TableRowOrColumn _tableRowOrColumn = TableRowOrColumn.Row;
    private String _rowOrColumnName = "";
    private String _rowOrColumnReference = "";
    private String _rowOrColumnLocalVariable = "";
    private String _rowOrColumnFormula = "";
    private ExpressionNode _rowOrColumnExpressionNode;
    private String _variableName = "";
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A1");
    private static final Logger log = LoggerFactory.getLogger(TableForEach.class);

    public TableForEach(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        TableForEach copy = new TableForEach(sysName, userName);
        copy.setComment(this.getComment());
        this._selectNamedBean.copy(copy._selectNamedBean);
        copy.setRowOrColumnAddressing(this._rowOrColumnAddressing);
        copy.setRowOrColumn(this._tableRowOrColumn);
        copy.setRowOrColumnName(this._rowOrColumnName);
        copy.setLocalVariableName(this._variableName);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectNamedBean<NamedTable> getSelectNamedBean() {
        return this._selectNamedBean;
    }

    @Override
    public Category getCategory() {
        return Category.FLOW_CONTROL;
    }

    private String getNewRowOrColumnName() throws JmriException {
        switch (this._rowOrColumnAddressing) {
            case Direct: {
                return this._rowOrColumnName;
            }
            case Reference: {
                return ReferenceUtil.getReference(this.getConditionalNG().getSymbolTable(), this._rowOrColumnReference);
            }
            case LocalVariable: {
                SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
                return TypeConversionUtil.convertToString(symbolTable.getValue(this._rowOrColumnLocalVariable), false);
            }
            case Formula: {
                return this._rowOrColumnExpressionNode != null ? TypeConversionUtil.convertToString(this._rowOrColumnExpressionNode.calculate(this.getConditionalNG().getSymbolTable()), false) : null;
            }
        }
        throw new IllegalArgumentException("invalid _rowOrColumnAddressing state: " + this._rowOrColumnAddressing.name());
    }

    @Override
    public void execute() throws JmriException {
        Table table = this._selectNamedBean.evaluateNamedBean(this.getConditionalNG());
        if (table == null) {
            return;
        }
        String rowOrColumnName = this.getNewRowOrColumnName();
        if (rowOrColumnName == null) {
            log.error("rowOrColumnName is null");
            return;
        }
        if (this._variableName == null) {
            log.error("variableName is null");
            return;
        }
        if (!this._socket.isConnected()) {
            log.error("socket is not connected");
            return;
        }
        SymbolTable symbolTable = this.getConditionalNG().getSymbolTable();
        if (this._tableRowOrColumn == TableRowOrColumn.Row) {
            int row = 0;
            if (!rowOrColumnName.isEmpty()) {
                row = table.getRowNumber(rowOrColumnName);
            }
            for (int column = 1; column <= table.numColumns(); ++column) {
                Object header = table.getCell(0, column);
                if (header == null || header.toString().isEmpty()) continue;
                symbolTable.setValue(this._variableName, table.getCell(row, column));
                try {
                    this._socket.execute();
                    continue;
                }
                catch (BreakException e) {
                    break;
                }
                catch (ContinueException e) {
                    // empty catch block
                }
            }
        } else {
            int column = 0;
            if (!rowOrColumnName.isEmpty()) {
                column = table.getColumnNumber(rowOrColumnName);
            }
            for (int row = 1; row <= table.numRows(); ++row) {
                Object header = table.getCell(row, 0);
                if (header == null || header.toString().isEmpty()) continue;
                symbolTable.setValue(this._variableName, table.getCell(row, column));
                try {
                    this._socket.execute();
                    continue;
                }
                catch (BreakException e) {
                    break;
                }
                catch (ContinueException continueException) {
                    // empty catch block
                }
            }
        }
    }

    public TableRowOrColumn getRowOrColumn() {
        return this._tableRowOrColumn;
    }

    public void setRowOrColumn(@Nonnull TableRowOrColumn tableRowOrColumn) {
        this._tableRowOrColumn = tableRowOrColumn;
    }

    public void setRowOrColumnAddressing(NamedBeanAddressing addressing) throws ParserException {
        this._rowOrColumnAddressing = addressing;
        this.parseRowOrColumnFormula();
    }

    public NamedBeanAddressing getRowOrColumnAddressing() {
        return this._rowOrColumnAddressing;
    }

    public String getRowOrColumnName() {
        return this._rowOrColumnName;
    }

    public void setRowOrColumnName(@Nonnull String rowOrColumnName) {
        if (rowOrColumnName == null) {
            throw new RuntimeException("Daniel");
        }
        this._rowOrColumnName = rowOrColumnName;
    }

    public void setRowOrColumnReference(@Nonnull String reference) {
        if (!reference.isEmpty() && !ReferenceUtil.isReference(reference)) {
            throw new IllegalArgumentException("The reference \"" + reference + "\" is not a valid reference");
        }
        this._rowOrColumnReference = reference;
    }

    public String getRowOrColumnReference() {
        return this._rowOrColumnReference;
    }

    public void setRowOrColumnLocalVariable(@Nonnull String localVariable) {
        this._rowOrColumnLocalVariable = localVariable;
    }

    public String getRowOrColumnLocalVariable() {
        return this._rowOrColumnLocalVariable;
    }

    public void setRowOrColumnFormula(@Nonnull String formula) throws ParserException {
        this._rowOrColumnFormula = formula;
        this.parseRowOrColumnFormula();
    }

    public String getRowOrColumnFormula() {
        return this._rowOrColumnFormula;
    }

    private void parseRowOrColumnFormula() throws ParserException {
        if (this._rowOrColumnAddressing == NamedBeanAddressing.Formula) {
            HashMap<String, Variable> variables = new HashMap<String, Variable>();
            RecursiveDescentParser parser = new RecursiveDescentParser(variables);
            this._rowOrColumnExpressionNode = parser.parseExpression(this._rowOrColumnFormula);
        } else {
            this._rowOrColumnExpressionNode = null;
        }
    }

    public String getLocalVariableName() {
        return this._variableName;
    }

    public void setLocalVariableName(String localVariableName) {
        this._variableName = localVariableName;
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "TableForEach_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String rowOrColumnName;
        String namedBean = this._selectNamedBean.getDescription(locale);
        switch (this._rowOrColumnAddressing) {
            case Direct: {
                String name = this._rowOrColumnName;
                if (name.isEmpty()) {
                    name = Bundle.getMessage("TableForEach_Header");
                }
                rowOrColumnName = Bundle.getMessage(locale, "AddressByDirect", name);
                break;
            }
            case Reference: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByReference", this._rowOrColumnReference);
                break;
            }
            case LocalVariable: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByLocalVariable", this._rowOrColumnLocalVariable);
                break;
            }
            case Formula: {
                rowOrColumnName = Bundle.getMessage(locale, "AddressByFormula", this._rowOrColumnFormula);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _rowOrColumnAddressing state: " + this._rowOrColumnAddressing.name());
            }
        }
        return Bundle.getMessage(locale, "TableForEach_Long", this._tableRowOrColumn.getOpposite().toStringLowerCase(), this._tableRowOrColumn.toStringLowerCase(), rowOrColumnName, namedBean, this._variableName, this._socket.getName());
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._socket.disconnect();
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNamedBean.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNamedBean.unregisterListeners();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }
}

