/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.DigitalExpressionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleDigitalExpressionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.jmrit.logixng.util.ProtectedTimerTask;
import jmri.jmrit.logixng.util.TimerUnit;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timeout
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener {
    private ProtectedTimerTask _timerTask;
    private final LogixNG_SelectInteger _selectDelay = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectEnum<TimerUnit> _selectTimerUnit = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])TimerUnit.values(), (Enum)TimerUnit.MilliSeconds, (PropertyChangeListener)this);
    private String _expressionSocketSystemName;
    private String _actionSocketSystemName;
    private final FemaleDigitalExpressionSocket _expressionSocket;
    private final FemaleDigitalActionSocket _actionSocket;
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private long _timerDelay = 0L;
    private long _timerStart = 0L;
    private static final Logger log = LoggerFactory.getLogger(Timeout.class);

    public Timeout(String sys, String user) {
        super(sys, user);
        this._expressionSocket = InstanceManager.getDefault(DigitalExpressionManager.class).createFemaleSocket(this, this, "E");
        this._actionSocket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, "A");
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Timeout copy = new Timeout(sysName, userName);
        copy.setComment(this.getComment());
        this._selectDelay.copy(copy._selectDelay);
        this._selectTimerUnit.copy(copy._selectTimerUnit);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    private ProtectedTimerTask getNewTimerTask(final ConditionalNG conditionalNG, final SymbolTable symbolTable) throws JmriException {
        final DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(symbolTable);
        return new ProtectedTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                try {
                    Timeout timeout = Timeout.this;
                    synchronized (timeout) {
                        Timeout.this._timerTask = null;
                        long currentTimerTime = System.currentTimeMillis() - Timeout.this._timerStart;
                        if (currentTimerTime < Timeout.this._timerDelay) {
                            Timeout.this.scheduleTimer(conditionalNG, symbolTable, Timeout.this._timerDelay - currentTimerTime);
                        } else {
                            Timeout.this._internalSocket.conditionalNG = conditionalNG;
                            Timeout.this._internalSocket.newSymbolTable = newSymbolTable;
                            conditionalNG.execute(Timeout.this._internalSocket);
                        }
                    }
                }
                catch (RuntimeException | JmriException e) {
                    log.error("Exception thrown", (Throwable)e);
                }
            }
        };
    }

    private void scheduleTimer(ConditionalNG conditionalNG, SymbolTable symbolTable, long delay) throws JmriException {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
        }
        this._timerTask = this.getNewTimerTask(conditionalNG, symbolTable);
        TimerUtil.schedule((TimerTask)this._timerTask, delay);
    }

    public LogixNG_SelectInteger getSelectDelay() {
        return this._selectDelay;
    }

    public LogixNG_SelectEnum<TimerUnit> getSelectTimerUnit() {
        return this._selectTimerUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws JmriException {
        boolean result = this._expressionSocket.evaluate();
        Timeout timeout = this;
        synchronized (timeout) {
            if (result) {
                if (this._timerTask != null) {
                    this._timerTask.stopTimer();
                    this._timerTask = null;
                }
                return;
            }
            if (this._timerTask != null) {
                return;
            }
            this._timerDelay = (long)this._selectDelay.evaluateValue(this.getConditionalNG()) * this._selectTimerUnit.evaluateEnum(this.getConditionalNG()).getMultiply();
            this._timerStart = System.currentTimeMillis();
            ConditionalNG conditonalNG = this.getConditionalNG();
            this.scheduleTimer(conditonalNG, conditonalNG.getSymbolTable(), this._timerDelay);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._expressionSocket;
            }
            case 1: {
                return this._actionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 2;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = socket.getConnectedSocket().getSystemName();
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket == this._expressionSocket) {
            this._expressionSocketSystemName = null;
        } else if (socket == this._actionSocket) {
            this._actionSocketSystemName = null;
        } else {
            throw new IllegalArgumentException("unkown socket");
        }
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Timeout_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        String delay = this._selectDelay.getDescription(locale);
        if (this._selectDelay.isDirectAddressing() && this._selectTimerUnit.isDirectAddressing()) {
            return Bundle.getMessage(locale, "Timeout_Long", this._expressionSocket.getName(), this._actionSocket.getName(), this._selectTimerUnit.getEnum().getTimeWithUnit(this._selectDelay.getValue()));
        }
        String timeUnit = this._selectTimerUnit.getDescription(locale);
        return Bundle.getMessage(locale, "Timeout_Long_Indirect", this._expressionSocket.getName(), this._actionSocket.getName(), delay, timeUnit);
    }

    public FemaleDigitalExpressionSocket getExpressionSocket() {
        return this._expressionSocket;
    }

    public String getExpressionSocketSystemName() {
        return this._expressionSocketSystemName;
    }

    public void setExpressionSocketSystemName(String systemName) {
        this._expressionSocketSystemName = systemName;
    }

    public FemaleDigitalActionSocket getActionSocket() {
        return this._actionSocket;
    }

    public String getActionSocketSystemName() {
        return this._actionSocketSystemName;
    }

    public void setActionSocketSystemName(String systemName) {
        this._actionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            MaleSocket maleSocket;
            String socketSystemName;
            if (!this._expressionSocket.isConnected() || !this._expressionSocket.getConnectedSocket().getSystemName().equals(this._expressionSocketSystemName)) {
                socketSystemName = this._expressionSocketSystemName;
                this._expressionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._expressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._expressionSocket.getConnectedSocket().setup();
            }
            if (!this._actionSocket.isConnected() || !this._actionSocket.getConnectedSocket().getSystemName().equals(this._actionSocketSystemName)) {
                socketSystemName = this._actionSocketSystemName;
                this._actionSocket.disconnect();
                if (socketSystemName != null) {
                    maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    this._actionSocket.disconnect();
                    if (maleSocket != null) {
                        this._actionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._actionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectDelay.registerListeners();
        this._selectTimerUnit.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectDelay.unregisterListeners();
        this._selectTimerUnit.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
        if (this._timerTask != null) {
            this._timerTask.stopTimer();
            this._timerTask = null;
        }
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG conditionalNG;
        private SymbolTable newSymbolTable;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (this.conditionalNG == null) {
                throw new NullPointerException("conditionalNG is null");
            }
            if (Timeout.this._actionSocket != null) {
                SymbolTable oldSymbolTable = this.conditionalNG.getSymbolTable();
                this.conditionalNG.setSymbolTable(this.newSymbolTable);
                Timeout.this._actionSocket.execute();
                this.conditionalNG.setSymbolTable(oldSymbolTable);
            }
        }
    }
}

