/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.awt.Desktop;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.FemaleStringExpressionSocket;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.StringExpressionManager;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebBrowser
extends AbstractDigitalAction
implements FemaleSocketListener {
    private String _urlExpressionSocketSystemName;
    private final FemaleStringExpressionSocket _urlExpressionSocket = InstanceManager.getDefault(StringExpressionManager.class).createFemaleSocket(this, this, "E");
    private static final Logger log = LoggerFactory.getLogger(WebBrowser.class);

    public WebBrowser(String sys, String user) {
        super(sys, user);
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        WebBrowser copy = new WebBrowser(sysName, userName);
        copy.setComment(this.getComment());
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() throws JmriException {
        String url = this._urlExpressionSocket.evaluate();
        try {
            URI uri = new URI(url);
            HttpURLConnection request = (HttpURLConnection)uri.toURL().openConnection();
            request.setRequestMethod("GET");
            request.connect();
            if (request.getResponseCode() != 200) {
                throw new JmriException(String.format("Failed to connect to web page: %d, %s", request.getResponseCode(), request.getResponseMessage()));
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new JmriException("Failed to connect to web page. java.awt.Desktop doesn't suppport Action.BROWSE");
            }
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new JmriException(String.format("Failed to connect to web page. Exception thrown: %s", e.getMessage()), e);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._urlExpressionSocket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._urlExpressionSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._urlExpressionSocketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._urlExpressionSocket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._urlExpressionSocketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "WebBrowser_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "WebBrowser_Long", this._urlExpressionSocket.getName());
    }

    public FemaleStringExpressionSocket getStringExpressionSocket() {
        return this._urlExpressionSocket;
    }

    public String getStringExpressionSocketSystemName() {
        return this._urlExpressionSocketSystemName;
    }

    public void setStringExpressionSocketSystemName(String systemName) {
        this._urlExpressionSocketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._urlExpressionSocket.isConnected() || !this._urlExpressionSocket.getConnectedSocket().getSystemName().equals(this._urlExpressionSocketSystemName)) {
                String socketSystemName = this._urlExpressionSocketSystemName;
                this._urlExpressionSocket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(StringExpressionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._urlExpressionSocket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load string expression {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._urlExpressionSocket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void disposeMe() {
    }
}

