/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.net.ssl.HttpsURLConnection;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleDigitalActionSocket;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.FemaleSocketListener;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SocketAlreadyConnectedException;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.actions.Bundle;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.implementation.DefaultFemaleDigitalActionSocket;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.util.LineEnding;
import jmri.jmrit.logixng.util.LogixNG_SelectCharset;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequest
extends AbstractDigitalAction
implements FemaleSocketListener,
PropertyChangeListener,
VetoableChangeListener {
    private static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.logixng.implementation.ImplementationBundle");
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0";
    private final LogixNG_SelectString _selectUrl = new LogixNG_SelectString(this, this);
    private final LogixNG_SelectCharset _selectCharset = new LogixNG_SelectCharset(this, this);
    private final LogixNG_SelectEnum<RequestMethodType> _selectRequestMethod = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])RequestMethodType.values(), (Enum)RequestMethodType.Get, (PropertyChangeListener)this);
    private final LogixNG_SelectString _selectUserAgent = new LogixNG_SelectString((AbstractBase)this, "Mozilla/5.0", (PropertyChangeListener)this);
    private final LogixNG_SelectEnum<ReplyType> _selectReplyType = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])ReplyType.values(), (Enum)ReplyType.String, (PropertyChangeListener)this);
    private final LogixNG_SelectEnum<LineEnding> _selectLineEnding = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])LineEnding.values(), (Enum)LineEnding.System, (PropertyChangeListener)this);
    private final List<Parameter> _parameters = new ArrayList<Parameter>();
    private String _socketSystemName;
    private final FemaleDigitalActionSocket _socket;
    private String _localVariableForResponseCode = "";
    private String _localVariableForReplyContent = "";
    private String _localVariableForCookies = "";
    private final InternalFemaleSocket _internalSocket = new InternalFemaleSocket();
    private static final Logger log = LoggerFactory.getLogger(WebRequest.class);

    public WebRequest(String sys, String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._socket = InstanceManager.getDefault(DigitalActionManager.class).createFemaleSocket(this, this, Bundle.getMessage("ShowDialog_SocketExecute"));
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException, JmriException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        WebRequest copy = new WebRequest(sysName, userName);
        copy.setComment(this.getComment());
        this.getSelectUrl().copy(copy._selectUrl);
        this.getSelectCharset().copy(copy._selectCharset);
        this.getSelectRequestMethod().copy(copy._selectRequestMethod);
        this.getSelectUserAgent().copy(copy._selectUserAgent);
        copy._parameters.addAll(this._parameters);
        copy.setLocalVariableForResponseCode(this._localVariableForResponseCode);
        copy.setLocalVariableForReplyContent(this._localVariableForReplyContent);
        copy.setLocalVariableForCookies(this._localVariableForCookies);
        return manager.registerAction(copy).deepCopyChildren(this, systemNames, userNames);
    }

    public LogixNG_SelectString getSelectUrl() {
        return this._selectUrl;
    }

    public LogixNG_SelectCharset getSelectCharset() {
        return this._selectCharset;
    }

    public LogixNG_SelectEnum<RequestMethodType> getSelectRequestMethod() {
        return this._selectRequestMethod;
    }

    public LogixNG_SelectString getSelectUserAgent() {
        return this._selectUserAgent;
    }

    public LogixNG_SelectEnum<ReplyType> getSelectReplyType() {
        return this._selectReplyType;
    }

    public LogixNG_SelectEnum<LineEnding> getSelectLineEnding() {
        return this._selectLineEnding;
    }

    public List<Parameter> getParameters() {
        return this._parameters;
    }

    public void setLocalVariableForResponseCode(String localVariable) {
        this._localVariableForResponseCode = localVariable;
    }

    public String getLocalVariableForResponseCode() {
        return this._localVariableForResponseCode;
    }

    public void setLocalVariableForReplyContent(String localVariable) {
        this._localVariableForReplyContent = localVariable;
    }

    public String getLocalVariableForReplyContent() {
        return this._localVariableForReplyContent;
    }

    public void setLocalVariableForCookies(String localVariable) {
        this._localVariableForCookies = localVariable;
    }

    public String getLocalVariableForCookies() {
        return this._localVariableForCookies;
    }

    @Override
    public Category getCategory() {
        return Category.OTHER;
    }

    @Override
    public void execute() throws JmriException {
        URL url;
        ConditionalNG conditionalNG = this.getConditionalNG();
        DefaultSymbolTable newSymbolTable = new DefaultSymbolTable(conditionalNG.getSymbolTable());
        boolean useThread = conditionalNG.getRunDelayed();
        Object urlString = this._selectUrl.evaluateValue(conditionalNG);
        Charset charset = this._selectCharset.evaluateCharset(conditionalNG);
        String userAgent = this._selectUserAgent.evaluateValue(conditionalNG);
        RequestMethodType requestMethodType = this._selectRequestMethod.evaluateEnum(conditionalNG);
        ReplyType replyType = this._selectReplyType.evaluateEnum(conditionalNG);
        LineEnding lineEnding = this._selectLineEnding.evaluateEnum(conditionalNG);
        StringBuilder paramString = new StringBuilder();
        try {
            for (Parameter parameter : this._parameters) {
                Object v = SymbolTable.getInitialValue(SymbolTable.Type.Parameter, parameter._name, parameter._type, parameter._data, newSymbolTable, newSymbolTable.getSymbols());
                String value = v != null ? v.toString() : "";
                paramString.append(URLEncoder.encode(parameter._name, charset));
                paramString.append("=");
                paramString.append(URLEncoder.encode(value, charset));
                paramString.append("&");
            }
            if (paramString.length() > 0) {
                paramString.deleteCharAt(paramString.length() - 1);
            }
            if (requestMethodType == RequestMethodType.Get) {
                urlString = ((String)urlString).contains("?") ? (String)urlString + "&" : (String)urlString + "?";
                urlString = (String)urlString + paramString.toString();
            }
            url = new URI((String)urlString).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new JmriException(ex.getMessage(), ex);
        }
        boolean useHttps = ((String)urlString).toLowerCase().startsWith("https://");
        Runnable runnable = () -> {
            try {
                Object reply;
                HttpURLConnection con = useHttps ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                con.setRequestMethod(requestMethodType._identifier);
                con.setRequestProperty("User-Agent", userAgent);
                HashMap<String, String> cookiesMap = null;
                if (!this._localVariableForCookies.isEmpty()) {
                    StringBuilder cookies = new StringBuilder();
                    Object cookiesObject = newSymbolTable.getValue(this._localVariableForCookies);
                    if (cookiesObject != null) {
                        if (!(cookiesObject instanceof Map)) {
                            throw new IllegalArgumentException(String.format("The value of the local variable '%s' must be a Map", this._localVariableForCookies));
                        }
                        cookiesMap = (HashMap<String, String>)cookiesObject;
                        for (Map.Entry entry : cookiesMap.entrySet()) {
                            if (cookies.length() > 0) {
                                cookies.append("; ");
                            }
                            String[] cookieParts = ((String)entry.getValue()).split("; ");
                            cookies.append(cookieParts[0]);
                        }
                        if (cookies.length() > 0) {
                            con.setRequestProperty("Cookie", cookies.toString());
                        }
                    }
                }
                if (requestMethodType == RequestMethodType.Post) {
                    con.setRequestMethod("POST");
                    con.setDoOutput(true);
                    try (DataOutputStream out = new DataOutputStream(con.getOutputStream());){
                        out.writeBytes(paramString.toString());
                        out.flush();
                    }
                }
                if (replyType == ReplyType.Bytes) {
                    reply = con.getInputStream().readAllBytes();
                } else if (replyType == ReplyType.String || replyType == ReplyType.ListOfStrings) {
                    ArrayList<String> list = new ArrayList<String>();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String input;
                        while ((input = br.readLine()) != null) {
                            list.add(input);
                        }
                    }
                    reply = replyType == ReplyType.String ? (Object)String.join((CharSequence)lineEnding.getLineEnding(), list) : (Object)list;
                } else {
                    throw new IllegalArgumentException("replyType has unknown value: " + replyType.name());
                }
                if (cookiesMap == null) {
                    cookiesMap = new HashMap<String, String>();
                }
                for (Map.Entry<String, List<String>> entry : con.getHeaderFields().entrySet()) {
                    if (!"Set-Cookie".equals(entry.getKey())) continue;
                    for (String value : entry.getValue()) {
                        String[] parts = value.split("=");
                        cookiesMap.put(parts[0], value);
                    }
                }
                WebRequest webRequest = this;
                synchronized (webRequest) {
                    this._internalSocket._conditionalNG = conditionalNG;
                    this._internalSocket._newSymbolTable = newSymbolTable;
                    this._internalSocket._cookies = cookiesMap;
                    this._internalSocket._responseCode = con.getResponseCode();
                    this._internalSocket._reply = reply;
                    if (useThread) {
                        conditionalNG.execute(this._internalSocket);
                    } else {
                        this._internalSocket.execute();
                    }
                }
            }
            catch (IOException | IllegalArgumentException | JmriException ex) {
                log.error("An exception has occurred: {}", (Object)ex, (Object)ex);
            }
        };
        if (useThread) {
            ThreadingUtil.newThread(runnable, "LogixNG action WebRequest").start();
        } else {
            runnable.run();
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        switch (index) {
            case 0: {
                return this._socket;
            }
        }
        throw new IllegalArgumentException(String.format("index has invalid value: %d", index));
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public void connected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = socket.getConnectedSocket().getSystemName();
    }

    @Override
    public void disconnected(FemaleSocket socket) {
        if (socket != this._socket) {
            throw new IllegalArgumentException("unkown socket");
        }
        this._socketSystemName = null;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "WebRequest_Short");
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage("WebRequest_Long", this._selectUrl.getDescription(locale));
    }

    public FemaleDigitalActionSocket getSocket() {
        return this._socket;
    }

    public String getSocketSystemName() {
        return this._socketSystemName;
    }

    public void setSocketSystemName(String systemName) {
        this._socketSystemName = systemName;
    }

    @Override
    public void setup() {
        try {
            if (!this._socket.isConnected() || !this._socket.getConnectedSocket().getSystemName().equals(this._socketSystemName)) {
                String socketSystemName = this._socketSystemName;
                this._socket.disconnect();
                if (socketSystemName != null) {
                    MaleSocket maleSocket = (MaleSocket)InstanceManager.getDefault(DigitalActionManager.class).getBySystemName(socketSystemName);
                    if (maleSocket != null) {
                        this._socket.connect(maleSocket);
                        maleSocket.setup();
                    } else {
                        log.error("cannot load digital action {}", (Object)socketSystemName);
                    }
                }
            } else {
                this._socket.getConnectedSocket().setup();
            }
        }
        catch (SocketAlreadyConnectedException ex) {
            throw new RuntimeException("socket is already connected");
        }
    }

    @Override
    public void registerListenersForThisClass() {
    }

    @Override
    public void unregisterListenersForThisClass() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    @Override
    public void getUsageDetail(int level, NamedBean bean, List<NamedBeanUsageReport> report, NamedBean cdl) {
    }

    private class InternalFemaleSocket
    extends DefaultFemaleDigitalActionSocket {
        private ConditionalNG _conditionalNG;
        private SymbolTable _newSymbolTable;
        private int _responseCode;
        private Map<String, String> _cookies;
        private Object _reply;

        public InternalFemaleSocket() {
            super(null, new FemaleSocketListener(){

                @Override
                public void connected(FemaleSocket socket) {
                }

                @Override
                public void disconnected(FemaleSocket socket) {
                }
            }, "A");
        }

        @Override
        public void execute() throws JmriException {
            if (WebRequest.this._socket != null) {
                MaleSocket maleSocket = (MaleSocket)WebRequest.this.getParent();
                try {
                    SymbolTable oldSymbolTable = this._conditionalNG.getSymbolTable();
                    this._conditionalNG.setSymbolTable(this._newSymbolTable);
                    if (!WebRequest.this._localVariableForResponseCode.isEmpty()) {
                        this._newSymbolTable.setValue(WebRequest.this._localVariableForResponseCode, this._responseCode);
                    }
                    if (!WebRequest.this._localVariableForReplyContent.isEmpty()) {
                        this._newSymbolTable.setValue(WebRequest.this._localVariableForReplyContent, this._reply);
                    }
                    if (!WebRequest.this._localVariableForCookies.isEmpty() && !this._cookies.isEmpty()) {
                        this._newSymbolTable.setValue(WebRequest.this._localVariableForCookies, this._cookies);
                    }
                    WebRequest.this._socket.execute();
                    this._conditionalNG.setSymbolTable(oldSymbolTable);
                }
                catch (JmriException e) {
                    if (e.getErrors() != null) {
                        maleSocket.handleError(WebRequest.this, rbx.getString("ExceptionExecuteMulti"), e.getErrors(), e, log);
                    } else {
                        maleSocket.handleError((Base)WebRequest.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                    }
                }
                catch (RuntimeException e) {
                    maleSocket.handleError((Base)WebRequest.this, Bundle.formatMessage(rbx.getString("ExceptionExecuteAction"), e.getLocalizedMessage()), e, log);
                }
            }
        }
    }

    public static class Parameter {
        public String _name;
        public SymbolTable.InitialValueType _type;
        public String _data;

        public Parameter(String name, SymbolTable.InitialValueType type, String data) {
            this._name = name;
            this._type = type;
            this._data = data;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(SymbolTable.InitialValueType dataType) {
            this._type = dataType;
        }

        public SymbolTable.InitialValueType getType() {
            return this._type;
        }

        public void setData(String valueData) {
            this._data = valueData;
        }

        public String getData() {
            return this._data;
        }
    }

    public static enum ReplyType {
        String(Bundle.getMessage("WebRequest_ReplyType_String")),
        ListOfStrings(Bundle.getMessage("WebRequest_ReplyType_ListOfStrings")),
        Bytes(Bundle.getMessage("WebRequest_ReplyType_Bytes"));

        private final String _text;

        private ReplyType(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }

    public static enum RequestMethodType {
        Get("WebRequest_GetPostType_Get", "GET"),
        Post("WebRequest_GetPostType_Post", "POST");

        private final String _text;
        private final String _identifier;

        private RequestMethodType(String text, String identifier) {
            this._text = Bundle.getMessage(text, identifier);
            this._identifier = identifier;
        }

        public String toString() {
            return this._text;
        }
    }
}

