/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.Memory;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.actions.ActionMemory;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectNamedBeanXml;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectTableXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMemoryXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionMemoryXml.class);

    @Override
    public Element store(Object o) {
        ActionMemory p = (ActionMemory)o;
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        Element element = new Element("ActionMemory");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        LogixNG_SelectNamedBeanXml<Memory> selectNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        element.addContent((Content)selectNamedBeanXml.store(p.getSelectNamedBean(), "namedBean"));
        LogixNG_SelectNamedBeanXml<Memory> selectOtherMemoryNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        element.addContent((Content)selectOtherMemoryNamedBeanXml.store(p.getSelectOtherMemoryNamedBean(), "otherMemoryNamedBean"));
        element.addContent((Content)new Element("memoryOperation").addContent(p.getMemoryOperation().name()));
        element.addContent((Content)new Element("otherConstant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("otherVariable").addContent(p.getOtherLocalVariable()));
        element.addContent((Content)new Element("otherFormula").addContent(p.getOtherFormula()));
        element.addContent((Content)selectTableXml.store(p.getSelectTable(), "table"));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionMemory h = new ActionMemory(sys, uname);
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        this.loadCommon(h, shared);
        LogixNG_SelectNamedBeanXml<Memory> selectNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        selectNamedBeanXml.load(shared.getChild("namedBean"), h.getSelectNamedBean());
        selectNamedBeanXml.loadLegacy(shared, h.getSelectNamedBean(), "memory");
        LogixNG_SelectNamedBeanXml<Memory> selectOtherMemoryNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        selectOtherMemoryNamedBeanXml.load(shared.getChild("otherMemoryNamedBean"), h.getSelectOtherMemoryNamedBean());
        selectOtherMemoryNamedBeanXml.loadLegacy(shared, h.getSelectOtherMemoryNamedBean(), "otherMemory", null, null, null, null);
        Element queryType = shared.getChild("memoryOperation");
        if (queryType != null) {
            try {
                h.setMemoryOperation(ActionMemory.MemoryOperation.valueOf(queryType.getTextTrim()));
            }
            catch (ParserException e) {
                log.error("cannot set memory operation: {}", (Object)queryType.getTextTrim(), (Object)e);
            }
        }
        try {
            Element elem = shared.getChild("otherConstant");
            if (elem != null) {
                h.setOtherConstantValue(elem.getTextTrim());
            }
            if ((elem = shared.getChild("otherTableCell")) != null) {
                boolean result = false;
                String ref = elem.getTextTrim();
                if (!ref.isEmpty()) {
                    String[] refParts = ref.substring(1).split("[\\[\\]]");
                    if (refParts.length == 3) {
                        String table = refParts[0];
                        String[] rowColumnParts = refParts[1].split(",");
                        if (rowColumnParts.length == 2) {
                            String row = rowColumnParts[0];
                            String column = rowColumnParts[1];
                            h.getSelectTable().setTableNameAddressing(NamedBeanAddressing.Direct);
                            if (table != null) {
                                NamedTable t = InstanceManager.getDefault(NamedTableManager.class).getNamedTable(table);
                                if (t != null) {
                                    h.getSelectTable().setTable(t);
                                } else {
                                    h.getSelectTable().removeTable();
                                }
                            }
                            h.getSelectTable().setTableRowAddressing(NamedBeanAddressing.Direct);
                            h.getSelectTable().setTableRowName(row);
                            h.getSelectTable().setTableColumnAddressing(NamedBeanAddressing.Direct);
                            h.getSelectTable().setTableColumnName(column);
                            result = true;
                        }
                    }
                    if (!result) {
                        throw new JmriConfigureXmlException("otherTableCell has invalid value: " + ref);
                    }
                }
            }
            if ((elem = shared.getChild("otherVariable")) != null) {
                h.setOtherLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("otherFormula")) != null) {
                h.setOtherFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        selectTableXml.load(shared.getChild("table"), h.getSelectTable());
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

