/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionSound;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectEnumXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionSoundXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionSoundXml.class);

    @Override
    public Element store(Object o) {
        ActionSound p = (ActionSound)o;
        Element element = new Element("ActionSound");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        LogixNG_SelectEnumXml<ActionSound.Operation> selectEnumXml = new LogixNG_SelectEnumXml<ActionSound.Operation>();
        element.addContent((Content)selectEnumXml.store(p.getSelectEnum(), "operation"));
        element.addContent((Content)new Element("soundAddressing").addContent(p.getSoundAddressing().name()));
        element.addContent((Content)new Element("sound").addContent(p.getSound()));
        element.addContent((Content)new Element("soundReference").addContent(p.getSoundReference()));
        element.addContent((Content)new Element("soundLocalVariable").addContent(p.getSoundLocalVariable()));
        element.addContent((Content)new Element("soundFormula").addContent(p.getSoundFormula()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionSound h = new ActionSound(sys, uname);
        this.loadCommon(h, shared);
        LogixNG_SelectEnumXml<ActionSound.Operation> selectEnumXml = new LogixNG_SelectEnumXml<ActionSound.Operation>();
        selectEnumXml.load(shared.getChild("operation"), h.getSelectEnum());
        selectEnumXml.loadLegacy(shared, h.getSelectEnum(), "operationAddressing", "operationType", "operationReference", "operationLocalVariable", "operationFormula");
        try {
            Element soundElement;
            Element elem = shared.getChild("soundAddressing");
            if (elem != null) {
                h.setSoundAddressing(NamedBeanAddressing.valueOf(elem.getTextTrim()));
            }
            if ((soundElement = shared.getChild("sound")) != null) {
                try {
                    h.setSound(soundElement.getText());
                }
                catch (NumberFormatException e) {
                    log.error("cannot parse sound: {}", (Object)soundElement.getTextTrim(), (Object)e);
                }
            }
            if ((elem = shared.getChild("soundReference")) != null) {
                h.setSoundReference(elem.getTextTrim());
            }
            if ((elem = shared.getChild("soundLocalVariable")) != null) {
                h.setSoundLocalVariable(elem.getTextTrim());
            }
            if ((elem = shared.getChild("soundFormula")) != null) {
                h.setSoundFormula(elem.getTextTrim());
            }
        }
        catch (ParserException e) {
            throw new JmriConfigureXmlException(e);
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

