/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import jmri.Block;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.Reporter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.actions.ActionTable;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectNamedBeanXml;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectTableXml;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTableXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ActionTableXml.class);

    @Override
    public Element store(Object o) {
        ActionTable p = (ActionTable)o;
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        Element element = new Element("ActionTable");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        LogixNG_SelectNamedBeanXml<Memory> selectMemoryNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        LogixNG_SelectNamedBeanXml<Block> selectBlockNamedBeanXml = new LogixNG_SelectNamedBeanXml<Block>();
        LogixNG_SelectNamedBeanXml<Reporter> selectReporterNamedBeanXml = new LogixNG_SelectNamedBeanXml<Reporter>();
        element.addContent((Content)selectTableXml.store(p.getSelectTableToSet(), "tableToSet"));
        element.addContent((Content)selectMemoryNamedBeanXml.store(p.getSelectMemoryNamedBean(), "memoryNamedBean"));
        element.addContent((Content)new Element("listenToMemory").addContent(p.getListenToMemory() ? "yes" : "no"));
        element.addContent((Content)selectBlockNamedBeanXml.store(p.getSelectBlockNamedBean(), "blockNamedBean"));
        element.addContent((Content)new Element("listenToBlock").addContent(p.getListenToBlock() ? "yes" : "no"));
        element.addContent((Content)selectReporterNamedBeanXml.store(p.getSelectReporterNamedBean(), "reporterNamedBean"));
        element.addContent((Content)new Element("listenToReporter").addContent(p.getListenToReporter() ? "yes" : "no"));
        element.addContent((Content)new Element("variableOperation").addContent(p.getVariableOperation().name()));
        element.addContent((Content)new Element("constantType").addContent(p.getConstantType().name()));
        element.addContent((Content)new Element("constant").addContent(p.getConstantValue()));
        element.addContent((Content)new Element("otherVariable").addContent(p.getOtherLocalVariable()));
        element.addContent((Content)new Element("reference").addContent(p.getReference()));
        element.addContent((Content)new Element("formula").addContent(p.getFormula()));
        element.addContent((Content)selectTableXml.store(p.getSelectTable(), "table"));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element formula;
        Element reference;
        Element otherTableCell;
        Element constant;
        Element constantType;
        Element queryType;
        Element listenToReporterElem;
        Element listenToBlockElem;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ActionTable h = new ActionTable(sys, uname);
        LogixNG_SelectTableXml selectTableXml = new LogixNG_SelectTableXml();
        this.loadCommon(h, shared);
        LogixNG_SelectNamedBeanXml<Memory> selectMemoryNamedBeanXml = new LogixNG_SelectNamedBeanXml<Memory>();
        LogixNG_SelectNamedBeanXml<Block> selectBlockNamedBeanXml = new LogixNG_SelectNamedBeanXml<Block>();
        LogixNG_SelectNamedBeanXml<Reporter> selectReporterNamedBeanXml = new LogixNG_SelectNamedBeanXml<Reporter>();
        selectTableXml.load(shared.getChild("tableToSet"), h.getSelectTableToSet());
        selectMemoryNamedBeanXml.load(shared.getChild("memoryNamedBean"), h.getSelectMemoryNamedBean());
        selectBlockNamedBeanXml.load(shared.getChild("blockNamedBean"), h.getSelectBlockNamedBean());
        selectReporterNamedBeanXml.load(shared.getChild("reporterNamedBean"), h.getSelectReporterNamedBean());
        Element listenToMemoryElem = shared.getChild("listenToMemory");
        if (listenToMemoryElem != null) {
            h.setListenToMemory("yes".equals(listenToMemoryElem.getTextTrim()));
        }
        if ((listenToBlockElem = shared.getChild("listenToBlock")) != null) {
            h.setListenToBlock("yes".equals(listenToBlockElem.getTextTrim()));
        }
        if ((listenToReporterElem = shared.getChild("listenToReporter")) != null) {
            h.setListenToReporter("yes".equals(listenToReporterElem.getTextTrim()));
        }
        if ((queryType = shared.getChild("variableOperation")) != null) {
            try {
                h.setVariableOperation(ActionTable.VariableOperation.valueOf(queryType.getTextTrim()));
            }
            catch (ParserException e) {
                log.error("cannot set variable operation: {}", (Object)queryType.getTextTrim(), (Object)e);
            }
        }
        if ((constantType = shared.getChild("constantType")) != null) {
            h.setConstantType(ActionTable.ConstantType.valueOf(constantType.getTextTrim()));
        }
        if ((constant = shared.getChild("constant")) != null) {
            h.setConstantValue(constant.getTextTrim());
        }
        if ((otherTableCell = shared.getChild("otherTableCell")) != null) {
            boolean result = false;
            String ref = otherTableCell.getTextTrim();
            if (!ref.isEmpty()) {
                String[] refParts = ref.substring(1).split("[\\[\\]]");
                if (refParts.length == 3) {
                    String table = refParts[0];
                    String[] rowColumnParts = refParts[1].split(",");
                    if (rowColumnParts.length == 2) {
                        String row = rowColumnParts[0];
                        String column = rowColumnParts[1];
                        h.getSelectTable().setTableNameAddressing(NamedBeanAddressing.Direct);
                        if (table != null) {
                            NamedTable t = InstanceManager.getDefault(NamedTableManager.class).getNamedTable(table);
                            if (t != null) {
                                h.getSelectTable().setTable(t);
                            } else {
                                h.getSelectTable().removeTable();
                            }
                        }
                        h.getSelectTable().setTableRowAddressing(NamedBeanAddressing.Direct);
                        h.getSelectTable().setTableRowName(row);
                        h.getSelectTable().setTableColumnAddressing(NamedBeanAddressing.Direct);
                        h.getSelectTable().setTableColumnName(column);
                        result = true;
                    }
                }
                if (!result) {
                    throw new JmriConfigureXmlException("otherTableCell has invalid value: " + ref);
                }
            }
        }
        selectTableXml.load(shared.getChild("table"), h.getSelectTable());
        Element otherVariable = shared.getChild("otherVariable");
        if (otherVariable != null) {
            h.setOtherLocalVariable(otherVariable.getTextTrim());
        }
        if ((reference = shared.getChild("reference")) != null) {
            h.setReference(reference.getTextTrim());
        }
        if ((formula = shared.getChild("formula")) != null) {
            try {
                h.setFormula(formula.getTextTrim());
            }
            catch (ParserException e) {
                log.error("cannot set data: {}", (Object)formula.getTextTrim(), (Object)e);
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

