/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import java.util.Set;
import jmri.InstanceManager;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ShowDialog;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDialogXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ShowDialogXml.class);

    @Override
    public Element store(Object o) {
        ShowDialog p = (ShowDialog)o;
        Element element = new Element("ShowDialog");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("ValidateSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getValidateSocket().getName()));
        MaleSocket socket = p.getValidateSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getValidateSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        e2 = new Element("ExecuteSocket");
        e2.addContent((Content)new Element("socketName").addContent(p.getExecuteSocket().getName()));
        socket = p.getExecuteSocket().getConnectedSocket();
        socketSystemName = socket != null ? socket.getSystemName() : p.getExecuteSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        Element buttons = new Element("Buttons");
        for (ShowDialog.Button button : ShowDialog.Button.values()) {
            if (!p.getEnabledButtons().contains((Object)button)) continue;
            buttons.addContent((Content)new Element("name").addContent(button.name()));
        }
        element.addContent((Content)buttons);
        element.addContent((Content)new Element("formatType").addContent(p.getFormatType().name()));
        element.addContent((Content)new Element("format").addContent(p.getFormat()));
        element.addContent((Content)new Element("localVariableForSelectedButton").addContent(p.getLocalVariableForSelectedButton()));
        element.addContent((Content)new Element("localVariableForInputString").addContent(p.getLocalVariableForInputString()));
        element.addContent((Content)new Element("modal").addContent(p.getModal() ? "yes" : "no"));
        element.addContent((Content)new Element("multiLine").addContent(p.getMultiLine() ? "yes" : "no"));
        Element parameters = new Element("DataList");
        for (ShowDialog.Data data : p.getDataList()) {
            Element elementParameter = new Element("Data");
            elementParameter.addContent((Content)new Element("type").addContent(data.getDataType().name()));
            elementParameter.addContent((Content)new Element("data").addContent(data.getData()));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element executeSocket;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        ShowDialog h = new ShowDialog(sys, uname);
        this.loadCommon(h, shared);
        Element validateSocket = shared.getChild("ValidateSocket");
        if (validateSocket != null) {
            Element socketNameElement = validateSocket.getChild("socketName");
            String socketName = socketNameElement.getTextTrim();
            Element socketSystemNameElement = validateSocket.getChild("systemName");
            String socketSystemName = null;
            if (socketSystemNameElement != null) {
                socketSystemName = socketSystemNameElement.getTextTrim();
            }
            h.getValidateSocket().setName(socketName);
            h.setValidateSocketSystemName(socketSystemName);
        }
        if ((executeSocket = shared.getChild("ExecuteSocket")) == null && shared.getChild("Socket") != null) {
            executeSocket = shared.getChild("Socket");
        }
        if (executeSocket != null) {
            Element socketNameElement = executeSocket.getChild("socketName");
            String socketName = socketNameElement.getTextTrim();
            Element socketSystemNameElement = executeSocket.getChild("systemName");
            String socketSystemName = null;
            if (socketSystemNameElement != null) {
                socketSystemName = socketSystemNameElement.getTextTrim();
            }
            h.getExecuteSocket().setName(socketName);
            h.setExecuteSocketSystemName(socketSystemName);
        }
        List buttons = shared.getChild("Buttons").getChildren();
        Set<ShowDialog.Button> enabledButtons = h.getEnabledButtons();
        enabledButtons.clear();
        for (Element e : buttons) {
            enabledButtons.add(ShowDialog.Button.valueOf(e.getTextTrim()));
        }
        Element elem = shared.getChild("formatType");
        h.setFormatType(elem != null ? ShowDialog.FormatType.valueOf(elem.getTextTrim()) : ShowDialog.FormatType.OnlyText);
        elem = shared.getChild("format");
        h.setFormat(elem != null ? elem.getValue() : "");
        elem = shared.getChild("localVariableForSelectedButton");
        h.setLocalVariableForSelectedButton(elem != null ? elem.getValue() : "");
        elem = shared.getChild("localVariable");
        if (elem != null) {
            h.setLocalVariableForSelectedButton(elem.getValue());
        }
        h.setLocalVariableForInputString((elem = shared.getChild("localVariableForInputString")) != null ? elem.getValue() : "");
        elem = shared.getChild("modal");
        h.setModal(elem != null ? elem.getTextTrim().equals("yes") : false);
        elem = shared.getChild("multiLine");
        h.setMultiLine(elem != null ? elem.getTextTrim().equals("yes") : false);
        List dataList = shared.getChild("DataList").getChildren();
        log.debug("Found {} dataList", (Object)dataList.size());
        for (Element e : dataList) {
            Element elementName;
            ShowDialog.DataType type = ShowDialog.DataType.LocalVariable;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = ShowDialog.DataType.valueOf(elementType.getTextTrim());
            }
            if ((elementName = e.getChild("data")) == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            try {
                h.getDataList().add(new ShowDialog.Data(type, elementName.getTextTrim()));
            }
            catch (ParserException ex) {
                log.warn("Could not add {} to data list : {}", (Object)elementName.getTextTrim(), (Object)ex.getMessage());
            }
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

