/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.WebRequest;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectEnumXml;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectStringXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(WebRequestXml.class);

    @Override
    public Element store(Object o) {
        WebRequest p = (WebRequest)o;
        Element element = new Element("WebRequest");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        Element e2 = new Element("Socket");
        e2.addContent((Content)new Element("socketName").addContent(p.getChild(0).getName()));
        MaleSocket socket = p.getSocket().getConnectedSocket();
        String socketSystemName = socket != null ? socket.getSystemName() : p.getSocketSystemName();
        if (socketSystemName != null) {
            e2.addContent((Content)new Element("systemName").addContent(socketSystemName));
        }
        element.addContent((Content)e2);
        LogixNG_SelectEnumXml<WebRequest.RequestMethodType> selectRequestMethodXml = new LogixNG_SelectEnumXml<WebRequest.RequestMethodType>();
        LogixNG_SelectStringXml selectUrlXml = new LogixNG_SelectStringXml();
        LogixNG_SelectStringXml selectUserAgentXml = new LogixNG_SelectStringXml();
        element.addContent((Content)selectRequestMethodXml.store(p.getSelectRequestMethod(), "requestMethod"));
        element.addContent((Content)selectUrlXml.store(p.getSelectUrl(), "url"));
        element.addContent((Content)selectUserAgentXml.store(p.getSelectUserAgent(), "userAgent"));
        element.addContent((Content)new Element("localVariableForResponseCode").addContent(p.getLocalVariableForResponseCode()));
        element.addContent((Content)new Element("localVariableForReplyContent").addContent(p.getLocalVariableForReplyContent()));
        element.addContent((Content)new Element("localVariableForCookies").addContent(p.getLocalVariableForCookies()));
        Element parameters = new Element("Parameters");
        for (WebRequest.Parameter parameter : p.getParameters()) {
            Element elementParameter = new Element("Parameter");
            elementParameter.addContent((Content)new Element("name").addContent(parameter.getName()));
            elementParameter.addContent((Content)new Element("type").addContent(parameter.getType().name()));
            elementParameter.addContent((Content)new Element("data").addContent(parameter.getData()));
            parameters.addContent((Content)elementParameter);
        }
        element.addContent((Content)parameters);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element socketNameElement = shared.getChild("Socket").getChild("socketName");
        String socketName = socketNameElement.getTextTrim();
        Element socketSystemNameElement = shared.getChild("Socket").getChild("systemName");
        String socketSystemName = null;
        if (socketSystemNameElement != null) {
            socketSystemName = socketSystemNameElement.getTextTrim();
        }
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        WebRequest h = new WebRequest(sys, uname);
        this.loadCommon(h, shared);
        h.getChild(0).setName(socketName);
        h.setSocketSystemName(socketSystemName);
        LogixNG_SelectEnumXml<WebRequest.RequestMethodType> selectRequestMethodXml = new LogixNG_SelectEnumXml<WebRequest.RequestMethodType>();
        LogixNG_SelectStringXml selectUrlXml = new LogixNG_SelectStringXml();
        LogixNG_SelectStringXml selectUserAgentXml = new LogixNG_SelectStringXml();
        selectRequestMethodXml.load(shared.getChild("requestMethod"), h.getSelectRequestMethod());
        selectUrlXml.load(shared.getChild("url"), h.getSelectUrl());
        selectUserAgentXml.load(shared.getChild("userAgent"), h.getSelectUserAgent());
        Element elem = shared.getChild("localVariableForResponseCode");
        if (elem != null) {
            h.setLocalVariableForResponseCode(elem.getTextTrim());
        }
        if ((elem = shared.getChild("localVariableForReplyContent")) != null) {
            h.setLocalVariableForReplyContent(elem.getTextTrim());
        }
        if ((elem = shared.getChild("localVariableForCookies")) != null) {
            h.setLocalVariableForCookies(elem.getTextTrim());
        }
        List parameters = shared.getChild("Parameters").getChildren();
        log.debug("Found {} dataList", (Object)parameters.size());
        for (Element e : parameters) {
            Element elementData;
            Element elementName = e.getChild("name");
            if (elementName == null) {
                throw new IllegalArgumentException("Element 'name' does not exists");
            }
            SymbolTable.InitialValueType type = SymbolTable.InitialValueType.LocalVariable;
            Element elementType = e.getChild("type");
            if (elementType != null) {
                type = SymbolTable.InitialValueType.valueOf(elementType.getTextTrim());
            }
            if ((elementData = e.getChild("data")) == null) {
                throw new IllegalArgumentException("Element 'data' does not exists");
            }
            h.getParameters().add(new WebRequest.Parameter(elementName.getTextTrim(), type, elementData.getTextTrim()));
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

