/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.BaseManager;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalAction;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.SymbolTable;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.implementation.DefaultSymbolTable;
import jmri.jmrit.logixng.swing.AbstractSwingConfigurator;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDigitalActionSwing
extends AbstractSwingConfigurator {
    protected JPanel panel;
    private static final Logger log = LoggerFactory.getLogger(AbstractDigitalActionSwing.class);

    @Override
    public String getExecuteEvaluateMenuText() {
        return Bundle.getMessage("MenuText_ExecuteEvaluate");
    }

    @Override
    public void executeEvaluate(@Nonnull Base object) {
        ConditionalNG conditionalNG = object.getConditionalNG();
        if (conditionalNG == null) {
            throw new RuntimeException("Not supported yet");
        }
        DefaultSymbolTable symbolTable = new DefaultSymbolTable();
        this.getAllSymbols(object, symbolTable);
        conditionalNG.getCurrentThread().runOnLogixNGEventually(() -> {
            SymbolTable oldSymbolTable = conditionalNG.getSymbolTable();
            try {
                conditionalNG.setCurrentConditionalNG(conditionalNG);
                conditionalNG.setSymbolTable(symbolTable);
                ((DigitalAction)object).execute();
                ThreadingUtil.runOnGUIEventually(() -> JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExecuteEvaluate_ActionCompleted"), Bundle.getMessage("ExecuteEvaluate_Title"), -1));
            }
            catch (RuntimeException | JmriException e) {
                log.warn("ConditionalNG {} got an exception during execute: {}", new Object[]{conditionalNG.getSystemName(), e, e});
            }
            conditionalNG.setSymbolTable(oldSymbolTable);
        });
    }

    @Override
    public BaseManager<? extends NamedBean> getManager() {
        return InstanceManager.getDefault(DigitalActionManager.class);
    }

    @Override
    public JPanel getConfigPanel(@Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        this.createPanel(null, buttonPanel);
        return this.panel;
    }

    @Override
    public JPanel getConfigPanel(@Nonnull Base object, @Nonnull JPanel buttonPanel) throws IllegalArgumentException {
        this.createPanel(object, buttonPanel);
        return this.panel;
    }

    protected abstract void createPanel(@CheckForNull Base var1, @Nonnull JPanel var2);

    @Override
    public String getExampleSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getSystemNamePrefix() + "DA10";
    }

    @Override
    public String getAutoSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getAutoSystemName();
    }
}

