/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.ActionBlock;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectNamedBeanSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectStringSwing;

public class ActionBlockSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectNamedBeanSwing<Block> _selectNamedBeanSwing;
    private LogixNG_SelectEnumSwing<ActionBlock.DirectOperation> _selectOperationSwing;
    private LogixNG_SelectStringSwing _selectBlockValueSwing;

    public ActionBlockSwing() {
    }

    public ActionBlockSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        JPanel tabbedPaneBlockValue;
        JPanel tabbedPaneOperation;
        JPanel tabbedPaneNamedBean;
        ActionBlock action = (ActionBlock)object;
        this._selectNamedBeanSwing = new LogixNG_SelectNamedBeanSwing(InstanceManager.getDefault(BlockManager.class), this.getJDialog(), this);
        this._selectOperationSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this._selectBlockValueSwing = new LogixNG_SelectStringSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        if (action != null) {
            tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(action.getSelectNamedBean());
            tabbedPaneOperation = this._selectOperationSwing.createPanel(action.getSelectEnum(), ActionBlock.DirectOperation.values());
            tabbedPaneBlockValue = this._selectBlockValueSwing.createPanel(action.getSelectBlockValue());
        } else {
            tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(null);
            tabbedPaneOperation = this._selectOperationSwing.createPanel(null, ActionBlock.DirectOperation.values());
            tabbedPaneBlockValue = this._selectBlockValueSwing.createPanel(null);
        }
        this._selectOperationSwing.addAddressingListener(evt -> this.setDataPanelState());
        this._selectOperationSwing.addEnumListener(evt -> this.setDataPanelState());
        this.setDataPanelState();
        JComponent[] components = new JComponent[]{tabbedPaneNamedBean, tabbedPaneOperation, tabbedPaneBlockValue};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionBlock_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setDataPanelState() {
        boolean newState = this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionBlock.DirectOperation.SetValue);
        this._selectBlockValueSwing.setEnabled(newState);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionBlock action = new ActionBlock("IQDA2", null);
        this._selectNamedBeanSwing.validate(action.getSelectNamedBean(), errorMessages);
        this._selectOperationSwing.validate(action.getSelectEnum(), errorMessages);
        this._selectBlockValueSwing.validate(action.getSelectBlockValue(), errorMessages);
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionBlock action = new ActionBlock(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof ActionBlock)) {
            throw new IllegalArgumentException("object must be an ActionBlock but is a: " + object.getClass().getName());
        }
        ActionBlock action = (ActionBlock)object;
        this._selectNamedBeanSwing.updateObject(action.getSelectNamedBean());
        this._selectOperationSwing.updateObject(action.getSelectEnum());
        this._selectBlockValueSwing.updateObject(action.getSelectBlockValue());
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionBlock_Short");
    }

    @Override
    public void dispose() {
        this._selectNamedBeanSwing.dispose();
        this._selectOperationSwing.dispose();
        this._selectBlockValueSwing.dispose();
    }
}

