/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionLight;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectNamedBeanSwing;

public class ActionLightSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectNamedBeanSwing<Light> _selectNamedBeanSwing;
    private LogixNG_SelectEnumSwing<ActionLight.LightState> _selectEnumSwing;
    private JTabbedPane _tabbedPaneData;
    private JPanel _panelDataDirect;
    private JPanel _panelDataReference;
    private JPanel _panelDataLocalVariable;
    private JPanel _panelDataFormula;
    private JTextField _lightDataDirectTextField;
    private JTextField _lightDataReferenceTextField;
    private JTextField _lightDataLocalVariableTextField;
    private JTextField _lightDataFormulaTextField;

    public ActionLightSwing() {
    }

    public ActionLightSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        JPanel _tabbedPaneEnum;
        JPanel _tabbedPaneNamedBean;
        ActionLight action = (ActionLight)object;
        this._selectNamedBeanSwing = new LogixNG_SelectNamedBeanSwing(InstanceManager.getDefault(LightManager.class), this.getJDialog(), this);
        this._selectEnumSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        if (action != null) {
            _tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(action.getSelectNamedBean());
            _tabbedPaneEnum = this._selectEnumSwing.createPanel(action.getSelectEnum(), ActionLight.LightState.values());
        } else {
            _tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(null);
            _tabbedPaneEnum = this._selectEnumSwing.createPanel(null, ActionLight.LightState.values());
        }
        this._selectEnumSwing.addEnumListener(e -> this.setDataPanelState());
        this._tabbedPaneData = new JTabbedPane();
        this._panelDataDirect = new JPanel();
        this._panelDataReference = new JPanel();
        this._panelDataLocalVariable = new JPanel();
        this._panelDataFormula = new JPanel();
        this._tabbedPaneData.addTab(NamedBeanAddressing.Direct.toString(), this._panelDataDirect);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Reference.toString(), this._panelDataReference);
        this._tabbedPaneData.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDataLocalVariable);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Formula.toString(), this._panelDataFormula);
        this._lightDataDirectTextField = new JTextField();
        this._lightDataDirectTextField.setColumns(30);
        this._panelDataDirect.add(this._lightDataDirectTextField);
        this._lightDataReferenceTextField = new JTextField();
        this._lightDataReferenceTextField.setColumns(30);
        this._panelDataReference.add(this._lightDataReferenceTextField);
        this._lightDataLocalVariableTextField = new JTextField();
        this._lightDataLocalVariableTextField.setColumns(30);
        this._panelDataLocalVariable.add(this._lightDataLocalVariableTextField);
        this._lightDataFormulaTextField = new JTextField();
        this._lightDataFormulaTextField.setColumns(30);
        this._panelDataFormula.add(this._lightDataFormulaTextField);
        this.setDataPanelState();
        if (action != null) {
            switch (action.getDataAddressing()) {
                case Direct: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDataAddressing().name());
                }
            }
            this._lightDataReferenceTextField.setText(action.getDataReference());
            this._lightDataLocalVariableTextField.setText(action.getDataLocalVariable());
            this._lightDataFormulaTextField.setText(action.getDataFormula());
            this._lightDataDirectTextField.setText(Integer.toString(action.getLightValue()));
            this.setDataPanelState();
        }
        JComponent[] components = new JComponent[]{_tabbedPaneNamedBean, _tabbedPaneEnum, this._tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionLight_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setDataPanelState() {
        boolean newState = this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Intensity) || this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Interval);
        this._tabbedPaneData.setEnabled(newState);
        this._lightDataDirectTextField.setEnabled(newState);
        this._lightDataReferenceTextField.setEnabled(newState);
        this._lightDataLocalVariableTextField.setEnabled(newState);
        this._lightDataFormulaTextField.setEnabled(newState);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        block20: {
            ActionLight action = new ActionLight("IQDA1", null);
            this._selectNamedBeanSwing.validate(action.getSelectNamedBean(), errorMessages);
            this._selectEnumSwing.validate(action.getSelectEnum(), errorMessages);
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataReference(this._lightDataReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                action.setDataFormula(this._lightDataFormulaTextField.getText());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    break block20;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    break block20;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    break block20;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    break block20;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
                return false;
            }
        }
        if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
            int value;
            boolean result;
            if (this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Intensity)) {
                result = true;
                try {
                    value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    if (value < 0 || value > 100) {
                        result = false;
                    }
                }
                catch (NumberFormatException ex) {
                    result = false;
                }
                if (!result) {
                    errorMessages.add(Bundle.getMessage("Light_Error_Intensity"));
                    return false;
                }
            }
            if (this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Interval)) {
                result = true;
                try {
                    value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    if (value < 0) {
                        result = false;
                    }
                }
                catch (NumberFormatException ex) {
                    result = false;
                }
                if (!result) {
                    errorMessages.add(Bundle.getMessage("Light_Error_Interval"));
                    return false;
                }
            }
        }
        return errorMessages.isEmpty();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionLight action = new ActionLight(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block9: {
            if (!(object instanceof ActionLight)) {
                throw new IllegalArgumentException("object must be an ActionLight but is a: " + object.getClass().getName());
            }
            ActionLight action = (ActionLight)object;
            this._selectNamedBeanSwing.updateObject(action.getSelectNamedBean());
            this._selectEnumSwing.updateObject(action.getSelectEnum());
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    int value;
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    if (!this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Intensity) && !this._selectEnumSwing.isEnumSelectedOrIndirectAddressing(ActionLight.LightState.Interval)) break block9;
                    try {
                        value = Integer.parseInt(this._lightDataDirectTextField.getText());
                    }
                    catch (NumberFormatException ex) {
                        value = 0;
                    }
                    action.setLightValue(value);
                    break block9;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    action.setDataReference(this._lightDataReferenceTextField.getText());
                    break block9;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDataLocalVariable(this._lightDataLocalVariableTextField.getText());
                    break block9;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    action.setDataFormula(this._lightDataFormulaTextField.getText());
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneData has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Light_Short");
    }

    @Override
    public void dispose() {
        this._selectNamedBeanSwing.dispose();
        this._selectEnumSwing.dispose();
    }
}

