/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionOBlock;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectNamedBeanSwing;
import jmri.util.swing.BeanSelectPanel;

public class ActionOBlockSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectNamedBeanSwing<OBlock> _selectNamedBeanSwing;
    private LogixNG_SelectEnumSwing<ActionOBlock.DirectOperation> _selectOperationSwing;
    private JTabbedPane _tabbedPaneData;
    private JPanel _panelDataDirect;
    private JPanel _panelDataReference;
    private JPanel _panelDataLocalVariable;
    private JPanel _panelDataFormula;
    private JTextField _oblockDataDirectTextField;
    private JTextField _oblockDataReferenceTextField;
    private JTextField _oblockDataLocalVariableTextField;
    private JTextField _oblockDataFormulaTextField;
    private BeanSelectPanel<Memory> _panelMemoryBean;
    private JPanel _memoryPanel;
    private JPanel _valuePanel;

    public ActionOBlockSwing() {
    }

    public ActionOBlockSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        JPanel _tabbedPaneOperation;
        JPanel _tabbedPaneNamedBean;
        ActionOBlock action = (ActionOBlock)object;
        this._selectNamedBeanSwing = new LogixNG_SelectNamedBeanSwing(InstanceManager.getDefault(OBlockManager.class), this.getJDialog(), this);
        this._selectOperationSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        this._memoryPanel = new JPanel();
        this._valuePanel = new JPanel();
        if (action != null) {
            _tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(action.getSelectNamedBean());
            _tabbedPaneOperation = this._selectOperationSwing.createPanel(action.getSelectEnum(), ActionOBlock.DirectOperation.values());
        } else {
            _tabbedPaneNamedBean = this._selectNamedBeanSwing.createPanel(null);
            _tabbedPaneOperation = this._selectOperationSwing.createPanel(null, ActionOBlock.DirectOperation.values());
        }
        this._tabbedPaneData = new JTabbedPane();
        this._panelDataDirect = new JPanel();
        this._panelDataDirect.setLayout(new BoxLayout(this._panelDataDirect, 1));
        this._panelDataReference = new JPanel();
        this._panelDataLocalVariable = new JPanel();
        this._panelDataFormula = new JPanel();
        this._tabbedPaneData.addTab(NamedBeanAddressing.Direct.toString(), this._panelDataDirect);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Reference.toString(), this._panelDataReference);
        this._tabbedPaneData.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDataLocalVariable);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Formula.toString(), this._panelDataFormula);
        this._oblockDataDirectTextField = new JTextField();
        this._oblockDataDirectTextField.setColumns(30);
        this._valuePanel.add(this._oblockDataDirectTextField);
        this._panelDataDirect.add(this._valuePanel);
        this._panelMemoryBean = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._memoryPanel.add(this._panelMemoryBean);
        this._panelDataDirect.add(this._panelMemoryBean);
        this._oblockDataReferenceTextField = new JTextField();
        this._oblockDataReferenceTextField.setColumns(30);
        this._panelDataReference.add(this._oblockDataReferenceTextField);
        this._oblockDataLocalVariableTextField = new JTextField();
        this._oblockDataLocalVariableTextField.setColumns(30);
        this._panelDataLocalVariable.add(this._oblockDataLocalVariableTextField);
        this._oblockDataFormulaTextField = new JTextField();
        this._oblockDataFormulaTextField.setColumns(30);
        this._panelDataFormula.add(this._oblockDataFormulaTextField);
        this._valuePanel.setVisible(false);
        this._memoryPanel.setVisible(false);
        if (action != null) {
            LogixNG_SelectEnum<ActionOBlock.DirectOperation> selectEnum;
            switch (action.getDataAddressing()) {
                case Direct: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDataAddressing().name());
                }
            }
            this._oblockDataReferenceTextField.setText(action.getDataReference());
            this._oblockDataLocalVariableTextField.setText(action.getDataLocalVariable());
            this._oblockDataFormulaTextField.setText(action.getDataFormula());
            this._oblockDataDirectTextField.setText(action.getOBlockValue());
            if (action.getSelectMemoryNamedBean().getNamedBean() != null) {
                this._panelMemoryBean.setDefaultNamedBean(action.getSelectMemoryNamedBean().getNamedBean().getBean());
            }
            if ((selectEnum = action.getSelectEnum()).getEnum() != null) {
                switch (selectEnum.getEnum()) {
                    case GetBlockWarrant: 
                    case GetBlockValue: {
                        this._panelMemoryBean.setVisible(true);
                        break;
                    }
                    case SetValue: {
                        this._valuePanel.setVisible(true);
                        break;
                    }
                }
            }
        }
        this.setDataPanelState();
        this._selectOperationSwing.addAddressingListener(evt -> this.setDataPanelState());
        this._selectOperationSwing.addEnumListener(evt -> this.setDataPanelState());
        JComponent[] components = new JComponent[]{_tabbedPaneNamedBean, _tabbedPaneOperation, this._tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionOBlock_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    private void setDataPanelState() {
        this._valuePanel.setVisible(false);
        this._panelMemoryBean.setVisible(false);
        boolean newState = false;
        if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.SetValue)) {
            this._valuePanel.setVisible(true);
            newState = true;
        } else if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockWarrant) || this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockValue)) {
            this._panelMemoryBean.setVisible(true);
            newState = true;
        }
        this._tabbedPaneData.setEnabled(newState);
        this._oblockDataReferenceTextField.setEnabled(newState);
        this._oblockDataLocalVariableTextField.setEnabled(newState);
        this._oblockDataFormulaTextField.setEnabled(newState);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionOBlock action = new ActionOBlock("IQDA1", null);
        this._selectNamedBeanSwing.validate(action.getSelectNamedBean(), errorMessages);
        this._selectOperationSwing.validate(action.getSelectEnum(), errorMessages);
        this.validateDataSection(errorMessages);
        return errorMessages.isEmpty();
    }

    private void validateDataSection(List<String> errorMessages) {
        block14: {
            ActionOBlock action = new ActionOBlock("IQDA3", null);
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataReference(this._oblockDataReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return;
            }
            try {
                action.setDataFormula(this._oblockDataFormulaTextField.getText());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    break block14;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    break block14;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    break block14;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    break block14;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
            if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockWarrant) || this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockValue)) {
                if (this._panelMemoryBean.isEmpty() || this._panelMemoryBean.getNamedBean() == null) {
                    errorMessages.add(Bundle.getMessage("ActionWarrant_ErrorMemory"));
                }
            } else if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.SetValue) && this._oblockDataDirectTextField.getText().isEmpty()) {
                errorMessages.add(Bundle.getMessage("ActionWarrant_ErrorValue"));
            }
        }
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionOBlock action = new ActionOBlock(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block12: {
            if (!(object instanceof ActionOBlock)) {
                throw new IllegalArgumentException("object must be an ActionOBlock but is a: " + object.getClass().getName());
            }
            ActionOBlock action = (ActionOBlock)object;
            this._selectNamedBeanSwing.updateObject(action.getSelectNamedBean());
            try {
                this._selectOperationSwing.updateObject(action.getSelectEnum());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.SetValue)) {
                        action.setOBlockValue(this._oblockDataDirectTextField.getText());
                    } else if (this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockWarrant) || this._selectOperationSwing.isEnumSelectedOrIndirectAddressing(ActionOBlock.DirectOperation.GetBlockValue)) {
                        Memory memory = this._panelMemoryBean.getNamedBean();
                        if (memory != null) {
                            NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
                            action.getSelectMemoryNamedBean().setNamedBean((Memory)((Object)handle));
                        } else {
                            action.getSelectMemoryNamedBean().removeNamedBean();
                        }
                    }
                    break block12;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    action.setDataReference(this._oblockDataReferenceTextField.getText());
                    break block12;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDataLocalVariable(this._oblockDataLocalVariableTextField.getText());
                    break block12;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    action.setDataFormula(this._oblockDataFormulaTextField.getText());
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPaneBlock has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionOBlock_Short");
    }

    @Override
    public void dispose() {
        this._selectNamedBeanSwing.dispose();
        this._selectOperationSwing.dispose();
    }
}

