/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.actions.swing;

import java.util.List;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.actions.ActionReporter;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.actions.swing.Bundle;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectNamedBeanSwing;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReporterSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectNamedBeanSwing<Reporter> _selectNamedBeanSwing;
    private JPanel _panelReporterValue;
    private JComboBox<ActionReporter.ReporterValue> _reporterValueComboBox;
    private JTabbedPane _tabbedPaneData;
    private JPanel _panelDataDirect;
    private JPanel _panelDataReference;
    private JPanel _panelDataLocalVariable;
    private JPanel _panelDataFormula;
    private BeanSelectPanel<Memory> _memorySelectPanel;
    private JTextField _dataReferenceTextField;
    private JTextField _dataLocalVariableTextField;
    private JTextField _dataFormulaTextField;
    private static final Logger log = LoggerFactory.getLogger(ActionReporterSwing.class);

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        ActionReporter action = (ActionReporter)object;
        this._selectNamedBeanSwing = new LogixNG_SelectNamedBeanSwing(InstanceManager.getDefault(ReporterManager.class), this.getJDialog(), this);
        this.panel = new JPanel();
        this._panelReporterValue = new JPanel();
        this._reporterValueComboBox = new JComboBox();
        for (ActionReporter.ReporterValue e : ActionReporter.ReporterValue.values()) {
            this._reporterValueComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._reporterValueComboBox);
        this._panelReporterValue.add(this._reporterValueComboBox);
        JPanel _tabbedPaneNamedBean = action != null ? this._selectNamedBeanSwing.createPanel(action.getSelectNamedBean()) : this._selectNamedBeanSwing.createPanel(null);
        this._tabbedPaneData = new JTabbedPane();
        this._panelDataDirect = new JPanel();
        this._panelDataReference = new JPanel();
        this._panelDataLocalVariable = new JPanel();
        this._panelDataFormula = new JPanel();
        this._tabbedPaneData.addTab(NamedBeanAddressing.Direct.toString(), this._panelDataDirect);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Reference.toString(), this._panelDataReference);
        this._tabbedPaneData.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelDataLocalVariable);
        this._tabbedPaneData.addTab(NamedBeanAddressing.Formula.toString(), this._panelDataFormula);
        this._memorySelectPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._panelDataDirect.add(this._memorySelectPanel);
        this._dataReferenceTextField = new JTextField();
        this._dataReferenceTextField.setColumns(30);
        this._panelDataReference.add(this._dataReferenceTextField);
        this._dataLocalVariableTextField = new JTextField();
        this._dataLocalVariableTextField.setColumns(30);
        this._panelDataLocalVariable.add(this._dataLocalVariableTextField);
        this._dataFormulaTextField = new JTextField();
        this._dataFormulaTextField.setColumns(30);
        this._panelDataFormula.add(this._dataFormulaTextField);
        if (action != null) {
            this._reporterValueComboBox.setSelectedItem((Object)action.getReporterValue());
            switch (action.getDataAddressing()) {
                case Direct: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataReference);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPaneData.setSelectedComponent(this._panelDataFormula);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + action.getDataAddressing().name());
                }
            }
            if (action.getSelectMemoryNamedBean().getNamedBean() != null) {
                this._memorySelectPanel.setDefaultNamedBean(action.getSelectMemoryNamedBean().getNamedBean().getBean());
            }
            this._dataReferenceTextField.setText(action.getDataReference());
            this._dataLocalVariableTextField.setText(action.getDataLocalVariable());
            this._dataFormulaTextField.setText(action.getDataFormula());
        }
        JComponent[] components = new JComponent[]{this._panelReporterValue, _tabbedPaneNamedBean, this._tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("ActionReporter_Components"), components);
        for (JComponent c : componentList) {
            this.panel.add(c);
        }
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        ActionReporter action = new ActionReporter("IQDA1", null);
        this._selectNamedBeanSwing.validate(action.getSelectNamedBean(), errorMessages);
        this.validateDataSection(errorMessages);
        return errorMessages.isEmpty();
    }

    private void validateDataSection(List<String> errorMessages) {
        block10: {
            ActionReporter action = new ActionReporter("IQDA3", null);
            try {
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataReference(this._dataReferenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return;
            }
            try {
                action.setDataFormula(this._dataFormulaTextField.getText());
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    break block10;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    break block10;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
            }
        }
        if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect && this._memorySelectPanel.getNamedBean() == null) {
            errorMessages.add(Bundle.getMessage("ActionReporter_ErrorMemory"));
        }
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        ActionReporter action = new ActionReporter(systemName, userName);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        block8: {
            if (!(object instanceof ActionReporter)) {
                throw new IllegalArgumentException("object must be an ActionReporter but is a: " + object.getClass().getName());
            }
            ActionReporter action = (ActionReporter)object;
            this._selectNamedBeanSwing.updateObject(action.getSelectNamedBean());
            try {
                action.getSelectMemoryNamedBean().removeNamedBean();
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataDirect) {
                    action.setDataAddressing(NamedBeanAddressing.Direct);
                    Memory memory = this._memorySelectPanel.getNamedBean();
                    if (memory != null) {
                        NamedBeanHandle<Memory> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(memory.getDisplayName(), memory);
                        action.getSelectMemoryNamedBean().setNamedBean((Memory)((Object)handle));
                    }
                    break block8;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataReference) {
                    action.setDataAddressing(NamedBeanAddressing.Reference);
                    action.setDataReference(this._dataReferenceTextField.getText());
                    break block8;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataLocalVariable) {
                    action.setDataAddressing(NamedBeanAddressing.LocalVariable);
                    action.setDataLocalVariable(this._dataLocalVariableTextField.getText());
                    break block8;
                }
                if (this._tabbedPaneData.getSelectedComponent() == this._panelDataFormula) {
                    action.setDataAddressing(NamedBeanAddressing.Formula);
                    action.setDataFormula(this._dataFormulaTextField.getText());
                    break block8;
                }
                throw new IllegalArgumentException("_tabbedPaneBean has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String toString() {
        return Bundle.getMessage("ActionReporter_Short");
    }

    @Override
    public void setDefaultValues() {
        if (this._memorySelectPanel.getNamedBean() == null) {
            SortedSet set = InstanceManager.getDefault(MemoryManager.class).getNamedBeanSet();
            if (!set.isEmpty()) {
                Memory m = (Memory)set.first();
                this._memorySelectPanel.setDefaultNamedBean(m);
            } else {
                log.error("Memory manager has no memories. Can't set default values");
            }
        }
    }

    @Override
    public void dispose() {
        if (this._memorySelectPanel != null) {
            this._memorySelectPanel.dispose();
        }
    }
}

